/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.Forge;
import forge.assets.FImage;
import forge.deck.CardPool;
import forge.deck.FDeckEditor;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.screens.FScreen;
import forge.screens.TabPageScreen;
import forge.toolbox.FDialog;
import forge.toolbox.GuiChoose;
import forge.util.Callback;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FSideboardDialog
extends FDialog {
    private final SideboardTabs tabs;
    private final Callback<List<PaperCard>> callback;

    public FSideboardDialog(CardPool sideboard, CardPool main, Callback<List<PaperCard>> callback0, String message) {
        super(String.format(Forge.getLocalizer().getMessage("lblUpdateMainFromSideboard", new Object[0]), message), 1);
        this.callback = callback0;
        this.tabs = this.add(new SideboardTabs(sideboard, main));
        this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> this.hide());
        if (sideboard.isEmpty()) {
            this.tabs.setSelectedPage(this.tabs.getMainDeckPage());
        }
    }

    @Override
    public void setVisible(boolean visible0) {
        super.setVisible(visible0);
        if (!visible0) {
            this.callback.run(((SideboardTabs)this.tabs).getMainDeckPage().cardManager.getPool().toFlatList());
        }
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        this.tabs.setBounds(0.0f, 0.0f, width, maxHeight);
        return maxHeight;
    }

    private static class SideboardTabs
    extends TabPageScreen<SideboardTabs> {
        private SideboardTabs(CardPool sideboard, CardPool main) {
            super(new TabPageBase[]{new SideboardPage(sideboard), new MainDeckPage(main)}, false);
            ((SideboardPage)this.tabPages.get((int)0)).parent = this;
            ((MainDeckPage)this.tabPages.get((int)1)).parent = this;
        }

        private SideboardPage getSideboardPage() {
            return (SideboardPage)this.tabPages.get(0);
        }

        private MainDeckPage getMainDeckPage() {
            return (MainDeckPage)this.tabPages.get(1);
        }

        @Override
        protected boolean canActivateTabPage() {
            return true;
        }

        @Override
        public FScreen getLandscapeBackdropScreen() {
            return null;
        }

        private static class MainDeckPage
        extends TabPageBase {
            protected MainDeckPage(CardPool cardPool) {
                super(cardPool, (FImage)FDeckEditor.MAIN_DECK_ICON);
                this.cardManager.setCaption(Forge.getLocalizer().getMessage("ttMain", new Object[0]));
            }

            @Override
            protected void updateCaption() {
                this.caption = Forge.getLocalizer().getMessage("ttMain", new Object[0]) + " (" + this.cardManager.getPool().countAll() + ")";
            }

            @Override
            protected void onCardActivated(PaperCard card) {
                this.removeCard(card, 1);
                this.parent.getSideboardPage().addCard(card, 1);
            }

            @Override
            protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
                this.addItem(menu, Forge.getLocalizer().getMessage("lblMove", new Object[0]), Forge.getLocalizer().getMessage("lbltosideboard", new Object[0]), FDeckEditor.SIDEBOARD_ICON, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        this.removeCard(card, result);
                        parent.getSideboardPage().addCard(card, result);
                    }
                });
            }
        }

        private static class SideboardPage
        extends TabPageBase {
            protected SideboardPage(CardPool cardPool) {
                super(cardPool, (FImage)FDeckEditor.SIDEBOARD_ICON);
                this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblSideboard", new Object[0]));
            }

            @Override
            protected void updateCaption() {
                this.caption = Forge.getLocalizer().getMessage("lblSideboard", new Object[0]) + " (" + this.cardManager.getPool().countAll() + ")";
            }

            @Override
            protected void onCardActivated(PaperCard card) {
                this.removeCard(card, 1);
                this.parent.getMainDeckPage().addCard(card, 1);
            }

            @Override
            protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
                this.addItem(menu, Forge.getLocalizer().getMessage("lblMove", new Object[0]), Forge.getLocalizer().getMessage("lblToMainDeck", new Object[0]), FDeckEditor.MAIN_DECK_ICON, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        this.removeCard(card, result);
                        parent.getMainDeckPage().addCard(card, result);
                    }
                });
            }
        }

        private static abstract class TabPageBase
        extends TabPageScreen.TabPage<SideboardTabs> {
            protected SideboardTabs parent;
            protected final CardManager cardManager = this.add(new CardManager(false));

            protected TabPageBase(CardPool cardPool, FImage icon0) {
                super("", icon0);
                this.cardManager.setItemActivateHandler(e -> this.onCardActivated((PaperCard)this.cardManager.getSelectedItem()));
                this.cardManager.setContextMenuBuilder(new ItemManager.ContextMenuBuilder<PaperCard>(){

                    @Override
                    public void buildMenu(FDropDownMenu menu, PaperCard card) {
                        this.buildMenu(menu, card);
                    }
                });
                this.cardManager.setup(ItemManagerConfig.SIDEBOARD);
                this.cardManager.setPool(new CardPool(cardPool));
                this.updateCaption();
            }

            protected void addCard(PaperCard card, int qty) {
                this.cardManager.addItem(card, qty);
                this.updateCaption();
            }

            protected void removeCard(PaperCard card, int qty) {
                this.cardManager.removeItem(card, qty);
                this.updateCaption();
            }

            protected void addItem(FDropDownMenu menu, String verb, String dest, FImage icon, Callback<Integer> callback) {
                String label = verb;
                if (!StringUtils.isEmpty(dest)) {
                    label = label + " " + dest;
                }
                menu.addItem(new FMenuItem(label, icon, e -> {
                    PaperCard card = (PaperCard)this.cardManager.getSelectedItem();
                    int max = this.cardManager.getItemCount(card);
                    if (max == 1) {
                        callback.run(max);
                    } else {
                        GuiChoose.getInteger(card + " - " + verb + " " + Forge.getLocalizer().getMessage("lblHowMany", new Object[0]), 1, max, 20, callback);
                    }
                }));
            }

            protected abstract void updateCaption();

            protected abstract void onCardActivated(PaperCard var1);

            protected abstract void buildMenu(FDropDownMenu var1, PaperCard var2);

            @Override
            protected void doLayout(float width, float height) {
                this.cardManager.setBounds(0.0f, 0.0f, width, height);
            }
        }
    }
}

