/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.Forge;
import forge.Graphics;
import forge.StaticData;
import forge.deck.Deck;
import forge.deck.DeckImportController;
import forge.deck.DeckRecognizer;
import forge.deck.DeckSection;
import forge.deck.FDeckEditor;
import forge.game.GameType;
import forge.gui.FThreads;
import forge.gui.util.SOptionPane;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FDialog;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTextArea;
import forge.util.Callback;
import java.util.ArrayList;
import java.util.List;

public class FDeckImportDialog
extends FDialog {
    private Callback<Deck> callback;
    private final FTextArea txtInput = this.add(new FTextArea(true));
    private final FCheckBox newEditionCheck = this.add(new FCheckBox(Forge.getLocalizer().getMessage("lblImportLatestVersionCard", new Object[0]), false));
    private final FCheckBox dateTimeCheck = this.add(new FCheckBox(Forge.getLocalizer().getMessage("lblUseOnlySetsReleasedBefore", new Object[0]), false));
    private final FCheckBox smartCardArtCheck = this.add(new FCheckBox(Forge.getLocalizer().getMessage("lblUseSmartCardArt", new Object[0]), false));
    private final FCheckBox createNewDeckCheck = this.add(new FCheckBox(Forge.getLocalizer().getMessage("lblNewDeckCheckbox", new Object[0]), false));
    private final FCheckBox onlyCoreExpCheck = this.add(new FCheckBox(Forge.getLocalizer().getMessage("lblUseOnlyCoreAndExpansionSets", new Object[0]), false));
    private final FComboBox<String> monthDropdown = this.add(new FComboBox());
    private final FComboBox<Integer> yearDropdown = this.add(new FComboBox());
    private final boolean showOptions;
    private final boolean currentDeckIsEmpty;
    private boolean createNewDeckControl;
    private final DeckImportController controller;
    private static final ImmutableList<String> importOrCancel = ImmutableList.of(Forge.getLocalizer().getMessage("lblImport", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]));

    public FDeckImportDialog(boolean replacingDeck, FDeckEditor.EditorType editorType) {
        super(Forge.getLocalizer().getMessage("lblImportFromClipboard", new Object[0]), 2);
        this.controller = new DeckImportController(this.dateTimeCheck, this.monthDropdown, this.yearDropdown, replacingDeck);
        String contents = Forge.getClipboard().getContents();
        if (contents == null) {
            contents = "";
        }
        this.txtInput.setText(contents);
        if (FDeckEditor.allowsReplacement(editorType)) {
            GameType gameType = GameType.valueOf(editorType.name());
            this.controller.setGameFormat(gameType);
            ArrayList<DeckSection> supportedSections = new ArrayList<DeckSection>();
            supportedSections.add(DeckSection.Main);
            supportedSections.add(DeckSection.Sideboard);
            if (editorType != FDeckEditor.EditorType.Constructed) {
                supportedSections.add(DeckSection.Commander);
            }
            supportedSections.addAll(Lists.newArrayList(FDeckEditor.getExtraSections(editorType)));
            this.controller.setAllowedSections(supportedSections);
        }
        this.onlyCoreExpCheck.setSelected(StaticData.instance().isCoreExpansionOnlyFilterSet());
        this.newEditionCheck.setSelected(StaticData.instance().cardArtPreferenceIsLatest());
        this.smartCardArtCheck.setSelected(StaticData.instance().isEnabledCardArtSmartSelection());
        this.createNewDeckCheck.setSelected(replacingDeck);
        this.currentDeckIsEmpty = !replacingDeck;
        this.createNewDeckControl = replacingDeck;
        this.initButton(0, Forge.getLocalizer().getMessage("lblImport", new Object[0]), e -> FThreads.invokeInBackgroundThread(() -> {
            List<DeckRecognizer.Token> tokens = this.controller.parseInput(this.txtInput.getText());
            if (this.controller.isSmartCardArtEnabled()) {
                tokens = this.controller.optimiseCardArtInTokens();
            }
            StringBuilder sb = new StringBuilder();
            for (DeckRecognizer.Token token : tokens) {
                if (token.getType() != DeckRecognizer.TokenType.CARD_FROM_NOT_ALLOWED_SET && token.getType() != DeckRecognizer.TokenType.CARD_FROM_INVALID_SET && token.getType() != DeckRecognizer.TokenType.UNKNOWN_CARD && token.getType() != DeckRecognizer.TokenType.UNSUPPORTED_CARD) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(token.getQuantity()).append(" ").append(token.getText());
            }
            if (sb.length() > 0 && SOptionPane.showOptionDialog(Forge.getLocalizer().getMessage("lblFollowingCardsCannotBeImported", new Object[0]) + "\n\n" + sb, Forge.getLocalizer().getMessage("lblImportRemainingCards", new Object[0]), SOptionPane.INFORMATION_ICON, importOrCancel) == 1) {
                return;
            }
            Deck deck = this.controller.accept();
            if (deck == null) {
                return;
            }
            FThreads.invokeInEdtLater(() -> {
                this.hide();
                if (this.callback != null) {
                    this.callback.run(deck);
                }
            });
        }));
        this.initButton(1, Forge.getLocalizer().getMessage("lblCancel", new Object[0]), e -> this.hide());
        List<DeckRecognizer.Token> tokens = this.controller.parseInput(this.txtInput.getText());
        if (this.controller.isSmartCardArtEnabled()) {
            tokens = this.controller.optimiseCardArtInTokens();
        }
        for (DeckRecognizer.Token token : tokens) {
            if (token.getType() != DeckRecognizer.TokenType.LEGAL_CARD) continue;
            this.showOptions = true;
            this.dateTimeCheck.setCommand(e -> this.updateDropDownEnabled());
            this.newEditionCheck.setCommand(e -> this.setArtPreferenceInController());
            this.onlyCoreExpCheck.setCommand(e -> this.setArtPreferenceInController());
            this.smartCardArtCheck.setCommand(e -> this.controller.setSmartCardArtOptimisation(this.smartCardArtCheck.isSelected()));
            this.createNewDeckCheck.setCommand(e -> {
                this.createNewDeckControl = this.createNewDeckCheck.isSelected();
                this.controller.setCreateNewDeck(this.createNewDeckControl);
            });
            this.updateDropDownEnabled();
            this.setArtPreferenceInController();
            return;
        }
        this.showOptions = false;
        this.setButtonEnabled(0, false);
        this.txtInput.setText(Forge.getLocalizer().getMessage("lblNoKnownCardsOnClipboard", new Object[0]));
    }

    private void setArtPreferenceInController() {
        boolean isLatest = this.newEditionCheck.isSelected();
        boolean coreFilter = this.onlyCoreExpCheck.isSelected();
        this.controller.setCardArtPreference(isLatest, coreFilter);
    }

    private void updateDropDownEnabled() {
        boolean enabled = this.dateTimeCheck.isSelected();
        this.monthDropdown.setEnabled(enabled);
        this.yearDropdown.setEnabled(enabled);
    }

    public void setCallback(Callback<Deck> callback0) {
        this.callback = callback0;
    }

    public boolean createNewDeck() {
        return this.createNewDeckControl;
    }

    @Override
    public void drawOverlay(Graphics g2) {
        super.drawOverlay(g2);
        if (this.showOptions) {
            float y = this.txtInput.getTop() - FOptionPane.PADDING;
            g2.drawLine(BORDER_THICKNESS, FDeckImportDialog.getBorderColor(), 0.0f, y, this.getWidth(), y);
        }
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float maxTextBoxHeight;
        float h2;
        float padding;
        float x = padding = FOptionPane.PADDING;
        float y = padding;
        float w = width - 2.0f * padding;
        if (this.showOptions) {
            h2 = this.monthDropdown.getHeight();
            float fieldPadding = padding / 2.0f;
            this.newEditionCheck.setBounds(x, y, w / 2.0f, h2);
            this.onlyCoreExpCheck.setBounds(x + w / 2.0f, y, w / 2.0f, h2);
            this.dateTimeCheck.setBounds(x, y += h2 + fieldPadding, w, h2);
            float dropDownWidth = (w - fieldPadding) / 2.0f;
            this.monthDropdown.setBounds(x, y += h2 + fieldPadding, dropDownWidth, h2);
            this.yearDropdown.setBounds(x + dropDownWidth + fieldPadding, y, dropDownWidth, h2);
            y += h2 + fieldPadding;
            if (!this.currentDeckIsEmpty) {
                this.smartCardArtCheck.setBounds(x, y, w / 2.0f, h2);
                this.createNewDeckCheck.setBounds(x + w / 2.0f, y, w / 2.0f, h2);
            } else {
                this.smartCardArtCheck.setBounds(x, y, w, h2);
            }
            y += h2 + 2.0f * padding;
        }
        if ((h2 = this.txtInput.getPreferredHeight(w)) > (maxTextBoxHeight = maxHeight - y - padding)) {
            h2 = maxTextBoxHeight;
        }
        this.txtInput.setBounds(x, y, w, h2);
        y += h2 + padding;
        if (this.showOptions) {
            h2 = this.newEditionCheck.getHeight();
        }
        return y;
    }
}

