/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.model.FModel;
import forge.util.Localizer;

public enum DeckType {
    CUSTOM_DECK("lblCustomUserDecks"),
    CONSTRUCTED_DECK("lblConstructedDecks"),
    COMMANDER_DECK("lblCommanderDecks"),
    RANDOM_COMMANDER_DECK("lblRandomCommanderDecks"),
    RANDOM_CARDGEN_COMMANDER_DECK("lblRandomCommanderCard-basedDecks"),
    OATHBREAKER_DECK("lblOathbreakerDecks"),
    TINY_LEADERS_DECK("lblTinyLeadersDecks"),
    BRAWL_DECK("lblBrawlDecks"),
    SCHEME_DECK("lblSchemeDecks"),
    PLANAR_DECK("lblPlanarDecks"),
    DRAFT_DECK("lblDraftDecks"),
    SEALED_DECK("lblSealedDecks"),
    PRECONSTRUCTED_DECK("lblPreconstructedDecks"),
    PRECON_COMMANDER_DECK("lblPreconCommanderDecks"),
    QUEST_OPPONENT_DECK("lblQuestOpponentDecks"),
    COLOR_DECK("lblRandomColorDecks"),
    STANDARD_CARDGEN_DECK("lblRandomStandardArchetypeDecks"),
    PIONEER_CARDGEN_DECK("lblRandomPioneerArchetypeDecks"),
    HISTORIC_CARDGEN_DECK("lblRandomHistoricArchetypeDecks"),
    MODERN_CARDGEN_DECK("lblRandomModernArchetypeDecks"),
    LEGACY_CARDGEN_DECK("lblRandomLegacyArchetypeDecks"),
    VINTAGE_CARDGEN_DECK("lblRandomVintageArchetypeDecks"),
    PAUPER_CARDGEN_DECK("lblRandomPauperArchetypeDecks"),
    STANDARD_COLOR_DECK("lblRandomStandardColorDecks"),
    MODERN_COLOR_DECK("lblRandomModernColorDecks"),
    PAUPER_COLOR_DECK("lblRandomPauperColorDecks"),
    THEME_DECK("lblRandomThemeDecks"),
    RANDOM_DECK("lblRandomDecks"),
    NET_DECK("lblNetDecks"),
    NET_COMMANDER_DECK("lblNetCommanderDecks"),
    NET_ARCHIVE_STANDARD_DECK("lblNetArchiveStandardDecks"),
    NET_ARCHIVE_PIONEER_DECK("lblNetArchivePioneerDecks"),
    NET_ARCHIVE_MODERN_DECK("lblNetArchiveModernDecks"),
    NET_ARCHIVE_PAUPER_DECK("lblNetArchivePauperDecks"),
    NET_ARCHIVE_LEGACY_DECK("lblNetArchiveLegacyDecks"),
    NET_ARCHIVE_VINTAGE_DECK("lblNetArchiveVintageDecks"),
    NET_ARCHIVE_BLOCK_DECK("lblNetArchiveBlockDecks");

    public static DeckType[] ConstructedOptions;
    public static DeckType[] CommanderOptions;
    private String value;

    private DeckType(String value) {
        Localizer localizer = Localizer.getInstance();
        this.value = localizer.getMessage(value, new Object[0]);
    }

    public String toString() {
        return this.value;
    }

    static {
        ConstructedOptions = FModel.isdeckGenMatrixLoaded() ? new DeckType[]{CUSTOM_DECK, PRECONSTRUCTED_DECK, QUEST_OPPONENT_DECK, COLOR_DECK, STANDARD_COLOR_DECK, MODERN_COLOR_DECK, PAUPER_COLOR_DECK, STANDARD_CARDGEN_DECK, MODERN_CARDGEN_DECK, PAUPER_CARDGEN_DECK, LEGACY_CARDGEN_DECK, VINTAGE_CARDGEN_DECK, PIONEER_CARDGEN_DECK, HISTORIC_CARDGEN_DECK, THEME_DECK, RANDOM_DECK, NET_DECK, NET_ARCHIVE_STANDARD_DECK, NET_ARCHIVE_PIONEER_DECK, NET_ARCHIVE_MODERN_DECK, NET_ARCHIVE_PAUPER_DECK, NET_ARCHIVE_LEGACY_DECK, NET_ARCHIVE_VINTAGE_DECK, NET_ARCHIVE_BLOCK_DECK} : new DeckType[]{CUSTOM_DECK, PRECONSTRUCTED_DECK, QUEST_OPPONENT_DECK, COLOR_DECK, STANDARD_COLOR_DECK, MODERN_COLOR_DECK, PAUPER_COLOR_DECK, THEME_DECK, RANDOM_DECK, NET_DECK, NET_ARCHIVE_STANDARD_DECK, NET_ARCHIVE_PIONEER_DECK, NET_ARCHIVE_MODERN_DECK, NET_ARCHIVE_PAUPER_DECK, NET_ARCHIVE_LEGACY_DECK, NET_ARCHIVE_VINTAGE_DECK, NET_ARCHIVE_BLOCK_DECK};
        CommanderOptions = FModel.isdeckGenMatrixLoaded() ? new DeckType[]{COMMANDER_DECK, PRECON_COMMANDER_DECK, RANDOM_COMMANDER_DECK, RANDOM_CARDGEN_COMMANDER_DECK, RANDOM_DECK, NET_COMMANDER_DECK} : new DeckType[]{COMMANDER_DECK, PRECON_COMMANDER_DECK, RANDOM_COMMANDER_DECK, RANDOM_DECK, NET_COMMANDER_DECK};
    }
}

