/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.card.CardType;
import forge.item.PaperCard;
import java.util.function.Function;

public enum DeckSection {
    Avatar(1, Validators.AVATAR_VALIDATOR),
    Commander(1, Validators.COMMANDER_VALIDATOR),
    Main(60, Validators.DECK_AND_SIDE_VALIDATOR),
    Sideboard(15, Validators.DECK_AND_SIDE_VALIDATOR),
    Planes(10, Validators.PLANES_VALIDATOR),
    Schemes(20, Validators.SCHEME_VALIDATOR),
    Conspiracy(0, Validators.CONSPIRACY_VALIDATOR),
    Dungeon(0, Validators.DUNGEON_VALIDATOR),
    Attractions(0, Validators.ATTRACTION_VALIDATOR);

    public static final DeckSection[] NONTRADITIONAL_SECTIONS;
    private final int typicalSize;
    private Function<PaperCard, Boolean> fnValidator;

    private DeckSection(int commonSize, Function<PaperCard, Boolean> validator) {
        this.typicalSize = commonSize;
        this.fnValidator = validator;
    }

    public boolean isSingleCard() {
        return this.typicalSize == 1;
    }

    public boolean validate(PaperCard card) {
        if (this.fnValidator == null) {
            return true;
        }
        return this.fnValidator.apply(card);
    }

    public static DeckSection matchingSection(PaperCard card) {
        if (Conspiracy.validate(card)) {
            return Conspiracy;
        }
        if (Schemes.validate(card)) {
            return Schemes;
        }
        if (Avatar.validate(card)) {
            return Avatar;
        }
        if (Planes.validate(card)) {
            return Planes;
        }
        if (Dungeon.validate(card)) {
            return Dungeon;
        }
        if (Attractions.validate(card)) {
            return Attractions;
        }
        return Main;
    }

    public static DeckSection smartValueOf(String value) {
        if (value == null) {
            return null;
        }
        String valToCompare = value.trim();
        for (DeckSection v : DeckSection.values()) {
            if (v.name().compareToIgnoreCase(valToCompare) != 0) continue;
            return v;
        }
        return null;
    }

    static {
        NONTRADITIONAL_SECTIONS = new DeckSection[]{Avatar, Planes, Schemes, Conspiracy, Dungeon, Attractions};
    }

    private static class Validators {
        static final Function<PaperCard, Boolean> DECK_AND_SIDE_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return !t2.isConspiracy() && !t2.isDungeon() && !t2.isPhenomenon() && !t2.isPlane() && !t2.isScheme() && !t2.isVanguard();
        };
        static final Function<PaperCard, Boolean> COMMANDER_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return card.getRules().canBeCommander() || t2.isPlaneswalker() || card.getRules().canBeOathbreaker() || card.getRules().canBeSignatureSpell();
        };
        static final Function<PaperCard, Boolean> PLANES_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return t2.isPlane() || t2.isPhenomenon();
        };
        static final Function<PaperCard, Boolean> DUNGEON_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return t2.isDungeon();
        };
        static final Function<PaperCard, Boolean> SCHEME_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return t2.isScheme();
        };
        static final Function<PaperCard, Boolean> CONSPIRACY_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return t2.isConspiracy();
        };
        static final Function<PaperCard, Boolean> AVATAR_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return t2.isVanguard();
        };
        static final Function<PaperCard, Boolean> ATTRACTION_VALIDATOR = card -> {
            CardType t2 = card.getRules().getType();
            return t2.isAttraction();
        };

        private Validators() {
        }
    }
}

