/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.ColorSet;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckGeneratorTheme;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.deck.NetDeckArchiveBlock;
import forge.deck.NetDeckArchiveLegacy;
import forge.deck.NetDeckArchiveModern;
import forge.deck.NetDeckArchivePauper;
import forge.deck.NetDeckArchivePioneer;
import forge.deck.NetDeckArchiveStandard;
import forge.deck.NetDeckArchiveVintage;
import forge.deck.NetDeckCategory;
import forge.deck.io.DeckPreferences;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.PreconDeck;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.BinaryUtil;
import forge.util.IHasName;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DeckProxy
implements InventoryItem {
    protected IHasName deck;
    protected final String deckType;
    protected final IStorage<? extends IHasName> storage;
    protected ColorSet color;
    protected ColorSet colorIdentity;
    protected Set<GameFormat> formats;
    protected Set<GameFormat> exhaustiveFormats;
    private Integer mainSize = null;
    private Integer sbSize = null;
    private Integer avgCMC = null;
    private final String path;
    private final Function<IHasName, Deck> fnGetDeck;
    private CardEdition edition;
    private CardRarity highestRarity;
    public static final Predicate<DeckProxy> IS_WHITE = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && cs.hasAnyColor(1);
    };
    public static final Predicate<DeckProxy> IS_BLUE = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && cs.hasAnyColor(2);
    };
    public static final Predicate<DeckProxy> IS_BLACK = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && cs.hasAnyColor(4);
    };
    public static final Predicate<DeckProxy> IS_RED = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && cs.hasAnyColor(8);
    };
    public static final Predicate<DeckProxy> IS_GREEN = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && cs.hasAnyColor(16);
    };
    public static final Predicate<DeckProxy> IS_COLORLESS = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && cs.getColor() == 0;
    };
    public static final Predicate<DeckProxy> IS_MULTICOLOR = deck -> {
        ColorSet cs = deck.getColor();
        return cs != null && BinaryUtil.bitCount(cs.getColor()) > 1;
    };

    protected DeckProxy() {
        this(null, "", null, "", null, null);
    }

    public DeckProxy(Deck deck, String deckType, GameType type, IStorage<? extends IHasName> storage) {
        this(deck, deckType, type, "", storage, null);
    }

    public DeckProxy(IHasName deck, String deckType, Function<IHasName, Deck> fnGetDeck, GameType type, IStorage<? extends IHasName> storage) {
        this(deck, deckType, type, "", storage, fnGetDeck);
    }

    private DeckProxy(IHasName deck, String deckType, GameType type, String path, IStorage<? extends IHasName> storage, Function<IHasName, Deck> fnGetDeck) {
        this.deck = deck;
        this.deckType = deckType;
        this.storage = storage;
        this.path = path;
        this.fnGetDeck = fnGetDeck;
    }

    @Override
    public String getName() {
        return this.deck.getName();
    }

    @Override
    public String getItemType() {
        return "Deck";
    }

    public Deck getDeck() {
        return this.deck instanceof Deck && this.fnGetDeck == null ? (Deck)this.deck : this.fnGetDeck.apply(this.deck);
    }

    public String getPath() {
        return this.path;
    }

    public CardEdition getEdition() {
        if (this.edition == null) {
            if (this.deck instanceof PreconDeck) {
                this.edition = StaticData.instance().getEditions().get(((PreconDeck)this.deck).getEdition());
            } else if (!this.isGeneratedDeck()) {
                this.edition = StaticData.instance().getEditions().getTheLatestOfAllTheOriginalEditionsOfCardsIn(this.getDeck().getAllCardsInASinglePool());
            }
        }
        return this.edition;
    }

    public String getUniqueKey() {
        if (this.deck == null) {
            return "";
        }
        return this.deckType + "|" + this.path + "|" + this.deck.getName();
    }

    public String toString() {
        if (this.deck == null) {
            return "";
        }
        return DeckProxy.getDeckString(this.path, this.deck.getName());
    }

    public static String getDeckString(String path, String name) {
        if (StringUtils.isEmpty(path)) {
            return name;
        }
        return path + "/" + name;
    }

    public static String getDeckDirectory(IStorage<?> currentFolder) {
        String directory = currentFolder.getFullPath();
        if (directory.startsWith(ForgeConstants.DECK_BASE_DIR)) {
            directory = directory.substring(ForgeConstants.DECK_BASE_DIR.length());
        }
        return directory;
    }

    public void invalidateCache() {
        this.color = null;
        this.colorIdentity = null;
        this.highestRarity = null;
        this.formats = null;
        this.exhaustiveFormats = null;
        this.edition = null;
        this.mainSize = null;
        this.sbSize = null;
    }

    public ColorSet getColor() {
        if (this.color == null && !this.isGeneratedDeck()) {
            int colorProfile = 0;
            byte landProfile = 0;
            HashSet<Byte> nonReqColors = null;
            block3: for (Map.Entry<DeckSection, CardPool> deckEntry : this.getDeck()) {
                switch (deckEntry.getKey()) {
                    case Main: 
                    case Commander: {
                        for (Map.Entry poolEntry : deckEntry.getValue()) {
                            CardRules rules = ((PaperCard)poolEntry.getKey()).getRules();
                            if (rules.getType().isLand()) {
                                landProfile = (byte)(landProfile | rules.getColorIdentity().getColor());
                                continue;
                            }
                            for (ManaCostShard shard : rules.getManaCost()) {
                                if (shard.isPhyrexian() || shard.isOr2Generic() || !shard.isMonoColor()) {
                                    if (nonReqColors == null) {
                                        nonReqColors = new HashSet<Byte>();
                                    }
                                    nonReqColors.add(shard.getColorMask());
                                    continue;
                                }
                                colorProfile = (byte)(colorProfile | shard.getColorMask());
                            }
                        }
                        continue block3;
                    }
                }
            }
            if (nonReqColors != null) {
                for (Byte colorMask : nonReqColors) {
                    colorProfile = (byte)(colorProfile | colorMask & landProfile);
                }
            }
            this.color = ColorSet.fromMask(colorProfile);
        }
        return this.color;
    }

    public ColorSet getColorIdentity() {
        if (this.colorIdentity == null) {
            int colorProfile = 0;
            block3: for (Map.Entry<DeckSection, CardPool> deckEntry : this.getDeck()) {
                switch (deckEntry.getKey()) {
                    case Main: 
                    case Commander: 
                    case Sideboard: {
                        for (Map.Entry poolEntry : deckEntry.getValue()) {
                            colorProfile = (byte)(colorProfile | ((PaperCard)poolEntry.getKey()).getRules().getColorIdentity().getColor());
                        }
                        continue block3;
                    }
                }
            }
            this.colorIdentity = ColorSet.fromMask(colorProfile);
        }
        return this.colorIdentity;
    }

    public static ColorSet getColorIdentity(Deck deck) {
        int colorProfile = 0;
        ColorSet deckIdentity = ColorSet.fromMask(colorProfile);
        if (deck != null) {
            block3: for (Map.Entry<DeckSection, CardPool> deckEntry : deck) {
                switch (deckEntry.getKey()) {
                    case Main: 
                    case Commander: 
                    case Sideboard: {
                        for (Map.Entry poolEntry : deckEntry.getValue()) {
                            colorProfile = (byte)(colorProfile | ((PaperCard)poolEntry.getKey()).getRules().getColorIdentity().getColor());
                        }
                        continue block3;
                    }
                }
            }
            deckIdentity = ColorSet.fromMask(colorProfile);
        }
        return deckIdentity;
    }

    public int getColorIdentityforAdventure() {
        return DeckProxy.getColorIdentityforAdventure(this.getDeck());
    }

    public static int getColorIdentityforAdventure(Deck deck) {
        int adventureColorIdentity = 0;
        int w = 0;
        int u = 0;
        int b = 0;
        int g2 = 0;
        int r = 0;
        int highest = -1;
        block3: for (Map.Entry<DeckSection, CardPool> deckEntry : deck) {
            switch (deckEntry.getKey()) {
                case Main: 
                case Commander: 
                case Sideboard: {
                    for (Map.Entry poolEntry : deckEntry.getValue()) {
                        if (((PaperCard)poolEntry.getKey()).getRules().getType().isLand()) continue;
                        w += ((PaperCard)poolEntry.getKey()).getRules().getManaCost().getShardCount(ManaCostShard.WHITE);
                        u += ((PaperCard)poolEntry.getKey()).getRules().getManaCost().getShardCount(ManaCostShard.BLUE);
                        b += ((PaperCard)poolEntry.getKey()).getRules().getManaCost().getShardCount(ManaCostShard.BLACK);
                        g2 += ((PaperCard)poolEntry.getKey()).getRules().getManaCost().getShardCount(ManaCostShard.GREEN);
                        r += ((PaperCard)poolEntry.getKey()).getRules().getManaCost().getShardCount(ManaCostShard.RED);
                    }
                    continue block3;
                }
            }
        }
        if (w > highest) {
            highest = w;
            adventureColorIdentity = 1;
        }
        if (u > highest) {
            highest = u;
            adventureColorIdentity = 3;
        }
        if (b > highest) {
            highest = b;
            adventureColorIdentity = 2;
        }
        if (g2 > highest) {
            highest = g2;
            adventureColorIdentity = 5;
        }
        if (r > highest) {
            highest = r;
            adventureColorIdentity = 4;
        }
        if (highest == 0) {
            adventureColorIdentity = 0;
        }
        return adventureColorIdentity;
    }

    public Deck.UnplayableAICards getAI() {
        return this.getDeck().getUnplayableAICards();
    }

    public CardRarity getHighestRarity() {
        if (this.highestRarity == null) {
            this.highestRarity = CardRarity.Common;
            block9: for (Map.Entry<DeckSection, CardPool> deckEntry : this.getDeck()) {
                switch (deckEntry.getKey()) {
                    case Main: 
                    case Commander: 
                    case Sideboard: {
                        for (Map.Entry poolEntry : deckEntry.getValue()) {
                            switch (((PaperCard)poolEntry.getKey()).getRarity()) {
                                case MythicRare: {
                                    this.highestRarity = CardRarity.MythicRare;
                                    return this.highestRarity;
                                }
                                case Special: {
                                    this.highestRarity = CardRarity.Special;
                                    break;
                                }
                                case Rare: {
                                    if (this.highestRarity == CardRarity.Special) break;
                                    this.highestRarity = CardRarity.Rare;
                                    break;
                                }
                                case Uncommon: {
                                    if (this.highestRarity == CardRarity.Rare || this.highestRarity == CardRarity.Special) break;
                                    this.highestRarity = CardRarity.Uncommon;
                                    break;
                                }
                            }
                        }
                        continue block9;
                    }
                }
            }
        }
        return this.highestRarity;
    }

    public PaperCard getHighestCMCCard() {
        PaperCard key = null;
        HashMap<PaperCard, Integer> keyCMC = new HashMap<PaperCard, Integer>(64);
        for (Map.Entry pc : this.getDeck().getAllCardsInASinglePool()) {
            if (((PaperCard)pc.getKey()).getRules().getManaCost() == null || ((PaperCard)pc.getKey()).getRules().getType().hasSubtype("Saga") || ((PaperCard)pc.getKey()).getRules().getType().hasSubtype("Class") || CardSplitType.Split.equals((Object)((PaperCard)pc.getKey()).getRules().getSplitType())) continue;
            keyCMC.put((PaperCard)pc.getKey(), ((PaperCard)pc.getKey()).getRules().getManaCost().getCMC());
        }
        if (!keyCMC.isEmpty()) {
            int max = (Integer)Collections.max(keyCMC.values());
            for (Map.Entry entry : keyCMC.entrySet()) {
                if ((Integer)entry.getValue() != max) continue;
                return (PaperCard)entry.getKey();
            }
        }
        return key;
    }

    public Set<GameFormat> getFormats() {
        if (this.formats == null) {
            this.formats = FModel.getFormats().getAllFormatsOfDeck(this.getDeck());
        }
        return this.formats;
    }

    public Set<GameFormat> getExhaustiveFormats() {
        if (this.exhaustiveFormats == null) {
            this.exhaustiveFormats = FModel.getFormats().getAllFormatsOfDeck(this.getDeck(), true);
        }
        return this.exhaustiveFormats;
    }

    public String getFormatsString() {
        Set<GameFormat> formats = this.getFormats();
        if (formats.size() > 1) {
            return StringUtils.join(Iterables.transform(formats, GameFormat::getName), ", ");
        }
        Object[] formatArray = formats.toArray();
        GameFormat format = (GameFormat)formatArray[0];
        if (format != GameFormat.NoFormat) {
            return format.getName();
        }
        if (this.isCustomDeckFormat()) {
            return "Custom Cards Deck";
        }
        return "No Format";
    }

    private boolean isCustomDeckFormat() {
        Deck deck = this.getDeck();
        CardPool cards = deck.getAllCardsInASinglePool();
        CardEdition.Collection customEditions = StaticData.instance().getEditions();
        for (Map.Entry entry : cards) {
            String setCode = ((PaperCard)entry.getKey()).getEdition();
            CardEdition E = customEditions.getEditionByCodeOrThrow(setCode);
            if (E == null || E.getType() != CardEdition.Type.CUSTOM_SET) continue;
            return true;
        }
        return false;
    }

    public int getMainSize() {
        if (this.mainSize == null) {
            if (this.deck == null) {
                this.mainSize = -1;
            } else {
                Deck d = this.getDeck();
                this.mainSize = d.getMain().countAll();
                CardPool commander = d.get(DeckSection.Commander);
                if (commander != null) {
                    this.mainSize = this.mainSize + commander.countAll();
                }
            }
        }
        return this.mainSize;
    }

    public int getSideSize() {
        if (this.sbSize == null) {
            CardPool sb = this.getDeck().get(DeckSection.Sideboard);
            this.sbSize = sb == null ? -1 : sb.countAll();
            if (this.sbSize == 0) {
                this.sbSize = -1;
            }
        }
        return this.sbSize;
    }

    public Integer getAverageCMC() {
        if (this.avgCMC == null) {
            this.avgCMC = Deck.getAverageCMC(this.getDeck());
        }
        return this.avgCMC;
    }

    public boolean isGeneratedDeck() {
        return false;
    }

    public boolean isFavoriteDeck() {
        return DeckPreferences.getPrefs(this).getStarCount() > 0;
    }

    public static Iterable<DeckProxy> getAllConstructedDecks() {
        return DeckProxy.getAllConstructedDecks(null);
    }

    public static Iterable<DeckProxy> getAllConstructedDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, result, "", FModel.getDecks().getConstructed(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllCommanderDecks() {
        return DeckProxy.getAllCommanderDecks(null);
    }

    public static Iterable<DeckProxy> getAllCommanderDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        DeckProxy.addDecksRecursivelly("Commander", GameType.Commander, result, "", FModel.getDecks().getCommander(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllOathbreakerDecks() {
        return DeckProxy.getAllOathbreakerDecks(null);
    }

    public static Iterable<DeckProxy> getAllOathbreakerDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        DeckProxy.addDecksRecursivelly("Oathbreaker", GameType.Oathbreaker, result, "", FModel.getDecks().getOathbreaker(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllCommanderPreconDecks() {
        return DeckProxy.getAllCommanderPreconDecks(null);
    }

    public static Iterable<DeckProxy> getAllCommanderPreconDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        DeckProxy.addDecksRecursivelly("Commander Precon", GameType.Commander, result, "", FModel.getDecks().getCommanderPrecons(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllTinyLeadersDecks() {
        return DeckProxy.getAllTinyLeadersDecks(null);
    }

    public static Iterable<DeckProxy> getAllTinyLeadersDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        filter = filter == null ? DeckFormat.TinyLeaders.hasLegalCardsPredicate(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) : Predicates.and(DeckFormat.TinyLeaders.hasLegalCardsPredicate(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)), filter);
        DeckProxy.addDecksRecursivelly("Tiny Leaders", GameType.TinyLeaders, result, "", FModel.getDecks().getTinyLeaders(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllBrawlDecks() {
        return DeckProxy.getAllBrawlDecks(null);
    }

    public static Iterable<DeckProxy> getAllBrawlDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        filter = filter == null ? DeckFormat.Brawl.hasLegalCardsPredicate(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) : Predicates.and(DeckFormat.Brawl.hasLegalCardsPredicate(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)), filter);
        DeckProxy.addDecksRecursivelly("Brawl", GameType.Brawl, result, "", FModel.getDecks().getBrawl(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllSchemeDecks() {
        return DeckProxy.getAllSchemeDecks(null);
    }

    public static Iterable<DeckProxy> getAllSchemeDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        DeckProxy.addDecksRecursivelly("Scheme", GameType.Archenemy, result, "", FModel.getDecks().getScheme(), filter);
        return result;
    }

    public static Iterable<DeckProxy> getAllPlanarDecks() {
        return DeckProxy.getAllPlanarDecks(null);
    }

    public static Iterable<DeckProxy> getAllPlanarDecks(Predicate<Deck> filter) {
        ArrayList<DeckProxy> result = new ArrayList<DeckProxy>();
        DeckProxy.addDecksRecursivelly("Plane", GameType.Planechase, result, "", FModel.getDecks().getPlane(), filter);
        return result;
    }

    private static void addDecksRecursivelly(String deckType, GameType gameType, List<DeckProxy> list, String path, IStorage<Deck> folder, Predicate<Deck> filter) {
        for (IStorage iStorage : folder.getFolders()) {
            String subPath = (StringUtils.isBlank(path) ? "" : path) + "/" + iStorage.getName();
            DeckProxy.addDecksRecursivelly(deckType, gameType, list, subPath, iStorage, filter);
        }
        for (Deck deck : folder) {
            if (filter != null && !filter.apply(deck)) continue;
            list.add(new DeckProxy(deck, deckType, gameType, path, folder, null));
        }
    }

    public static final Predicate<DeckProxy> createPredicate(Predicate<PaperCard> cardPredicate) {
        return input -> {
            block3: for (Map.Entry<DeckSection, CardPool> deckEntry : input.getDeck()) {
                switch (deckEntry.getKey()) {
                    case Main: 
                    case Commander: 
                    case Sideboard: {
                        for (Map.Entry poolEntry : deckEntry.getValue()) {
                            if (cardPredicate.apply((PaperCard)poolEntry.getKey())) continue;
                            return false;
                        }
                        continue block3;
                    }
                }
            }
            return true;
        };
    }

    public void reloadFromStorage() {
        if (this.storage != null) {
            this.deck = this.storage.get(this.getName());
        }
        this.invalidateCache();
    }

    public void deleteFromStorage() {
        if (this.storage != null) {
            this.storage.delete(this.getName());
        }
    }

    public static List<DeckProxy> getAllThemeDecks() {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (String s2 : DeckGeneratorTheme.getThemeNames()) {
            decks.add(new ThemeDeckGenerator(s2));
        }
        return decks;
    }

    public static List<DeckProxy> getAllPreconstructedDecks(IStorage<PreconDeck> iStorage) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (PreconDeck preconDeck : iStorage) {
            decks.add(new DeckProxy(preconDeck, "Precon", PreconDeck::getDeck, null, iStorage));
        }
        return decks;
    }

    public static List<DeckProxy> getAllQuestEventAndChallenges() {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        QuestController quest = FModel.getQuest();
        for (QuestEvent questEvent : quest.getDuelsManager().getAllDuels()) {
            decks.add(new DeckProxy(questEvent.getEventDeck(), "Quest Event", null, null));
        }
        for (QuestEvent questEvent : quest.getChallenges()) {
            decks.add(new DeckProxy(questEvent.getEventDeck(), "Quest Event", null, null));
        }
        return decks;
    }

    public static Map<DeckProxy, Pair<List<String>, List<String>>> getAllQuestChallenges() {
        HashMap<DeckProxy, Pair<List<String>, List<String>>> deckMap = new HashMap<DeckProxy, Pair<List<String>, List<String>>>();
        QuestController quest = FModel.getQuest();
        for (QuestEvent questEvent : quest.getChallenges()) {
            ImmutablePair<List<String>, List<String>> extras = new ImmutablePair<List<String>, List<String>>(questEvent.getHumanExtraCards(), questEvent.getAiExtraCards());
            deckMap.put(new DeckProxy(questEvent.getEventDeck(), "Quest Event", null, null), extras);
        }
        return deckMap;
    }

    public static List<DeckProxy> getNonEasyQuestDuelDecks() {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        QuestController quest = FModel.getQuest();
        for (QuestEvent questEvent : quest.getDuelsManager().getDuels(QuestEventDifficulty.MEDIUM)) {
            decks.add(new DeckProxy(questEvent.getEventDeck(), "Quest Event", null, null));
        }
        for (QuestEvent questEvent : quest.getDuelsManager().getDuels(QuestEventDifficulty.HARD)) {
            decks.add(new DeckProxy(questEvent.getEventDeck(), "Quest Event", null, null));
        }
        for (QuestEvent questEvent : quest.getDuelsManager().getDuels(QuestEventDifficulty.EXPERT)) {
            decks.add(new DeckProxy(questEvent.getEventDeck(), "Quest Event", null, null));
        }
        return decks;
    }

    public static List<DeckProxy> getAllGeneticAIDecks() {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        IStorage<Deck> genetic = FModel.getDecks().getGeneticAIDecks();
        DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", genetic, null);
        return decks;
    }

    public static List<DeckProxy> getAllCustomStarterDecks() {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        IStorage<Deck> easy = FModel.getDecks().getCustomStarterDecks();
        DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", easy, null);
        return decks;
    }

    public static List<DeckProxy> getAllSealedDecks() {
        ArrayList<DeckProxy> humanDecks = new ArrayList<DeckProxy>();
        IStorage<DeckGroup> sealed = FModel.getDecks().getSealed();
        for (DeckGroup d : sealed) {
            humanDecks.add(new DeckProxy(d, "Sealed", DeckGroup::getHumanDeck, GameType.Sealed, sealed));
        }
        return humanDecks;
    }

    public static List<DeckProxy> getAllQuestDecks(IStorage<Deck> storage) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (storage != null) {
            for (Deck deck : storage) {
                decks.add(new DeckProxy(deck, "Quest", GameType.Quest, storage));
            }
        }
        return decks;
    }

    public static List<DeckProxy> getAllDraftDecks() {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        IStorage<DeckGroup> draft = FModel.getDecks().getDraft();
        for (DeckGroup d : draft) {
            decks.add(new DeckProxy(d, "Draft", DeckGroup::getHumanDeck, GameType.Draft, draft));
        }
        return decks;
    }

    public static List<DeckProxy> getWinstonDecks(IStorage<DeckGroup> draft) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (DeckGroup d : draft) {
            decks.add(new DeckProxy(d, "Winston", DeckGroup::getHumanDeck, GameType.Winston, draft));
        }
        return decks;
    }

    public static List<DeckProxy> getNetDecks(NetDeckCategory category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchiveStandardDecks(NetDeckArchiveStandard category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchiveModernDecks(NetDeckArchiveModern category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchivePioneerDecks(NetDeckArchivePioneer category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchivePauperDecks(NetDeckArchivePauper category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchiveLegacyDecks(NetDeckArchiveLegacy category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchiveVintageDecks(NetDeckArchiveVintage category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static List<DeckProxy> getNetArchiveBlockDecks(NetDeckArchiveBlock category) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        if (category != null) {
            DeckProxy.addDecksRecursivelly("Constructed", GameType.Constructed, decks, "", category, null);
        }
        return decks;
    }

    public static CardEdition getDefaultLandSet(Deck deck) {
        ArrayList<CardEdition> availableEditions = new ArrayList<CardEdition>();
        for (PaperCard c : deck.getAllCardsInASinglePool().toFlatList()) {
            CardEdition edition = FModel.getMagicDb().getEditions().get(c.getEdition());
            if (edition == null) continue;
            availableEditions.add(edition);
        }
        CardEdition randomLandSet = CardEdition.Predicates.getRandomSetWithAllBasicLands(availableEditions);
        if (randomLandSet == null) {
            CardEdition preferredArtEdition = CardEdition.Predicates.getPreferredArtEditionWithAllBasicLands();
            return preferredArtEdition != null ? preferredArtEdition : FModel.getMagicDb().getEditions().get("ZEN");
        }
        return randomLandSet;
    }

    @Override
    public String getImageKey(boolean altState) {
        return null;
    }

    private static class ThemeDeckGenerator
    extends DeckProxy {
        private final String name;

        public ThemeDeckGenerator(String name0) {
            this.name = name0;
        }

        @Override
        public Deck getDeck() {
            DeckGeneratorTheme gen = new DeckGeneratorTheme(FModel.getMagicDb().getCommonCards());
            Deck deck = new Deck();
            gen.setSingleton(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_SINGLETONS));
            gen.setUseArtifacts(!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_ARTIFACTS));
            StringBuilder errorBuilder = new StringBuilder();
            deck.getMain().addAll(gen.getThemeDeck(this.getName(), 60, errorBuilder));
            if (errorBuilder.length() > 0) {
                throw new RuntimeException(errorBuilder.toString());
            }
            return deck;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean isGeneratedDeck() {
            return true;
        }
    }
}

