/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.deck.Deck;
import forge.item.InventoryItem;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class DeckBase
implements Serializable,
Comparable<DeckBase>,
InventoryItem {
    private static final long serialVersionUID = -7538150536939660052L;
    private String name;
    private transient String directory;
    private String comment = null;

    public DeckBase(String name0) {
        this.name = name0.replace('/', '_');
    }

    @Override
    public int compareTo(DeckBase d) {
        return this.name.compareTo(d.name);
    }

    public boolean equals(Object o) {
        if (o instanceof DeckBase) {
            DeckBase d = (DeckBase)o;
            return this.name.equals(d.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * 17 + this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String deckName) {
        this.name = deckName;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory0) {
        this.directory = directory0;
    }

    public String getUniqueKey() {
        if (this.directory == null) {
            return this.name;
        }
        return this.directory + "/" + this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setComment(String comment0) {
        this.comment = comment0;
    }

    public String getComment() {
        return this.comment;
    }

    protected abstract DeckBase newInstance(String var1);

    protected void cloneFieldsTo(DeckBase clone) {
        clone.directory = this.directory;
        clone.comment = this.comment;
    }

    public DeckBase copyTo(String name0) {
        DeckBase obj = this.newInstance(name0);
        this.cloneFieldsTo(obj);
        return obj;
    }

    public final String getBestFileName() {
        String result = this.name.replaceAll("[\\/:*?\"<>|]", "");
        if (result.isEmpty()) {
            String createTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm"));
            return createTime;
        }
        return result;
    }

    public abstract boolean isEmpty();

    public abstract Deck getHumanDeck();
}

