/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicate;
import forge.card.CardEdition;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.item.PaperCard;
import forge.itemmanager.IItemManager;
import java.util.ArrayList;
import java.util.List;

public class ColorDeckGenerator
extends DeckProxy
implements Comparable<ColorDeckGenerator> {
    private final String name;
    private final int index;
    private final IItemManager<DeckProxy> lstDecks;
    private final boolean isAi;
    private final Predicate<PaperCard> formatFilter;

    public static List<DeckProxy> getColorDecks(IItemManager<DeckProxy> lstDecks0, Predicate<PaperCard> formatFilter0, boolean isAi0) {
        String[] colors = new String[]{"Random 1", "Random 2", "Random 3", "White", "Blue", "Black", "Red", "Green"};
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (int i = 0; i < colors.length; ++i) {
            decks.add(new ColorDeckGenerator(colors[i], i, lstDecks0, formatFilter0, isAi0));
        }
        return decks;
    }

    private ColorDeckGenerator(String name0, int index0, IItemManager<DeckProxy> lstDecks0, Predicate<PaperCard> formatFilter0, boolean isAi0) {
        this.name = name0;
        this.index = index0;
        this.lstDecks = lstDecks0;
        this.isAi = isAi0;
        this.formatFilter = formatFilter0;
    }

    @Override
    public CardEdition getEdition() {
        return CardEdition.UNKNOWN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ColorDeckGenerator d) {
        return Integer.compare(this.index, d.index);
    }

    @Override
    public Deck getDeck() {
        ArrayList<String> selection = new ArrayList<String>();
        for (DeckProxy deck : this.lstDecks.getSelectedItems()) {
            selection.add(deck.getName());
        }
        if (DeckgenUtil.colorCheck(selection)) {
            return DeckgenUtil.buildColorDeck(selection, this.formatFilter, this.isAi);
        }
        return null;
    }

    @Override
    public boolean isGeneratedDeck() {
        return true;
    }
}

