/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.card.CardEdition;
import forge.deck.CardArchetypeLDAGenerator;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.game.GameFormat;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.List;

public class CardThemedDeckGenerator
extends DeckProxy
implements Comparable<CardThemedDeckGenerator> {
    private final String name;
    private final int index;
    private final GameFormat format;
    private final boolean isForAi;

    public static List<DeckProxy> getMatrixDecks(GameFormat format, boolean isForAi) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (String card : CardArchetypeLDAGenerator.ldaPools.get(format.getName()).keySet()) {
            if (isForAi && FModel.getMagicDb().getCommonCards().getUniqueByName(card).getRules().getAiHints().getRemAIDecks()) continue;
            decks.add(new CardThemedDeckGenerator(card, format, isForAi));
        }
        return decks;
    }

    private CardThemedDeckGenerator(String cardName, GameFormat format0, boolean isForAi0) {
        this.name = cardName;
        this.index = 0;
        this.format = format0;
        this.isForAi = isForAi0;
    }

    @Override
    public CardEdition getEdition() {
        return CardEdition.UNKNOWN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CardThemedDeckGenerator d) {
        return this.name.compareTo(d.getName());
    }

    @Override
    public Deck getDeck() {
        return DeckgenUtil.buildCardGenDeck(this.name, this.format, this.isForAi);
    }

    @Override
    public boolean isGeneratedDeck() {
        return true;
    }

    @Override
    public String getImageKey(boolean altState) {
        return FModel.getMagicDb().getCommonCards().getUniqueByName(this.name).getImageKey(altState);
    }

    public PaperCard getPaperCard() {
        return FModel.getMagicDb().getCommonCards().getUniqueByName(this.name);
    }
}

