/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardRulesPredicates;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.io.CardThemedMatrixIO;
import forge.deck.io.DeckStorage;
import forge.game.GameFormat;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.storage.StorageImmediatelySerialized;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public final class CardRelationMatrixGenerator {
    public static HashMap<String, HashMap<String, List<Map.Entry<PaperCard, Integer>>>> cardPools = new HashMap();
    public static Map<String, Map<String, List<List<String>>>> ldaPools = new HashMap<String, Map<String, List<List<String>>>>();
    public static final int MIN_REQUIRED_CONNECTIONS = 14;

    public static boolean initialize() {
        return CardRelationMatrixGenerator.initializeFormat(DeckFormat.Commander) && CardRelationMatrixGenerator.initializeFormat(DeckFormat.Oathbreaker);
    }

    public static boolean initializeFormat(DeckFormat format) {
        String formatName = format.toString();
        HashMap<String, List<Map.Entry<PaperCard, Integer>>> formatMap = CardThemedMatrixIO.loadMatrix(formatName);
        if (formatMap == null) {
            if (CardThemedMatrixIO.getMatrixFolder(formatName).exists()) {
                formatMap = formatName.equals(FModel.getFormats().getStandard().getName()) ? CardRelationMatrixGenerator.initializeFormat(FModel.getFormats().getStandard()) : (formatName.equals(FModel.getFormats().getModern().getName()) ? CardRelationMatrixGenerator.initializeFormat(FModel.getFormats().getModern()) : CardRelationMatrixGenerator.initializeCommanderFormat(format));
                CardThemedMatrixIO.saveMatrix(formatName, formatMap);
            } else {
                return false;
            }
        }
        cardPools.put(formatName, formatMap);
        return true;
    }

    public static HashMap<String, List<Map.Entry<PaperCard, Integer>>> initializeFormat(GameFormat format) {
        StorageImmediatelySerialized<Deck> decks = new StorageImmediatelySerialized<Deck>("Generator", new DeckStorage(new File(ForgeConstants.DECK_GEN_DIR + ForgeConstants.PATH_SEPARATOR + format.getName()), ForgeConstants.DECK_GEN_DIR, false), true);
        Iterable<PaperCard> cards = Iterables.filter(format.getAllCards(), Predicates.compose(Predicates.not(CardRulesPredicates.Presets.IS_BASIC_LAND_NOT_WASTES), PaperCard::getRules));
        ArrayList<PaperCard> cardList = Lists.newArrayList(cards);
        cardList.add(FModel.getMagicDb().getCommonCards().getCard("Wastes"));
        HashMap<String, Integer> cardIntegerMap = new HashMap<String, Integer>();
        HashMap<Integer, PaperCard> integerCardMap = new HashMap<Integer, PaperCard>();
        for (int i = 0; i < cardList.size(); ++i) {
            cardIntegerMap.put(((PaperCard)cardList.get(i)).getName(), i);
            integerCardMap.put(i, (PaperCard)cardList.get(i));
        }
        int[][] matrix = new int[cardList.size()][cardList.size()];
        for (PaperCard card : cardList) {
            for (Deck deck : decks) {
                if (!deck.getMain().contains(card)) continue;
                for (PaperCard pairCard : Iterables.filter(deck.getMain().toFlatList(), Predicates.compose(Predicates.not(CardRulesPredicates.Presets.IS_BASIC_LAND_NOT_WASTES), PaperCard::getRules))) {
                    if (pairCard.getName().equals(card.getName())) continue;
                    try {
                        int old = matrix[(Integer)cardIntegerMap.get(card.getName())][(Integer)cardIntegerMap.get(pairCard.getName())];
                        matrix[((Integer)cardIntegerMap.get((Object)card.getName())).intValue()][((Integer)cardIntegerMap.get((Object)pairCard.getName())).intValue()] = old + 1;
                    }
                    catch (NullPointerException old) {}
                }
            }
        }
        HashMap<String, List<Map.Entry<PaperCard, Integer>>> cardPools = new HashMap<String, List<Map.Entry<PaperCard, Integer>>>();
        for (PaperCard card : cardList) {
            int col = (Integer)cardIntegerMap.get(card.getName());
            int[] distances = matrix[col];
            int max = Collections.max(Arrays.asList(ArrayUtils.toObject(distances)));
            if (max <= 0) continue;
            ArrayIndexComparator comparator = new ArrayIndexComparator(ArrayUtils.toObject(distances));
            Integer[] indices = comparator.createIndexArray();
            Arrays.sort(indices, comparator);
            ArrayList<AbstractMap.SimpleEntry<PaperCard, Integer>> deckPool = new ArrayList<AbstractMap.SimpleEntry<PaperCard, Integer>>();
            int k = 0;
            boolean excludeThisCard = false;
            int j = 0;
            while (j < 14) {
                if (distances[indices[cardList.size() - 1 - k]] == 0) {
                    excludeThisCard = true;
                    break;
                }
                PaperCard cardToAdd = (PaperCard)integerCardMap.get(indices[cardList.size() - 1 - k]);
                if (!cardToAdd.getRules().getMainPart().getType().isLand()) {
                    ++j;
                }
                deckPool.add(new AbstractMap.SimpleEntry<PaperCard, Integer>(cardToAdd, distances[indices[cardList.size() - 1 - k]]));
                ++k;
            }
            if (excludeThisCard) continue;
            cardPools.put(card.getName(), deckPool);
        }
        return cardPools;
    }

    public static HashMap<String, List<Map.Entry<PaperCard, Integer>>> initializeCommanderFormat(DeckFormat format) {
        StorageImmediatelySerialized<Deck> decks = new StorageImmediatelySerialized<Deck>("Generator", new DeckStorage(new File(ForgeConstants.DECK_GEN_DIR, format.toString()), ForgeConstants.DECK_GEN_DIR, false), true);
        Iterable<PaperCard> cards = Iterables.filter(FModel.getMagicDb().getCommonCards().getUniqueCards(), Predicates.compose(Predicates.not(CardRulesPredicates.Presets.IS_BASIC_LAND_NOT_WASTES), PaperCard::getRules));
        ArrayList<PaperCard> cardList = Lists.newArrayList(cards);
        cardList.add(FModel.getMagicDb().getCommonCards().getCard("Wastes"));
        HashMap<String, Integer> cardIntegerMap = new HashMap<String, Integer>();
        HashMap<Integer, PaperCard> integerCardMap = new HashMap<Integer, PaperCard>();
        HashMap<String, Integer> legendIntegerMap = new HashMap<String, Integer>();
        HashMap<Integer, PaperCard> integerLegendMap = new HashMap<Integer, PaperCard>();
        for (int i = 0; i < cardList.size(); ++i) {
            cardIntegerMap.put(((PaperCard)cardList.get(i)).getName(), i);
            integerCardMap.put(i, (PaperCard)cardList.get(i));
        }
        ArrayList<PaperCard> legends = Lists.newArrayList(Iterables.filter(cardList, format.isLegalCommanderPredicate()));
        for (int i = 0; i < legends.size(); ++i) {
            legendIntegerMap.put(((PaperCard)legends.get(i)).getName(), i);
            integerLegendMap.put(i, (PaperCard)legends.get(i));
        }
        int[][] matrix = new int[legends.size()][cardList.size()];
        for (PaperCard legend : legends) {
            for (Deck deck : decks) {
                if (!deck.getCommanders().contains(legend)) continue;
                CardRelationMatrixGenerator.updateLegendMatrix(deck, legend, cardIntegerMap, legendIntegerMap, matrix);
            }
        }
        HashMap<String, List<Map.Entry<PaperCard, Integer>>> cardPools = new HashMap<String, List<Map.Entry<PaperCard, Integer>>>();
        for (PaperCard card : legends) {
            int col = (Integer)legendIntegerMap.get(card.getName());
            int[] distances = matrix[col];
            int max = Collections.max(Arrays.asList(ArrayUtils.toObject(distances)));
            if (max <= 0) continue;
            ArrayList<AbstractMap.SimpleEntry<PaperCard, Integer>> deckPool = new ArrayList<AbstractMap.SimpleEntry<PaperCard, Integer>>();
            for (int k = 0; k < cardList.size(); ++k) {
                if (matrix[col][k] <= 0) continue;
                deckPool.add(new AbstractMap.SimpleEntry<PaperCard, Integer>((PaperCard)integerCardMap.get(k), matrix[col][k]));
            }
            cardPools.put(card.getName(), deckPool);
        }
        return cardPools;
    }

    public static void updateLegendMatrix(Deck deck, PaperCard legend, Map<String, Integer> cardIntegerMap, Map<String, Integer> legendIntegerMap, int[][] matrix) {
        int old;
        for (PaperCard pairCard : Iterables.filter(deck.getMain().toFlatList(), Predicates.compose(Predicates.not(CardRulesPredicates.Presets.IS_BASIC_LAND_NOT_WASTES), PaperCard::getRules))) {
            if (pairCard.getName().equals(legend.getName())) continue;
            try {
                old = matrix[legendIntegerMap.get(legend.getName())][cardIntegerMap.get(pairCard.getName())];
                matrix[legendIntegerMap.get((Object)legend.getName()).intValue()][cardIntegerMap.get((Object)pairCard.getName()).intValue()] = old + 1;
            }
            catch (NullPointerException ne) {
                ne.printStackTrace();
            }
        }
        if (deck.getCommanders().size() > 1) {
            for (PaperCard partner : deck.getCommanders()) {
                if (partner.equals(legend)) continue;
                old = matrix[legendIntegerMap.get(legend.getName())][cardIntegerMap.get(partner.getName())];
                matrix[legendIntegerMap.get((Object)legend.getName()).intValue()][cardIntegerMap.get((Object)partner.getName()).intValue()] = old + 1;
            }
        }
    }

    public static class ArrayIndexComparator
    implements Comparator<Integer> {
        private final Integer[] array;

        public ArrayIndexComparator(Integer[] array) {
            this.array = array;
        }

        public Integer[] createIndexArray() {
            Integer[] indexes = new Integer[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                indexes[i] = i;
            }
            return indexes;
        }

        @Override
        public int compare(Integer index1, Integer index2) {
            return this.array[index1].compareTo(this.array[index2]);
        }
    }
}

