/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicate;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.item.PaperCard;
import forge.util.CollectionSuppliers;
import forge.util.ItemPool;
import forge.util.ItemPoolSorter;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CardPool
extends ItemPool<PaperCard> {
    private static final long serialVersionUID = -5379091255613968393L;
    private static final Pattern p = Pattern.compile("((\\d+)\\s+)?(.*?)");

    public CardPool() {
        super(PaperCard.class);
    }

    public CardPool(Iterable<Map.Entry<PaperCard, Integer>> cards) {
        this();
        this.addAll(cards);
    }

    @Override
    public void add(String cardRequest, int amount) {
        CardDb.CardRequest request = CardDb.CardRequest.fromString(cardRequest);
        this.add(CardDb.CardRequest.compose(request.cardName, request.isFoil), request.edition, request.artIndex, amount);
    }

    public void add(String cardName, String setCode) {
        this.add(cardName, setCode, 1, 1);
    }

    public void add(String cardName, String setCode, int amount) {
        this.add(cardName, setCode, 1, amount);
    }

    public void add(String cardName, String setCode, int amount, boolean addAny) {
        this.add(cardName, setCode, -1, amount, addAny);
    }

    public void add(String cardName, String setCode, int artIndex, int amount) {
        this.add(cardName, setCode, artIndex, amount, false);
    }

    public void add(String cardName, String setCode, int artIndex, int amount, boolean addAny) {
        boolean artIndexExplicitlySet;
        Map<String, CardDb> dbs = StaticData.instance().getAvailableDatabases();
        PaperCard paperCard = null;
        String selectedDbName = "";
        artIndex = Math.max(artIndex, 1);
        int loadAttempt = 0;
        while (paperCard == null && loadAttempt < 2) {
            for (Map.Entry<String, CardDb> entry : dbs.entrySet()) {
                String dbName = entry.getKey();
                CardDb db = entry.getValue();
                paperCard = db.getCard(cardName, setCode, artIndex);
                if (paperCard == null) continue;
                selectedDbName = dbName;
                break;
            }
            if (paperCard != null || ++loadAttempt >= 2) continue;
            StaticData.instance().attemptToLoadCard(cardName, setCode);
            artIndex = 1;
        }
        if (addAny && paperCard == null) {
            paperCard = StaticData.instance().getCommonCards().getCard(cardName);
            selectedDbName = "Common";
        }
        if (paperCard == null) {
            System.err.println("An unsupported card was requested: \"" + cardName + "\" from \"" + setCode + "\". \n");
            paperCard = StaticData.instance().getCommonCards().createUnsupportedCard(cardName);
            selectedDbName = "Common";
        }
        CardDb cardDb = dbs.getOrDefault(selectedDbName, StaticData.instance().getCommonCards());
        setCode = paperCard.getEdition();
        cardName = paperCard.getName();
        int artCount = cardDb.getArtCount(cardName, setCode);
        boolean bl = artIndexExplicitlySet = artIndex > 1 || CardDb.CardRequest.fromString((String)cardName).artIndex > -1;
        if ((artIndexExplicitlySet || artCount == 1) && !addAny) {
            this.add(paperCard, amount);
        } else {
            int[] artGroups = MyRandom.splitIntoRandomGroups(amount, artCount);
            for (int i = 1; i <= artGroups.length; ++i) {
                int cnt = artGroups[i - 1];
                if (cnt <= 0) continue;
                PaperCard randomCard = cardDb.getCard(cardName, setCode, i);
                this.add(randomCard, cnt);
            }
        }
    }

    @Override
    public void add(Iterable<PaperCard> list) {
        for (PaperCard cp : list) {
            this.add(cp);
        }
    }

    public PaperCard get(int n) {
        for (Map.Entry e : this) {
            if ((n -= e.getValue().intValue()) > 0) continue;
            return (PaperCard)e.getKey();
        }
        return null;
    }

    public int countByName(String cardName) {
        return this.countAll(c -> c.getName().equals(cardName));
    }

    public int countByName(PaperCard card) {
        return this.countAll(c -> c.getName().equals(card.getName()));
    }

    public Map<CardEdition, Integer> getCardEditionStatistics(boolean includeBasicLands) {
        HashMap<CardEdition, Integer> editionStatistics = new HashMap<CardEdition, Integer>();
        for (Map.Entry cp : this.items.entrySet()) {
            PaperCard card = (PaperCard)cp.getKey();
            if (card.getRules().getType().isBasicLand() && !includeBasicLands) continue;
            int count = (Integer)cp.getValue();
            CardEdition edition = StaticData.instance().getCardEdition(card.getEdition());
            if (edition == null) continue;
            int currentCount = editionStatistics.getOrDefault(edition, 0);
            editionStatistics.put(edition, currentCount += count);
        }
        return editionStatistics;
    }

    public ListMultimap<Integer, CardEdition> getCardEditionsGroupedByNumberOfCards(boolean includeBasicLands) {
        Map<CardEdition, Integer> editionsFrequencyMap = this.getCardEditionStatistics(includeBasicLands);
        ListMultimap<Integer, CardEdition> reverseMap = Multimaps.newListMultimap(new HashMap(), CollectionSuppliers.arrayLists());
        for (Map.Entry<CardEdition, Integer> entry : editionsFrequencyMap.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        return reverseMap;
    }

    public Map<CardEdition.Type, Integer> getCardEditionTypeStatistics(boolean includeBasicLands) {
        HashMap<CardEdition.Type, Integer> editionTypeStats = new HashMap<CardEdition.Type, Integer>();
        Map<CardEdition, Integer> editionStatistics = this.getCardEditionStatistics(includeBasicLands);
        for (Map.Entry<CardEdition, Integer> entry : editionStatistics.entrySet()) {
            CardEdition edition = entry.getKey();
            int count = entry.getValue();
            CardEdition.Type key = edition.getType();
            int currentCount = editionTypeStats.getOrDefault((Object)key, 0);
            editionTypeStats.put(key, currentCount += count);
        }
        return editionTypeStats;
    }

    public CardEdition.Type getTheMostFrequentEditionType() {
        Map<CardEdition.Type, Integer> editionTypeStats = this.getCardEditionTypeStatistics(false);
        Integer mostFrequentType = 0;
        ArrayList<CardEdition.Type> mostFrequentEditionTypes = new ArrayList<CardEdition.Type>();
        for (Map.Entry<CardEdition.Type, Integer> entry : editionTypeStats.entrySet()) {
            if (entry.getValue() <= mostFrequentType) continue;
            mostFrequentType = entry.getValue();
            mostFrequentEditionTypes.add(entry.getKey());
        }
        if (mostFrequentEditionTypes.isEmpty()) {
            return null;
        }
        CardEdition.Type mostFrequentEditionType = (CardEdition.Type)((Object)mostFrequentEditionTypes.get(0));
        for (int i = 1; i < mostFrequentEditionTypes.size(); ++i) {
            CardEdition.Type frequentType = (CardEdition.Type)((Object)mostFrequentEditionTypes.get(i));
            if (frequentType != CardEdition.Type.EXPANSION) continue;
            return frequentType;
        }
        return mostFrequentEditionType;
    }

    public boolean isModern() {
        int modernEditionsCount = 0;
        int preModernEditionsCount = 0;
        Map<CardEdition, Integer> editionStats = this.getCardEditionStatistics(false);
        for (Map.Entry<CardEdition, Integer> entry : editionStats.entrySet()) {
            CardEdition edition = entry.getKey();
            if (edition.isModern()) {
                modernEditionsCount += entry.getValue().intValue();
                continue;
            }
            preModernEditionsCount += entry.getValue().intValue();
        }
        if (modernEditionsCount == preModernEditionsCount) {
            return StaticData.instance().cardArtPreferenceIsLatest();
        }
        return modernEditionsCount > preModernEditionsCount;
    }

    public CardEdition getPivotCardEdition(boolean isLatestCardArtPreference) {
        boolean searchPolicyAndPoolAreCompliant;
        ListMultimap<Integer, CardEdition> editionsStatistics = this.getCardEditionsGroupedByNumberOfCards(false);
        ArrayList<Integer> frequencyValues = new ArrayList<Integer>(editionsStatistics.keySet());
        frequencyValues.sort(Comparator.reverseOrder());
        float weightedMean = 0.0f;
        int sumWeights = 0;
        for (Integer freq : frequencyValues) {
            int editionsCount = editionsStatistics.get((Object)freq).size();
            int weightedFrequency = freq * editionsCount;
            sumWeights += editionsCount;
            weightedMean += (float)weightedFrequency;
        }
        if (frequencyValues.isEmpty()) {
            return null;
        }
        int totalNoCards = (int)weightedMean;
        int topFrequency = (Integer)frequencyValues.get(0);
        float ratio = (float)topFrequency / (float)totalNoCards;
        int pivotFrequency = (double)ratio >= 0.33 ? topFrequency : CardPool.getMedianFrequency(frequencyValues, weightedMean /= (float)sumWeights);
        ArrayList pivotCandidates = new ArrayList(editionsStatistics.get((Object)pivotFrequency));
        pivotCandidates.sort(CardEdition::compareTo);
        boolean bl = searchPolicyAndPoolAreCompliant = isLatestCardArtPreference == this.isModern();
        if (!searchPolicyAndPoolAreCompliant) {
            Collections.reverse(pivotCandidates);
        }
        return (CardEdition)pivotCandidates.get(0);
    }

    private static int getMedianFrequency(List<Integer> frequencyValues, float meanFrequency) {
        int medianFrequency = frequencyValues.get(0);
        float refDelta = Math.abs(meanFrequency - (float)medianFrequency);
        for (int i = 1; i < frequencyValues.size(); ++i) {
            int currentFrequency = frequencyValues.get(i);
            float delta = Math.abs(meanFrequency - (float)currentFrequency);
            if (!(delta < refDelta)) continue;
            medianFrequency = currentFrequency;
            refDelta = delta;
        }
        return medianFrequency;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Map.Entry e : this) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(e.getValue()).append(" x ").append(((PaperCard)e.getKey()).getName());
        }
        return sb.append(']').toString();
    }

    public static CardPool fromCardList(Iterable<String> lines) {
        CardPool pool = new CardPool();
        if (lines == null) {
            return pool;
        }
        List<Pair<String, Integer>> cardRequests = CardPool.processCardList(lines);
        for (Pair<String, Integer> pair : cardRequests) {
            String cardRequest = pair.getLeft();
            int count = pair.getRight();
            pool.add(cardRequest, count);
        }
        return pool;
    }

    public static List<Pair<String, Integer>> processCardList(Iterable<String> lines) {
        ArrayList<Pair<String, Integer>> cardRequests = new ArrayList<Pair<String, Integer>>();
        if (lines == null) {
            return cardRequests;
        }
        for (String line : lines) {
            Matcher m4;
            boolean matches;
            if (line.startsWith(";") || line.startsWith("#") || !(matches = (m4 = p.matcher(line.trim())).matches())) continue;
            String sCnt = m4.group(2);
            String cardRequest = m4.group(3);
            if (StringUtils.isBlank(cardRequest)) continue;
            int count = sCnt == null ? 1 : Integer.parseInt(sCnt);
            cardRequests.add(Pair.of(cardRequest, count));
        }
        return cardRequests;
    }

    public String toCardList(String separator) {
        ArrayList<Map.Entry<PaperCard, Integer>> main2sort = Lists.newArrayList(this);
        main2sort.sort(ItemPoolSorter.BY_NAME_THEN_SET);
        CardDb commonDb = StaticData.instance().getCommonCards();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : main2sort) {
            if (!isFirst) {
                sb.append(separator);
            } else {
                isFirst = false;
            }
            CardDb db = !((PaperCard)entry.getKey()).getRules().isVariant() ? commonDb : StaticData.instance().getVariantCards();
            sb.append(entry.getValue()).append(" ");
            db.appendCardToStringBuilder((PaperCard)entry.getKey(), sb);
        }
        return sb.toString();
    }

    public CardPool getFilteredPool(Predicate<PaperCard> predicate) {
        CardPool filteredPool = new CardPool();
        for (PaperCard c : this.items.keySet()) {
            if (!predicate.apply(c)) continue;
            filteredPool.add(c, (int)((Integer)this.items.get(c)));
        }
        return filteredPool;
    }

    public CardPool getFilteredPoolWithCardsCount(Predicate<PaperCard> predicate) {
        CardPool filteredPool = new CardPool();
        for (Map.Entry entry : this.items.entrySet()) {
            PaperCard pc = (PaperCard)entry.getKey();
            int count = (Integer)entry.getValue();
            if (!predicate.apply(pc)) continue;
            filteredPool.add(pc, count);
        }
        return filteredPool;
    }
}

