/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.StaticData;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardEdition;
import forge.card.CardRenderer;
import forge.card.CardRules;
import forge.card.CardZoom;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckgenUtil;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.toolbox.FComboBox;
import forge.toolbox.FContainer;
import forge.toolbox.FDialog;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextArea;
import forge.util.Callback;
import forge.util.MyRandom;
import forge.util.Utils;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;

public class AddBasicLandsDialog
extends FDialog {
    private static final float ADD_BTN_SIZE = Utils.AVG_FINGER_HEIGHT * 0.75f;
    private static final float LAND_PANEL_PADDING = Utils.scale(3.0f);
    private final Deck currentDeck;
    private final Callback<CardPool> callback;
    private final FLabel lblLandSet = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblLandSet", new Object[0]) + ":").font(FSkinFont.get(12)).textColor(FLabel.getInlineLabelColor()).build());
    private final FComboBox<CardEdition> cbLandSet = this.add(new FComboBox<CardEdition>(Iterables.filter(StaticData.instance().getEditions(), CardEdition.Predicates.hasBasicLands)));
    private final FScrollPane scroller = this.add(new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float padding;
            float x = padding = FOptionPane.PADDING;
            float totalWidth = Forge.isLandscapeMode() ? visibleWidth : 2.0f * visibleWidth - ADD_BTN_SIZE;
            float panelWidth = (totalWidth - 6.0f * padding) / 5.0f;
            AddBasicLandsDialog.this.pnlPlains.setBounds(x, 0.0f, panelWidth, visibleHeight);
            AddBasicLandsDialog.this.pnlIsland.setBounds(x += panelWidth + padding, 0.0f, panelWidth, visibleHeight);
            AddBasicLandsDialog.this.pnlSwamp.setBounds(x += panelWidth + padding, 0.0f, panelWidth, visibleHeight);
            AddBasicLandsDialog.this.pnlMountain.setBounds(x += panelWidth + padding, 0.0f, panelWidth, visibleHeight);
            AddBasicLandsDialog.this.pnlForest.setBounds(x += panelWidth + padding, 0.0f, panelWidth, visibleHeight);
            return new FScrollPane.ScrollBounds(totalWidth, visibleHeight);
        }
    });
    private final LandPanel pnlPlains = this.scroller.add(new LandPanel("Plains"));
    private final LandPanel pnlIsland = this.scroller.add(new LandPanel("Island"));
    private final LandPanel pnlSwamp = this.scroller.add(new LandPanel("Swamp"));
    private final LandPanel pnlMountain = this.scroller.add(new LandPanel("Mountain"));
    private final LandPanel pnlForest = this.scroller.add(new LandPanel("Forest"));
    private final FTextArea lblDeckInfo = this.add(new FTextArea(true){

        @Override
        public boolean tap(float x, float y, int count) {
            if (count == 2) {
                Map<ManaCostShard, Integer> suggestionMap = DeckgenUtil.suggestBasicLandCount(AddBasicLandsDialog.this.currentDeck);
                AddBasicLandsDialog.this.pnlPlains.count = suggestionMap.get((Object)ManaCostShard.WHITE);
                AddBasicLandsDialog.this.pnlIsland.count = suggestionMap.get((Object)ManaCostShard.BLUE);
                AddBasicLandsDialog.this.pnlSwamp.count = suggestionMap.get((Object)ManaCostShard.BLACK);
                AddBasicLandsDialog.this.pnlMountain.count = suggestionMap.get((Object)ManaCostShard.RED);
                AddBasicLandsDialog.this.pnlForest.count = suggestionMap.get((Object)ManaCostShard.GREEN);
                AddBasicLandsDialog.this.pnlPlains.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlPlains.count));
                AddBasicLandsDialog.this.pnlIsland.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlIsland.count));
                AddBasicLandsDialog.this.pnlSwamp.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlSwamp.count));
                AddBasicLandsDialog.this.pnlMountain.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlMountain.count));
                AddBasicLandsDialog.this.pnlForest.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlForest.count));
                AddBasicLandsDialog.this.updateDeckInfoLabel();
            }
            return true;
        }
    });
    private int nonLandCount;
    private int oldLandCount;
    private CardEdition landSet;

    public AddBasicLandsDialog(Deck deck, CardEdition defaultLandSet, Callback<CardPool> callback0, List<CardEdition> editionOptions) {
        super(Forge.getLocalizer().getMessage("lblAddBasicLandsAutoSuggest", new Object[0]).replace("%s", deck.getName()), 2);
        this.callback = callback0;
        this.currentDeck = deck;
        this.lblDeckInfo.setAlignment(1);
        this.lblDeckInfo.setFont(FSkinFont.get(12));
        this.cbLandSet.setFont(this.lblLandSet.getFont());
        this.cbLandSet.setAutoClose(false);
        this.cbLandSet.setChangedHandler(e -> {
            this.landSet = this.cbLandSet.getSelectedItem();
            this.pnlPlains.refreshArtChoices();
            this.pnlIsland.refreshArtChoices();
            this.pnlSwamp.refreshArtChoices();
            this.pnlMountain.refreshArtChoices();
            this.pnlForest.refreshArtChoices();
        });
        if (editionOptions != null && !editionOptions.isEmpty()) {
            this.cbLandSet.setItems(editionOptions, editionOptions.get(0));
        }
        this.cbLandSet.setSelectedItem(defaultLandSet);
        this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> {
            CardPool landsToAdd = new CardPool();
            this.pnlPlains.addToCardPool(landsToAdd);
            this.pnlIsland.addToCardPool(landsToAdd);
            this.pnlSwamp.addToCardPool(landsToAdd);
            this.pnlMountain.addToCardPool(landsToAdd);
            this.pnlForest.addToCardPool(landsToAdd);
            this.hide();
            if (landsToAdd.countAll() > 0) {
                this.callback.run(landsToAdd);
            }
        });
        this.initButton(1, Forge.getLocalizer().getMessage("lblCancel", new Object[0]), e -> this.hide());
        int halfCountW = 0;
        int halfCountU = 0;
        int halfCountB = 0;
        int halfCountR = 0;
        int halfCountG = 0;
        for (Map.Entry entry : deck.getMain()) {
            CardRules cardRules = ((PaperCard)entry.getKey()).getRules();
            int count = entry.getValue();
            if (cardRules.getType().isLand()) {
                this.oldLandCount += count;
            } else {
                this.nonLandCount += count;
                for (ManaCostShard shard : cardRules.getManaCost()) {
                    boolean isMonoColor = shard.isMonoColor();
                    if (shard.isWhite()) {
                        if (isMonoColor) {
                            this.pnlPlains.symbolCount += count;
                            continue;
                        }
                        halfCountW += count;
                    }
                    if (shard.isBlue()) {
                        if (isMonoColor) {
                            this.pnlIsland.symbolCount += count;
                            continue;
                        }
                        halfCountU += count;
                    }
                    if (shard.isBlack()) {
                        if (isMonoColor) {
                            this.pnlSwamp.symbolCount += count;
                            continue;
                        }
                        halfCountB += count;
                    }
                    if (shard.isRed()) {
                        if (isMonoColor) {
                            this.pnlMountain.symbolCount += count;
                            continue;
                        }
                        halfCountR += count;
                    }
                    if (!shard.isGreen()) continue;
                    if (isMonoColor) {
                        this.pnlForest.symbolCount += count;
                        continue;
                    }
                    halfCountG += count;
                }
            }
            if (this.pnlPlains.symbolCount > 0.0 && halfCountW > 0) {
                this.pnlPlains.symbolCount += (double)halfCountW * 0.5;
            }
            if (this.pnlIsland.symbolCount > 0.0 && halfCountU > 0) {
                this.pnlIsland.symbolCount += (double)halfCountU * 0.5;
            }
            if (this.pnlSwamp.symbolCount > 0.0 && halfCountB > 0) {
                this.pnlSwamp.symbolCount += (double)halfCountB * 0.5;
            }
            if (this.pnlMountain.symbolCount > 0.0 && halfCountR > 0) {
                this.pnlMountain.symbolCount += (double)halfCountR * 0.5;
            }
            if (!(this.pnlForest.symbolCount > 0.0) || halfCountG <= 0) continue;
            this.pnlForest.symbolCount += (double)halfCountG * 0.5;
        }
        this.updateDeckInfoLabel();
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float padding;
        float x = padding = FOptionPane.PADDING;
        float y = padding;
        float w = width - 2.0f * padding;
        float comboBoxHeight = this.cbLandSet.getHeight();
        this.lblLandSet.setBounds(x, y, this.lblLandSet.getAutoSizeBounds().width, comboBoxHeight);
        this.cbLandSet.setBounds(x, y += comboBoxHeight, w, comboBoxHeight);
        float panelExtraHeight = this.pnlPlains.cbLandArt.getHeight() + ADD_BTN_SIZE + 2.0f * LAND_PANEL_PADDING;
        float panelWidth = Forge.isLandscapeMode() ? (width - 6.0f * padding) / 5.0f : (2.0f * width - ADD_BTN_SIZE - 6.0f * padding) / 5.0f;
        float panelHeight = panelWidth * 1.4f + panelExtraHeight;
        this.scroller.setBounds(0.0f, y += comboBoxHeight + padding, width, panelHeight);
        if (this.pnlMountain.symbolCount + this.pnlForest.symbolCount > this.pnlPlains.symbolCount + this.pnlIsland.symbolCount) {
            this.scroller.scrollToRight();
        } else {
            this.scroller.scrollToLeft();
        }
        this.lblDeckInfo.setBounds(x, y += panelHeight + padding, w, this.lblDeckInfo.getPreferredHeight(w));
        return y + this.lblDeckInfo.getHeight() + padding;
    }

    private void updateDeckInfoLabel() {
        NumberFormat integer = NumberFormat.getIntegerInstance();
        NumberFormat percent = NumberFormat.getPercentInstance();
        int newLandCount = this.pnlPlains.count + this.pnlIsland.count + this.pnlSwamp.count + this.pnlMountain.count + this.pnlForest.count;
        double totalSymbolCount = this.pnlPlains.symbolCount + this.pnlIsland.symbolCount + this.pnlSwamp.symbolCount + this.pnlMountain.symbolCount + this.pnlForest.symbolCount;
        if (totalSymbolCount == 0.0) {
            totalSymbolCount = 1.0;
        }
        int newTotalCount = this.nonLandCount + this.oldLandCount + newLandCount;
        this.lblDeckInfo.setText(String.format(Forge.getLocalizer().getMessage("lblNonLandCount", new Object[0]), this.nonLandCount) + " + " + String.format(Forge.getLocalizer().getMessage("lblOldLandCount", new Object[0]), this.oldLandCount) + " + " + String.format(Forge.getLocalizer().getMessage("lblNewLandCount", new Object[0]), newLandCount) + " = " + String.format(Forge.getLocalizer().getMessage("lblNewTotalCount", new Object[0]), newTotalCount) + "\n{W} " + integer.format(this.pnlPlains.symbolCount) + " (" + percent.format(this.pnlPlains.symbolCount / totalSymbolCount) + ") | {U} " + integer.format(this.pnlIsland.symbolCount) + " (" + percent.format(this.pnlIsland.symbolCount / totalSymbolCount) + ") | {B} " + integer.format(this.pnlSwamp.symbolCount) + " (" + percent.format(this.pnlSwamp.symbolCount / totalSymbolCount) + ") | {R} " + integer.format(this.pnlMountain.symbolCount) + " (" + percent.format(this.pnlMountain.symbolCount / totalSymbolCount) + ") | {G} " + integer.format(this.pnlForest.symbolCount) + " (" + percent.format(this.pnlForest.symbolCount / totalSymbolCount) + ")");
    }

    private class LandPanel
    extends FContainer {
        private final LandCardPanel cardPanel;
        private final FLabel lblCount;
        private final FLabel btnSubtract;
        private final FLabel btnAdd;
        private final FComboBox<String> cbLandArt;
        private final String cardName;
        private PaperCard card;
        private int count;
        private int maxCount;
        private double symbolCount;

        private LandPanel(String cardName0) {
            this.cardName = cardName0;
            this.cardPanel = this.add(new LandCardPanel());
            this.cbLandArt = this.add(new FComboBox());
            this.cbLandArt.setFont(AddBasicLandsDialog.this.cbLandSet.getFont());
            this.cbLandArt.setChangedHandler(e -> {
                int artIndex = this.cbLandArt.getSelectedIndex();
                if (artIndex < 0) {
                    return;
                }
                this.card = this.generateCard(artIndex);
            });
            this.lblCount = this.add(new FLabel.Builder().text("0").font(FSkinFont.get(18)).align(1).build());
            this.btnSubtract = this.add(new FLabel.ButtonBuilder().icon(Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS).command(e -> {
                if (this.count > 0) {
                    --this.count;
                    this.lblCount.setText(String.valueOf(this.count));
                    AddBasicLandsDialog.this.updateDeckInfoLabel();
                }
            }).build());
            this.btnAdd = this.add(new FLabel.ButtonBuilder().icon(Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS).command(e -> {
                if (this.maxCount == 0 || this.count < this.maxCount) {
                    ++this.count;
                    this.lblCount.setText(String.valueOf(this.count));
                    AddBasicLandsDialog.this.updateDeckInfoLabel();
                }
            }).build());
        }

        private void addToCardPool(CardPool pool) {
            if (this.count == 0) {
                return;
            }
            int artIndex = this.cbLandArt.getSelectedIndex();
            if (artIndex < 0) {
                return;
            }
            if (artIndex > 0 && this.card != null) {
                pool.add(this.card, this.count);
            } else {
                for (int i = 0; i < this.count; ++i) {
                    pool.add(this.generateCard(MyRandom.getRandom().nextInt(this.cbLandArt.getItemCount())));
                }
            }
        }

        private PaperCard generateCard(int artIndex) {
            PaperCard c = FModel.getMagicDb().getCommonCards().getCard(this.cardName, AddBasicLandsDialog.this.landSet.getCode(), artIndex);
            if (c == null) {
                c = FModel.getMagicDb().getCommonCards().getCard(this.cardName, "ZEN");
            }
            return c;
        }

        private void refreshArtChoices() {
            this.cbLandArt.removeAllItems();
            if (AddBasicLandsDialog.this.landSet == null) {
                return;
            }
            int artChoiceCount = FModel.getMagicDb().getCommonCards().getArtCount(this.cardName, AddBasicLandsDialog.this.landSet.getCode());
            this.cbLandArt.addItem(Forge.getLocalizer().getMessage("lblAssortedArt", new Object[0]));
            for (int i = 1; i <= artChoiceCount; ++i) {
                this.cbLandArt.addItem(Forge.getLocalizer().getMessage("lblCardArtN", String.valueOf(i)));
            }
        }

        @Override
        protected void doLayout(float width, float height) {
            float minLabelWidth;
            float y = height - ADD_BTN_SIZE;
            float buttonWidth = ADD_BTN_SIZE;
            float labelWidth = width - 2.0f * ADD_BTN_SIZE;
            if (labelWidth < (minLabelWidth = this.lblCount.getFont().getBounds((CharSequence)"0").width + 2.0f * this.lblCount.getInsets().x)) {
                labelWidth = minLabelWidth;
                buttonWidth = (width - labelWidth) / 2.0f;
            }
            this.btnSubtract.setBounds(0.0f, y, buttonWidth, ADD_BTN_SIZE);
            this.lblCount.setBounds(buttonWidth, y, labelWidth, ADD_BTN_SIZE);
            this.btnAdd.setBounds(width - buttonWidth, y, buttonWidth, ADD_BTN_SIZE);
            this.cbLandArt.setBounds(0.0f, y -= this.cbLandArt.getHeight() + LAND_PANEL_PADDING, width, this.cbLandArt.getHeight());
            float cardPanelHeight = y - LAND_PANEL_PADDING;
            float cardPanelWidth = cardPanelHeight / 1.4f;
            this.cardPanel.setBounds((width - cardPanelWidth) / 2.0f, 0.0f, cardPanelWidth, cardPanelHeight);
        }

        private class LandCardPanel
        extends FDisplayObject {
            private LandCardPanel() {
            }

            @Override
            public boolean tap(float x, float y, int count) {
                if (LandPanel.this.card == null) {
                    return false;
                }
                CardZoom.show(LandPanel.this.card);
                return true;
            }

            @Override
            public boolean longPress(float x, float y) {
                if (LandPanel.this.card == null) {
                    return false;
                }
                CardZoom.show(LandPanel.this.card);
                return true;
            }

            @Override
            public void draw(Graphics g2) {
                if (LandPanel.this.card == null) {
                    return;
                }
                CardRenderer.drawCard(g2, LandPanel.this.card, 0.0f, 0.0f, this.getWidth(), this.getHeight(), CardRenderer.CardStackPosition.Top);
            }
        }
    }
}

