/*
 * Decompiled with CFR 0.152.
 */
package forge.card.mana;

import forge.util.BinaryUtil;

public enum ManaCostShard {
    WHITE(1, "W"),
    BLUE(2, "U"),
    BLACK(4, "B"),
    RED(8, "R"),
    GREEN(16, "G"),
    COLORLESS(32, "C"),
    WU(3, "W/U", "WU"),
    WB(5, "W/B", "WB"),
    UB(6, "U/B", "UB"),
    UR(10, "U/R", "UR"),
    BR(12, "B/R", "BR"),
    BG(20, "B/G", "BG"),
    RW(9, "R/W", "RW"),
    RG(24, "R/G", "RG"),
    GW(17, "G/W", "GW"),
    GU(18, "G/U", "GU"),
    W2(513, "2/W", "2W"),
    U2(514, "2/U", "2U"),
    B2(516, "2/B", "2B"),
    R2(520, "2/R", "2R"),
    G2(528, "2/G", "2G"),
    CW(33, "C/W", "CW"),
    CU(34, "C/U", "CU"),
    CB(36, "C/B", "CB"),
    CR(40, "C/R", "CR"),
    CG(48, "C/G", "CG"),
    S(2048, "S"),
    GENERIC(64, "1"),
    WP(1025, "W/P", "WP"),
    UP(1026, "U/P", "UP"),
    BP(1028, "B/P", "BP"),
    RP(1032, "R/P", "RP"),
    GP(1040, "G/P", "GP"),
    BGP(1044, "B/G/P", "BGP"),
    BRP(1036, "B/R/P", "BRP"),
    GUP(1042, "G/U/P", "GUP"),
    GWP(1041, "G/W/P", "GWP"),
    RGP(1048, "R/G/P", "RGP"),
    RWP(1033, "R/W/P", "RWP"),
    UBP(1030, "U/B/P", "UBP"),
    URP(1034, "U/R/P", "URP"),
    WBP(1029, "W/B/P", "WBP"),
    WUP(1027, "W/U/P", "WUP"),
    X(256, "X"),
    COLORED_X(287, "1");

    private final int shard;
    private final int cmc;
    private final float cmpc;
    private final String stringValue;
    private final String imageKey;
    public static final int COLORS_SUPERPOSITION = 31;

    private ManaCostShard(int value, String sValue) {
        this(value, sValue, sValue);
    }

    private ManaCostShard(int value, String sValue, String imgKey) {
        this.shard = value;
        this.cmc = this.getCMC();
        this.cmpc = this.getCmpCost();
        this.stringValue = "{" + sValue + "}";
        this.imageKey = imgKey;
    }

    private int getCMC() {
        if (0 != (this.shard & 0x100)) {
            return 0;
        }
        if (0 != (this.shard & 0x200)) {
            return 2;
        }
        return 1;
    }

    private float getCmpCost() {
        float cost;
        if (0 != (this.shard & 0x100)) {
            return 1.0E-4f;
        }
        float f = cost = 0 != (this.shard & 0x200) ? 2.0f : 1.0f;
        if (0 != (this.shard & 1)) {
            cost += 5.0E-4f;
        }
        if (0 != (this.shard & 2)) {
            cost += 0.002f;
        }
        if (0 != (this.shard & 4)) {
            cost += 0.008f;
        }
        if (0 != (this.shard & 8)) {
            cost += 0.032f;
        }
        if (0 != (this.shard & 0x10)) {
            cost += 0.128f;
        }
        if (0 != (this.shard & 0x400)) {
            cost += 3.0E-5f;
        }
        return cost;
    }

    public final byte getColorMask() {
        return (byte)(this.shard & 0x1F);
    }

    public static ManaCostShard valueOf(int atoms) {
        if (atoms == 0) {
            return GENERIC;
        }
        for (ManaCostShard element : ManaCostShard.values()) {
            if (element.shard != atoms) continue;
            return element;
        }
        return null;
    }

    public static ManaCostShard parseNonGeneric(String unparsed) {
        int atoms = 0;
        block12: for (int iChar = 0; iChar < unparsed.length(); ++iChar) {
            char c = unparsed.charAt(iChar);
            switch (c) {
                case 'W': {
                    atoms |= 1;
                    continue block12;
                }
                case 'U': {
                    atoms |= 2;
                    continue block12;
                }
                case 'B': {
                    atoms |= 4;
                    continue block12;
                }
                case 'R': {
                    atoms |= 8;
                    continue block12;
                }
                case 'G': {
                    atoms |= 0x10;
                    continue block12;
                }
                case 'P': {
                    atoms |= 0x400;
                    continue block12;
                }
                case 'S': {
                    atoms |= 0x800;
                    continue block12;
                }
                case 'X': {
                    atoms |= 0x100;
                    continue block12;
                }
                case 'C': {
                    atoms |= 0x20;
                    continue block12;
                }
                case '2': {
                    atoms |= 0x200;
                    continue block12;
                }
                default: {
                    if (c > '9' || c < '0') continue block12;
                    atoms |= 0x40;
                }
            }
        }
        if (atoms == 512 || atoms == 576) {
            atoms = 64;
        }
        return ManaCostShard.valueOf(atoms);
    }

    public final String toString() {
        return this.stringValue;
    }

    public int getCmc() {
        return this.cmc;
    }

    public float getCmpc() {
        return this.cmpc;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public boolean isWhite() {
        return this.isOfKind(1);
    }

    public boolean isBlue() {
        return this.isOfKind(2);
    }

    public boolean isBlack() {
        return this.isOfKind(4);
    }

    public boolean isRed() {
        return this.isOfKind(8);
    }

    public boolean isGreen() {
        return this.isOfKind(16);
    }

    public boolean isPhyrexian() {
        return this.isOfKind(1024);
    }

    public boolean isSnow() {
        return this.isOfKind(2048);
    }

    public boolean isMonoColor() {
        return BinaryUtil.bitCount(this.shard & 0x1F) == 1;
    }

    public boolean isMultiColor() {
        return BinaryUtil.bitCount(this.shard & 0x1F) == 2;
    }

    public boolean isColorless() {
        return this.isOfKind(32);
    }

    public boolean isGeneric() {
        return this.isOfKind(64) || this.isOfKind(256) || this.isSnow() || this.isOr2Generic();
    }

    public boolean isOr2Generic() {
        return this.isOfKind(512);
    }

    public boolean isColor(byte colorCode) {
        return (colorCode & this.shard) > 0;
    }

    public boolean canBePaidWithManaOfColor(byte colorCode) {
        return this.isOr2Generic() || (0x3F & this.shard) == 0 || this.isColor(colorCode);
    }

    public boolean isOfKind(int atom) {
        return (this.shard & atom) != 0;
    }

    public int getShard() {
        return this.shard;
    }
}

