/*
 * Decompiled with CFR 0.152.
 */
package forge.card.mana;

import forge.card.mana.IParserManaCost;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import org.apache.commons.lang3.StringUtils;

public class ManaCostParser
implements IParserManaCost {
    private final String[] cost;
    private int nextToken;
    private int genericCost;

    public static String parse(String cost) {
        ManaCostParser parser = new ManaCostParser(cost);
        ManaCost manaCost = new ManaCost(parser);
        return manaCost.toString();
    }

    public ManaCostParser(String cost) {
        this.cost = cost.split(" ");
        this.nextToken = 0;
        this.genericCost = 0;
    }

    @Override
    public final int getTotalGenericCost() {
        if (this.hasNext()) {
            throw new RuntimeException("Generic cost should be obtained after iteration is complete");
        }
        return this.genericCost;
    }

    @Override
    public final boolean hasNext() {
        return this.nextToken < this.cost.length;
    }

    @Override
    public final ManaCostShard next() {
        String unparsed;
        if (StringUtils.isNumeric(unparsed = this.cost[this.nextToken++])) {
            this.genericCost += Integer.parseInt(unparsed);
            return null;
        }
        return ManaCostShard.parseNonGeneric(unparsed);
    }

    @Override
    public void remove() {
    }
}

