/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import forge.card.CardEdition;
import forge.deck.CardPool;
import forge.item.PaperCard;
import forge.util.ItemPool;
import forge.util.MyRandom;
import forge.util.storage.IStorage;
import forge.util.storage.StorageExtendable;
import forge.util.storage.StorageReaderFileSections;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PrintSheet {
    private final ItemPool<PaperCard> cardsWithWeights;
    private final String name;

    public static final IStorage<PrintSheet> initializePrintSheets(File sheetsFile, CardEdition.Collection editions) {
        StorageExtendable<PrintSheet> sheets = new StorageExtendable<PrintSheet>("Special print runs", new Reader(sheetsFile));
        for (CardEdition edition : editions) {
            for (PrintSheet ps : edition.getPrintSheetsBySection()) {
                sheets.add(ps.name, ps);
            }
        }
        return sheets;
    }

    public PrintSheet(String name0) {
        this(name0, null);
    }

    public PrintSheet(String name0, ItemPool<PaperCard> pool) {
        this.name = name0;
        this.cardsWithWeights = pool != null ? pool : new ItemPool<PaperCard>(PaperCard.class);
    }

    public void add(PaperCard card) {
        this.add(card, 1);
    }

    public void add(PaperCard card, int weight) {
        this.cardsWithWeights.add(card, weight);
    }

    public void addAll(Iterable<PaperCard> cards) {
        this.addAll(cards, 1);
    }

    public void addAll(Iterable<PaperCard> cards, int weight) {
        for (PaperCard card : cards) {
            this.cardsWithWeights.add(card, weight);
        }
    }

    public void removeAll(Iterable<PaperCard> cards) {
        for (PaperCard card : cards) {
            this.cardsWithWeights.remove(card);
        }
    }

    private PaperCard fetchRoulette(int start, int roulette, Collection<PaperCard> toSkip) {
        int sum = start;
        boolean isSecondRun = start > 0;
        for (Map.Entry<PaperCard, Integer> entry : this.cardsWithWeights) {
            if ((sum += entry.getValue().intValue()) <= roulette || toSkip != null && toSkip.contains(entry.getKey())) continue;
            return entry.getKey();
        }
        if (isSecondRun) {
            throw new IllegalStateException("Print sheet does not have enough unique cards");
        }
        return this.fetchRoulette(sum + 1, roulette, toSkip);
    }

    public List<PaperCard> all() {
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        for (Map.Entry<PaperCard, Integer> entry : this.cardsWithWeights) {
            for (int i = 0; i < entry.getValue(); ++i) {
                result.add(entry.getKey());
            }
        }
        return result;
    }

    public boolean containsCardNamed(String name, int atLeast) {
        int count = 0;
        for (Map.Entry<PaperCard, Integer> entry : this.cardsWithWeights) {
            for (int i = 0; i < entry.getValue(); ++i) {
                if (!entry.getKey().getName().equals(name) || ++count < atLeast) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public List<PaperCard> random(int number, boolean wantUnique) {
        void var7_9;
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        int totalWeight = this.cardsWithWeights.countAll();
        if (totalWeight == 0) {
            System.err.println("No cards were found on sheet " + this.name);
            return result;
        }
        int uniqueCards = this.cardsWithWeights.countDistinct();
        while (number >= uniqueCards) {
            for (Map.Entry<PaperCard, Integer> entry : this.cardsWithWeights) {
                result.add(entry.getKey());
            }
            number -= uniqueCards;
        }
        ArrayList<PaperCard> uniques = wantUnique ? new ArrayList<PaperCard>() : null;
        boolean bl = false;
        while (var7_9 < number) {
            int index = MyRandom.getRandom().nextInt(totalWeight);
            PaperCard toAdd = this.fetchRoulette(0, index, wantUnique ? uniques : null);
            result.add(toAdd);
            if (wantUnique) {
                uniques.add(toAdd);
            }
            ++var7_9;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.cardsWithWeights.isEmpty();
    }

    public Iterable<PaperCard> toFlatList() {
        return this.cardsWithWeights.toFlatList();
    }

    public static class Reader
    extends StorageReaderFileSections<PrintSheet> {
        public Reader(File file) {
            super(file, PrintSheet::getName);
        }

        @Override
        protected PrintSheet read(String title, Iterable<String> body, int idx) {
            return new PrintSheet(title, CardPool.fromCardList(body));
        }
    }
}

