/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.card.CardFaceSymbols;
import forge.card.ColorSet;
import forge.localinstance.skin.FSkinProp;

public class ColorSetImage
implements FImage {
    private final ColorSet colorSet;
    private final int shardCount;

    public ColorSetImage(ColorSet colorSet0) {
        this.colorSet = colorSet0;
        this.shardCount = this.colorSet.getOrderedShards().length;
    }

    @Override
    public float getWidth() {
        return Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_W).getWidth() * (float)this.shardCount;
    }

    @Override
    public float getHeight() {
        return Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_W).getHeight();
    }

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        float imageSize = w / (float)this.shardCount;
        if (imageSize > h2) {
            imageSize = h2;
            float w0 = imageSize * (float)this.shardCount;
            x += (w - w0) / 2.0f;
            w = w0;
        }
        CardFaceSymbols.drawColorSet(g2, this.colorSet, x, y, imageSize);
    }
}

