/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardImageRenderer;
import forge.card.CardStateName;
import forge.deck.ArchetypeDeckGenerator;
import forge.deck.CardThemedDeckGenerator;
import forge.deck.CommanderDeckGenerator;
import forge.deck.DeckProxy;
import forge.game.GameView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.MatchController;
import forge.toolbox.FDialog;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.util.ImageUtil;
import forge.util.Utils;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CardZoom
extends FOverlay {
    private static final float REQ_AMOUNT = Utils.AVG_FINGER_WIDTH;
    private static final CardZoom cardZoom = new CardZoom();
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static List<?> items;
    private static int currentIndex;
    private static int initialIndex;
    private static CardView currentCard;
    private static CardView prevCard;
    private static CardView nextCard;
    private static boolean zoomMode;
    private static boolean oneCardView;
    private float totalZoomAmount;
    private static ActivateHandler activateHandler;
    private static String currentActivateAction;
    private static Rectangle flipIconBounds;
    private static Rectangle mutateIconBounds;
    private static FLabel specialize;
    private static boolean showAltState;
    private static boolean showBackSide;
    private static boolean showMerged;

    public static void show(Object item) {
        CardZoom.show(item, false);
    }

    public static void show(Object item, boolean showbackside) {
        ArrayList<Object> items0 = new ArrayList<Object>();
        items0.add(item);
        showBackSide = showbackside;
        CardZoom.show(items0, 0, null);
    }

    public static void show(FCollectionView<?> items0, int currentIndex0, ActivateHandler activateHandler0) {
        CardZoom.show((List)((Object)items0), currentIndex0, activateHandler0);
    }

    public static void show(List<?> items0, int currentIndex0, ActivateHandler activateHandler0) {
        items = items0;
        if (items == null) {
            return;
        }
        if (currentIndex0 < 0 || items.size() <= currentIndex0) {
            return;
        }
        activateHandler = activateHandler0;
        currentIndex = currentIndex0;
        initialIndex = currentIndex0;
        currentCard = CardZoom.getCardView(items.get(currentIndex));
        prevCard = currentIndex > 0 ? CardZoom.getCardView(items.get(currentIndex - 1)) : null;
        nextCard = currentIndex < items.size() - 1 ? CardZoom.getCardView(items.get(currentIndex + 1)) : null;
        CardZoom.onCardChanged();
        cardZoom.show();
    }

    public static boolean isOpen() {
        return cardZoom.isVisible();
    }

    public static void hideZoom() {
        if (activateHandler != null) {
            activateHandler.setSelectedIndex(currentIndex);
        }
        cardZoom.hide();
    }

    private CardZoom() {
        specialize = this.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblSpecialized", new Object[0])).font(FSkinFont.get(12)).selectable().command(e -> {
            if (currentCard != null) {
                ArrayList<CardView> list = new ArrayList<CardView>();
                PaperCard pc = ImageUtil.getPaperCardFromImageKey(currentCard.getCurrentState().getTrackableImageKey());
                if (pc != null) {
                    Card cardW = Card.fromPaperCard(pc, null);
                    cardW.setState(CardStateName.SpecializeW, true);
                    cardW.setImageKey(pc, CardStateName.SpecializeW);
                    list.add(cardW.getView());
                    Card cardU = Card.fromPaperCard(pc, null);
                    cardU.setState(CardStateName.SpecializeU, true);
                    cardU.setImageKey(pc, CardStateName.SpecializeU);
                    list.add(cardU.getView());
                    Card cardB = Card.fromPaperCard(pc, null);
                    cardB.setState(CardStateName.SpecializeB, true);
                    cardB.setImageKey(pc, CardStateName.SpecializeB);
                    list.add(cardB.getView());
                    Card cardR = Card.fromPaperCard(pc, null);
                    cardR.setState(CardStateName.SpecializeR, true);
                    cardR.setImageKey(pc, CardStateName.SpecializeR);
                    list.add(cardR.getView());
                    Card cardG = Card.fromPaperCard(pc, null);
                    cardG.setState(CardStateName.SpecializeG, true);
                    cardG.setImageKey(pc, CardStateName.SpecializeG);
                    list.add(cardG.getView());
                }
                if (!list.isEmpty()) {
                    CardZoom.show(list, 0, null);
                }
            }
        }).buildAboveOverlay());
        specialize.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible0) {
        if (this.isVisible() == visible0) {
            return;
        }
        super.setVisible(visible0);
        if (!visible0 && activateHandler != null && currentIndex != initialIndex) {
            activateHandler.setSelectedIndex(currentIndex);
        }
    }

    private static void incrementCard(int dir) {
        if (dir > 0) {
            if (currentIndex == items.size() - 1) {
                return;
            }
            prevCard = currentCard;
            currentCard = nextCard;
            nextCard = ++currentIndex < items.size() - 1 ? CardZoom.getCardView(items.get(currentIndex + 1)) : null;
        } else {
            if (currentIndex == 0) {
                return;
            }
            nextCard = currentCard;
            currentCard = prevCard;
            prevCard = --currentIndex > 0 ? CardZoom.getCardView(items.get(currentIndex - 1)) : null;
        }
        CardZoom.onCardChanged();
    }

    private static void onCardChanged() {
        mutateIconBounds = null;
        if (activateHandler != null) {
            currentActivateAction = activateHandler.getActivateAction(currentIndex);
        }
        flipIconBounds = MatchController.instance.mayFlip(currentCard) ? new Rectangle() : null;
        if (currentCard != null && currentCard.getMergedCardsCollection() != null && currentCard.getMergedCardsCollection().size() > 0) {
            mutateIconBounds = new Rectangle();
        }
        showAltState = false;
        if (currentCard != null && currentCard.canSpecialize() && currentCard.getCurrentState().getState() == CardStateName.Original) {
            specialize.setVisible(true);
        } else {
            specialize.setVisible(false);
        }
    }

    private static CardView getCardView(Object item) {
        if (item instanceof Map.Entry) {
            item = ((Map.Entry)item).getKey();
        }
        if (item instanceof CardView) {
            return (CardView)item;
        }
        if (item instanceof DeckProxy) {
            if (item instanceof CardThemedDeckGenerator) {
                return CardView.getCardForUi(((CardThemedDeckGenerator)item).getPaperCard());
            }
            if (item instanceof CommanderDeckGenerator) {
                return CardView.getCardForUi(((CommanderDeckGenerator)item).getPaperCard());
            }
            if (item instanceof ArchetypeDeckGenerator) {
                return CardView.getCardForUi(((ArchetypeDeckGenerator)item).getPaperCard());
            }
            DeckProxy deck = (DeckProxy)item;
            return new CardView(-1, null, deck.getName(), null, deck.getImageKey(false));
        }
        if (item instanceof IPaperCard) {
            return CardView.getCardForUi((IPaperCard)item);
        }
        if (item instanceof ConquestCommander) {
            return CardView.getCardForUi(((ConquestCommander)item).getCard());
        }
        if (item instanceof InventoryItem) {
            InventoryItem ii = (InventoryItem)item;
            return new CardView(-1, null, ii.getName(), null, ii.getImageKey(false));
        }
        return new CardView(-1, null, item.toString());
    }

    @Override
    public boolean tap(float x, float y, int count) {
        if (mutateIconBounds != null && mutateIconBounds.contains(x, y)) {
            if (showMerged) {
                showMerged = false;
            } else {
                showMerged = true;
                CardZoom.show(currentCard.getMergedCardsCollection(), 0, null);
            }
            return true;
        }
        if (flipIconBounds != null && flipIconBounds.contains(x, y)) {
            if (currentCard.isFaceDown() && currentCard.getBackup() != null && (currentCard.getBackup().hasBackSide() || currentCard.getBackup().isFlipCard() || currentCard.getBackup().isAdventureCard())) {
                CardZoom.show(currentCard.getBackup());
                return true;
            }
            if (!showBackSide) {
                showAltState = !showAltState;
            } else {
                showBackSide = !showBackSide;
            }
            return true;
        }
        this.hide();
        showBackSide = false;
        showAltState = false;
        showMerged = false;
        return true;
    }

    @Override
    public boolean fling(float velocityX, float velocityY) {
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            CardZoom.incrementCard(velocityX > 0.0f ? -1 : 1);
            showBackSide = false;
            showAltState = false;
            return true;
        }
        if (velocityY > 0.0f) {
            zoomMode = !zoomMode;
            showBackSide = false;
            showAltState = false;
            return true;
        }
        if (currentActivateAction != null && activateHandler != null) {
            this.hide();
            showBackSide = false;
            showAltState = false;
            activateHandler.activate(currentIndex);
            return true;
        }
        return false;
    }

    private void setOneCardView(boolean oneCardView0) {
        if (oneCardView == oneCardView0 || Forge.isLandscapeMode()) {
            return;
        }
        oneCardView = oneCardView0;
        prefs.setPref(ForgePreferences.FPref.UI_SINGLE_CARD_ZOOM, oneCardView0);
        prefs.save();
    }

    @Override
    public boolean zoom(float x, float y, float amount) {
        this.totalZoomAmount += amount;
        if (this.totalZoomAmount >= REQ_AMOUNT) {
            this.setOneCardView(true);
            this.totalZoomAmount = 0.0f;
        } else if (this.totalZoomAmount <= -REQ_AMOUNT) {
            this.setOneCardView(false);
            this.totalZoomAmount = 0.0f;
        }
        return true;
    }

    @Override
    public boolean longPress(float x, float y) {
        this.setOneCardView(!oneCardView);
        return true;
    }

    @Override
    public void drawOverlay(Graphics g2) {
        float y;
        float cardHeight;
        float cardWidth;
        float AspectRatioMultiplier;
        GameView gameView = MatchController.instance.getGameView();
        float w = this.getWidth();
        float h2 = this.getHeight();
        float messageHeight = FDialog.MSG_HEIGHT;
        switch (Forge.extrawide) {
            case "default": {
                AspectRatioMultiplier = 3.0f;
                break;
            }
            case "wide": {
                AspectRatioMultiplier = 2.5f;
                break;
            }
            case "extrawide": {
                AspectRatioMultiplier = 2.0f;
                break;
            }
            default: {
                AspectRatioMultiplier = 3.0f;
            }
        }
        float maxCardHeight = h2 - AspectRatioMultiplier * messageHeight;
        if (oneCardView && !Forge.isLandscapeMode()) {
            cardWidth = w;
            cardHeight = 1.4f * cardWidth;
            boolean rotateSplit = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ROTATE_SPLIT_CARDS);
            if (currentCard != null && currentCard.isSplitCard() && rotateSplit && cardHeight > (float)Gdx.graphics.getWidth()) {
                cardHeight = Gdx.graphics.getWidth();
                cardWidth = cardHeight / 1.4f;
            }
        } else {
            cardWidth = w * 0.5f;
            cardHeight = 1.4f * cardWidth;
            float maxSideCardHeight = maxCardHeight * 5.0f / 7.0f;
            if (cardHeight > maxSideCardHeight) {
                cardHeight = maxSideCardHeight;
                cardWidth = cardHeight / 1.4f;
            }
            y = (h2 - cardHeight) / 2.0f;
            if (prevCard != null) {
                CardImageRenderer.drawZoom(g2, prevCard, gameView, false, 0.0f, y, cardWidth, cardHeight, this.getWidth(), this.getHeight(), false);
            }
            if (nextCard != null) {
                CardImageRenderer.drawZoom(g2, nextCard, gameView, false, w - cardWidth, y, cardWidth, cardHeight, this.getWidth(), this.getHeight(), false);
            }
            cardWidth = w * 0.7f;
            cardHeight = 1.4f * cardWidth;
        }
        if (cardHeight > maxCardHeight) {
            cardHeight = maxCardHeight;
            cardWidth = cardHeight / 1.4f;
        }
        float x = (w - cardWidth) / 2.0f;
        y = (h2 - cardHeight) / 2.0f;
        if (zoomMode) {
            CardImageRenderer.drawZoom(g2, currentCard, gameView, showBackSide ? showBackSide : showAltState, x, y, cardWidth, cardHeight, this.getWidth(), this.getHeight(), true);
        } else {
            CardImageRenderer.drawDetails(g2, currentCard, gameView, showBackSide ? showBackSide : showAltState, x, y, cardWidth, cardHeight);
        }
        if (!showMerged) {
            if (mutateIconBounds != null) {
                float oldAlpha = g2.getfloatAlphaComposite();
                try {
                    g2.setAlphaComposite(0.6f);
                    this.drawIconBounds(g2, mutateIconBounds, Forge.hdbuttons ? FSkinImage.HDLIBRARY : FSkinImage.LIBRARY, x, y, cardWidth, cardHeight);
                    g2.setAlphaComposite(oldAlpha);
                }
                catch (Exception e) {
                    mutateIconBounds = null;
                    g2.setAlphaComposite(oldAlpha);
                }
            } else if (flipIconBounds != null) {
                this.drawIconBounds(g2, flipIconBounds, Forge.hdbuttons ? FSkinImage.HDFLIPCARD : FSkinImage.FLIPCARD, x, y, cardWidth, cardHeight);
            }
        } else if (flipIconBounds != null) {
            this.drawIconBounds(g2, flipIconBounds, Forge.hdbuttons ? FSkinImage.HDFLIPCARD : FSkinImage.FLIPCARD, x, y, cardWidth, cardHeight);
        }
        if (currentActivateAction != null) {
            g2.fillRect(FDialog.getMsgBackColor(), 0.0f, 0.0f, w, messageHeight);
            g2.drawText(Forge.getLocalizer().getMessage("lblSwipeUpTo", new Object[0]).replace("%s", currentActivateAction), FDialog.MSG_FONT, FDialog.getMsgForeColor(), 0.0f, 0.0f, w, messageHeight, false, 1, true);
        }
        g2.fillRect(FDialog.getMsgBackColor(), 0.0f, h2 - messageHeight, w, messageHeight);
        g2.drawText(zoomMode ? Forge.getLocalizer().getMessage("lblSwipeDownDetailView", new Object[0]) : Forge.getLocalizer().getMessage("lblSwipeDownPictureView", new Object[0]), FDialog.MSG_FONT, FDialog.getMsgForeColor(), 0.0f, h2 - messageHeight, w, messageHeight, false, 1, true);
        if (specialize.isVisible()) {
            specialize.setBounds(w / 2.0f - CardZoom.specialize.getAutoSizeBounds().width / 2.0f, h2 - CardZoom.specialize.getAutoSizeBounds().height - messageHeight, CardZoom.specialize.getAutoSizeBounds().width, CardZoom.specialize.getAutoSizeBounds().height);
        }
        this.interrupt(false);
    }

    private void drawIconBounds(Graphics g2, Rectangle iconBounds, FSkinImage skinImage, float x, float y, float cardWidth, float cardHeight) {
        float imageWidth = cardWidth / 2.0f;
        float imageHeight = imageWidth * skinImage.getHeight() / skinImage.getWidth();
        iconBounds.set(x + (cardWidth - imageWidth) / 2.0f, y + (cardHeight - imageHeight) / 2.0f, imageWidth, imageHeight);
        g2.drawImage(skinImage, iconBounds.x, iconBounds.y, iconBounds.width, iconBounds.height);
    }

    @Override
    protected void doLayout(float width, float height) {
    }

    public void interrupt(boolean resume) {
        if (MatchController.instance.hasLocalPlayers()) {
            return;
        }
        if (resume && MatchController.instance.isGamePaused()) {
            MatchController.instance.resumeMatch();
            return;
        }
        if (!MatchController.instance.isGamePaused()) {
            MatchController.instance.pauseMatch();
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (Forge.hasGamepad()) {
            if (keyCode == 21) {
                this.fling(300.0f, 0.0f);
            } else if (keyCode == 22) {
                this.fling(-300.0f, 0.0f);
            } else if (keyCode == 97) {
                CardZoom.hideZoom();
            } else if (keyCode == 96) {
                this.fling(0.0f, -300.0f);
            } else if (keyCode == 99) {
                if (mutateIconBounds != null) {
                    this.tap(CardZoom.mutateIconBounds.x, CardZoom.mutateIconBounds.y, 1);
                }
                if (flipIconBounds != null) {
                    this.tap(CardZoom.flipIconBounds.x, CardZoom.flipIconBounds.y, 1);
                }
            } else if (keyCode == 100) {
                this.fling(0.0f, 300.0f);
            }
            return true;
        }
        return super.keyDown(keyCode);
    }

    static {
        zoomMode = true;
        oneCardView = prefs.getPrefBoolean(ForgePreferences.FPref.UI_SINGLE_CARD_ZOOM);
        showBackSide = false;
        showMerged = false;
    }

    public static interface ActivateHandler {
        public String getActivateAction(int var1);

        public void setSelectedIndex(int var1);

        public void activate(int var1);
    }
}

