/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import forge.card.CardFace;
import forge.card.CardStateName;

public enum CardSplitType {
    None(CardFace.FaceSelectionMethod.USE_PRIMARY_FACE, null),
    Transform(CardFace.FaceSelectionMethod.USE_ACTIVE_FACE, CardStateName.Transformed),
    Meld(CardFace.FaceSelectionMethod.USE_ACTIVE_FACE, CardStateName.Meld),
    Split(CardFace.FaceSelectionMethod.COMBINE, CardStateName.RightSplit),
    Flip(CardFace.FaceSelectionMethod.USE_PRIMARY_FACE, CardStateName.Flipped),
    Adventure(CardFace.FaceSelectionMethod.USE_PRIMARY_FACE, CardStateName.Adventure),
    Modal(CardFace.FaceSelectionMethod.USE_ACTIVE_FACE, CardStateName.Modal),
    Specialize(CardFace.FaceSelectionMethod.USE_ACTIVE_FACE, null);

    private final CardFace.FaceSelectionMethod method;
    private final CardStateName changedStateName;

    private CardSplitType(CardFace.FaceSelectionMethod calcMode, CardStateName stateName) {
        this.method = calcMode;
        this.changedStateName = stateName;
    }

    public CardFace.FaceSelectionMethod getAggregationMethod() {
        return this.method;
    }

    public static CardSplitType smartValueOf(String text) {
        if ("DoubleFaced".equals(text)) {
            return Transform;
        }
        CardSplitType res = CardSplitType.valueOf(text);
        return res;
    }

    public CardStateName getChangedStateName() {
        return this.changedStateName;
    }
}

