/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.CardType;
import forge.card.DeckHints;
import forge.card.ICardFace;
import forge.util.CardTranslation;
import forge.util.ComparableOp;
import forge.util.PredicateString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class CardRulesPredicates {
    public static final Predicate<CardRules> IS_KEPT_IN_AI_DECKS = card -> !card.getAiHints().getRemAIDecks();
    public static final Predicate<CardRules> IS_KEPT_IN_AI_LIMITED_DECKS = card -> !card.getAiHints().getRemAIDecks() && !card.getAiHints().getRemNonCommanderDecks();
    public static final Predicate<CardRules> IS_KEPT_IN_RANDOM_DECKS = card -> !card.getAiHints().getRemRandomDecks();

    public static Predicate<CardRules> cmc(ComparableOp op, int what) {
        return new LeafNumber(LeafNumber.CardField.CMC, op, what);
    }

    public static Predicate<CardRules> cost(PredicateString.StringOp op, String what) {
        return new LeafString(LeafString.CardField.COST, op, what);
    }

    public static Predicate<CardRules> power(ComparableOp op, int what) {
        return new LeafNumber(LeafNumber.CardField.POWER, op, what);
    }

    public static Predicate<CardRules> toughness(ComparableOp op, int what) {
        return new LeafNumber(LeafNumber.CardField.TOUGHNESS, op, what);
    }

    public static Predicate<CardRules> rules(PredicateString.StringOp op, String what) {
        return new LeafString(LeafString.CardField.ORACLE_TEXT, op, what);
    }

    public static Predicate<CardRules> name(PredicateString.StringOp op, String what) {
        return new LeafString(LeafString.CardField.NAME, op, what);
    }

    public static Predicate<CardRules> splitType(CardSplitType transform) {
        return new PredicateSplitType(transform);
    }

    public static Predicate<CardRules> subType(String what) {
        return new LeafString(LeafString.CardField.SUBTYPE, PredicateString.StringOp.CONTAINS, what);
    }

    public static Predicate<CardRules> subType(PredicateString.StringOp op, String what) {
        return new LeafString(LeafString.CardField.SUBTYPE, op, what);
    }

    public static Predicate<CardRules> joinedType(PredicateString.StringOp op, String what) {
        return new LeafString(LeafString.CardField.JOINED_TYPE, op, what);
    }

    public static Predicate<CardRules> hasCreatureType(String ... creatureTypes) {
        return card -> {
            if (!card.getType().isCreature()) {
                return false;
            }
            return !Collections.disjoint(card.getType().getCreatureTypes(), Arrays.asList(creatureTypes));
        };
    }

    public static Predicate<CardRules> hasKeyword(String keyword) {
        return card -> Iterables.any(card.getAllFaces(), cf -> cf != null && card.hasStartOfKeyword(keyword, (ICardFace)cf));
    }

    public static Predicate<CardRules> deckHas(DeckHints.Type type, String has) {
        return card -> {
            DeckHints deckHas = card.getAiHints().getDeckHas();
            return deckHas != null && deckHas.isValid() && deckHas.contains(type, has);
        };
    }

    public static Predicate<CardRules> deckHasExactly(DeckHints.Type type, String[] has) {
        return card -> {
            DeckHints deckHas = card.getAiHints().getDeckHas();
            return deckHas != null && deckHas.isValid() && deckHas.is(type, has);
        };
    }

    public static Predicate<CardRules> coreType(boolean isEqual, String what) {
        try {
            return CardRulesPredicates.coreType(isEqual, Enum.valueOf(CardType.CoreType.class, what));
        }
        catch (Exception e) {
            return Predicates.alwaysFalse();
        }
    }

    public static Predicate<CardRules> coreType(boolean isEqual, CardType.CoreType type) {
        return new PredicateCoreType(type, isEqual);
    }

    public static Predicate<CardRules> superType(boolean isEqual, String what) {
        try {
            return CardRulesPredicates.superType(isEqual, Enum.valueOf(CardType.Supertype.class, what));
        }
        catch (Exception e) {
            return Predicates.alwaysFalse();
        }
    }

    public static Predicate<CardRules> superType(boolean isEqual, CardType.Supertype type) {
        return new PredicateSuperType(type, isEqual);
    }

    public static Predicate<CardRules> hasColor(byte thatColor) {
        return new LeafColor(LeafColor.ColorOperator.HasAllOf, thatColor);
    }

    public static Predicate<CardRules> isColor(byte thatColor) {
        return new LeafColor(LeafColor.ColorOperator.HasAnyOf, thatColor);
    }

    public static Predicate<CardRules> canCastWithAvailable(byte thatColor) {
        return new LeafColor(LeafColor.ColorOperator.CanCast, thatColor);
    }

    public static Predicate<CardRules> isMonoColor(byte thatColor) {
        return new LeafColor(LeafColor.ColorOperator.Equals, thatColor);
    }

    public static Predicate<CardRules> hasCntColors(byte cntColors) {
        return new LeafColor(LeafColor.ColorOperator.CountColors, cntColors);
    }

    public static Predicate<CardRules> hasAtLeastCntColors(byte cntColors) {
        return new LeafColor(LeafColor.ColorOperator.CountColorsGreaterOrEqual, cntColors);
    }

    public static Predicate<CardRules> hasColorIdentity(int colormask) {
        return rules -> rules.getColorIdentity().hasNoColorsExcept(colormask);
    }

    public static Predicate<CardRules> canBePartnerCommanderWith(CardRules commander) {
        return rules -> rules.canBePartnerCommanders(commander);
    }

    public static class Presets {
        public static final Predicate<CardRules> IS_CREATURE = CardRulesPredicates.coreType(true, CardType.CoreType.Creature);
        public static final Predicate<CardRules> IS_LEGENDARY = CardRulesPredicates.superType(true, CardType.Supertype.Legendary);
        public static final Predicate<CardRules> IS_ARTIFACT = CardRulesPredicates.coreType(true, CardType.CoreType.Artifact);
        public static final Predicate<CardRules> IS_EQUIPMENT = CardRulesPredicates.subType("Equipment");
        public static final Predicate<CardRules> IS_LAND = CardRulesPredicates.coreType(true, CardType.CoreType.Land);
        public static final Predicate<CardRules> IS_BASIC_LAND = subject -> subject.getType().isBasicLand();
        public static final Predicate<CardRules> IS_BASIC_LAND_NOT_WASTES = subject -> !subject.getName().equals("Wastes") && subject.getType().isBasicLand();
        public static final Predicate<CardRules> IS_NONBASIC_LAND = subject -> subject.getType().isLand() && !subject.getType().isBasicLand();
        public static final Predicate<CardRules> CAN_BE_COMMANDER = CardRules::canBeCommander;
        public static final Predicate<CardRules> CAN_BE_PARTNER_COMMANDER = CardRules::canBePartnerCommander;
        public static final Predicate<CardRules> CAN_BE_OATHBREAKER = CardRules::canBeOathbreaker;
        public static final Predicate<CardRules> CAN_BE_SIGNATURE_SPELL = CardRules::canBeSignatureSpell;
        public static final Predicate<CardRules> IS_PLANESWALKER = CardRulesPredicates.coreType(true, CardType.CoreType.Planeswalker);
        public static final Predicate<CardRules> IS_BATTLE = CardRulesPredicates.coreType(true, CardType.CoreType.Battle);
        public static final Predicate<CardRules> IS_INSTANT = CardRulesPredicates.coreType(true, CardType.CoreType.Instant);
        public static final Predicate<CardRules> IS_SORCERY = CardRulesPredicates.coreType(true, CardType.CoreType.Sorcery);
        public static final Predicate<CardRules> IS_ENCHANTMENT = CardRulesPredicates.coreType(true, CardType.CoreType.Enchantment);
        public static final Predicate<CardRules> IS_PLANE = CardRulesPredicates.coreType(true, CardType.CoreType.Plane);
        public static final Predicate<CardRules> IS_PHENOMENON = CardRulesPredicates.coreType(true, CardType.CoreType.Phenomenon);
        public static final Predicate<CardRules> IS_PLANE_OR_PHENOMENON = Predicates.or(IS_PLANE, IS_PHENOMENON);
        public static final Predicate<CardRules> IS_SCHEME = CardRulesPredicates.coreType(true, CardType.CoreType.Scheme);
        public static final Predicate<CardRules> IS_VANGUARD = CardRulesPredicates.coreType(true, CardType.CoreType.Vanguard);
        public static final Predicate<CardRules> IS_CONSPIRACY = CardRulesPredicates.coreType(true, CardType.CoreType.Conspiracy);
        public static final Predicate<CardRules> IS_DUNGEON = CardRulesPredicates.coreType(true, CardType.CoreType.Dungeon);
        public static final Predicate<CardRules> IS_ATTRACTION = Predicates.and(IS_ARTIFACT, CardRulesPredicates.subType("Attraction"));
        public static final Predicate<CardRules> IS_NON_LAND = CardRulesPredicates.coreType(false, CardType.CoreType.Land);
        public static final Predicate<CardRules> CAN_BE_BRAWL_COMMANDER = Predicates.and(IS_LEGENDARY, Predicates.or(IS_CREATURE, IS_PLANESWALKER));
        public static final Predicate<CardRules> CAN_BE_TINY_LEADERS_COMMANDER = Predicates.and(IS_LEGENDARY, Predicates.or(IS_CREATURE, IS_PLANESWALKER));
        public static final Predicate<CardRules> IS_NON_CREATURE_SPELL = Predicates.or(IS_SORCERY, IS_INSTANT, IS_PLANESWALKER, IS_ENCHANTMENT, Predicates.and(IS_ARTIFACT, Predicates.not(IS_CREATURE)));
        public static final Predicate<CardRules> IS_WHITE = CardRulesPredicates.isColor((byte)1);
        public static final Predicate<CardRules> IS_BLUE = CardRulesPredicates.isColor((byte)2);
        public static final Predicate<CardRules> IS_BLACK = CardRulesPredicates.isColor((byte)4);
        public static final Predicate<CardRules> IS_RED = CardRulesPredicates.isColor((byte)8);
        public static final Predicate<CardRules> IS_GREEN = CardRulesPredicates.isColor((byte)16);
        public static final Predicate<CardRules> IS_COLORLESS = CardRulesPredicates.hasCntColors((byte)0);
        public static final Predicate<CardRules> IS_MULTICOLOR = CardRulesPredicates.hasAtLeastCntColors((byte)2);
        public static final Predicate<CardRules> IS_MONOCOLOR = CardRulesPredicates.hasCntColors((byte)1);
        public static final List<Predicate<CardRules>> COLORS = new ArrayList<Predicate<CardRules>>();

        static {
            COLORS.add(IS_WHITE);
            COLORS.add(IS_BLUE);
            COLORS.add(IS_BLACK);
            COLORS.add(IS_RED);
            COLORS.add(IS_GREEN);
            COLORS.add(IS_COLORLESS);
        }
    }

    private static class PredicateSplitType
    implements Predicate<CardRules> {
        private final CardSplitType cst;

        public PredicateSplitType(CardSplitType type) {
            this.cst = type;
        }

        @Override
        public boolean apply(CardRules subject) {
            return subject.getSplitType() == this.cst;
        }
    }

    private static class PredicateSuperType
    implements Predicate<CardRules> {
        private final CardType.Supertype operand;
        private final boolean shouldBeEqual;

        @Override
        public boolean apply(CardRules card) {
            return this.shouldBeEqual == card.getType().hasSupertype(this.operand);
        }

        public PredicateSuperType(CardType.Supertype type, boolean wantEqual) {
            this.operand = type;
            this.shouldBeEqual = wantEqual;
        }
    }

    private static class PredicateCoreType
    implements Predicate<CardRules> {
        private final CardType.CoreType operand;
        private final boolean shouldBeEqual;

        @Override
        public boolean apply(CardRules card) {
            if (null == card) {
                return false;
            }
            return this.shouldBeEqual == card.getType().hasType(this.operand);
        }

        public PredicateCoreType(CardType.CoreType type, boolean wantEqual) {
            this.operand = type;
            this.shouldBeEqual = wantEqual;
        }
    }

    public static class LeafNumber
    implements Predicate<CardRules> {
        private final CardField field;
        private final ComparableOp operator;
        private final int operand;

        public LeafNumber(CardField field, ComparableOp op, int what) {
            this.field = field;
            this.operand = what;
            this.operator = op;
        }

        @Override
        public boolean apply(CardRules card) {
            switch (this.field) {
                case CMC: {
                    return this.op(card.getManaCost().getCMC(), this.operand);
                }
                case GENERIC_COST: {
                    return this.op(card.getManaCost().getGenericCost(), this.operand);
                }
                case POWER: {
                    int value = card.getIntPower();
                    return value != Integer.MAX_VALUE && this.op(value, this.operand);
                }
                case TOUGHNESS: {
                    int value = card.getIntToughness();
                    return value != Integer.MAX_VALUE && this.op(value, this.operand);
                }
            }
            return false;
        }

        private boolean op(int op1, int op2) {
            switch (this.operator) {
                case EQUALS: {
                    return op1 == op2;
                }
                case GREATER_THAN: {
                    return op1 > op2;
                }
                case GT_OR_EQUAL: {
                    return op1 >= op2;
                }
                case LESS_THAN: {
                    return op1 < op2;
                }
                case LT_OR_EQUAL: {
                    return op1 <= op2;
                }
                case NOT_EQUALS: {
                    return op1 != op2;
                }
            }
            return false;
        }

        public static enum CardField {
            CMC,
            GENERIC_COST,
            POWER,
            TOUGHNESS;

        }
    }

    private static class LeafColor
    implements Predicate<CardRules> {
        private final ColorOperator op;
        private final byte color;

        public LeafColor(ColorOperator operator, byte thatColor) {
            this.op = operator;
            this.color = thatColor;
        }

        @Override
        public boolean apply(CardRules subject) {
            if (null == subject) {
                return false;
            }
            switch (this.op) {
                case CountColors: {
                    return subject.getColor().countColors() == this.color;
                }
                case CountColorsGreaterOrEqual: {
                    return subject.getColor().countColors() >= this.color;
                }
                case Equals: {
                    return subject.getColor().isEqual(this.color);
                }
                case HasAllOf: {
                    return subject.getColor().hasAllColors(this.color);
                }
                case HasAnyOf: {
                    return subject.getColor().hasAnyColor(this.color);
                }
                case CanCast: {
                    return subject.canCastWithAvailable(this.color);
                }
            }
            return false;
        }

        public static enum ColorOperator {
            CountColors,
            CountColorsGreaterOrEqual,
            HasAnyOf,
            HasAllOf,
            Equals,
            CanCast;

        }
    }

    private static class LeafString
    extends PredicateString<CardRules> {
        private final String operand;
        private final CardField field;

        protected boolean checkName(String name) {
            return this.op(name, this.operand) || this.op(CardTranslation.getTranslatedName(name), this.operand) || this.op(StringUtils.stripAccents(name), this.operand);
        }

        protected boolean checkOracle(ICardFace face) {
            if (face == null) {
                return false;
            }
            if (face.hasFunctionalVariants()) {
                for (Map.Entry<String, ? extends ICardFace> v : face.getFunctionalVariants().entrySet()) {
                    String origOracle = v.getValue().getOracleText();
                    if (this.op(origOracle, this.operand)) {
                        return true;
                    }
                    String name = v.getValue().getName() + " $" + v.getKey();
                    if (!this.op(CardTranslation.getTranslatedOracle(name), this.operand)) continue;
                    return true;
                }
            }
            return this.op(face.getOracleText(), this.operand) || this.op(CardTranslation.getTranslatedOracle(face.getName()), this.operand);
        }

        protected boolean checkType(ICardFace face) {
            if (face == null) {
                return false;
            }
            if (face.hasFunctionalVariants()) {
                for (Map.Entry<String, ? extends ICardFace> v : face.getFunctionalVariants().entrySet()) {
                    String origType = v.getValue().getType().toString();
                    if (this.op(origType, this.operand)) {
                        return true;
                    }
                    String name = v.getValue().getName() + " $" + v.getKey();
                    if (!this.op(CardTranslation.getTranslatedType(name, origType), this.operand)) continue;
                    return true;
                }
            }
            return this.op(CardTranslation.getTranslatedType(face.getName(), face.getType().toString()), this.operand) || this.op(face.getType().toString(), this.operand);
        }

        @Override
        public boolean apply(CardRules card) {
            switch (this.field) {
                case NAME: {
                    for (ICardFace face : card.getAllFaces()) {
                        if (face == null || !this.checkName(face.getName())) continue;
                        return true;
                    }
                    return false;
                }
                case SUBTYPE: {
                    boolean shouldContain = this.getOperator() == PredicateString.StringOp.CONTAINS || this.getOperator() == PredicateString.StringOp.EQUALS;
                    return shouldContain == card.getType().hasSubtype(this.operand);
                }
                case ORACLE_TEXT: {
                    for (ICardFace face : card.getAllFaces()) {
                        if (!this.checkOracle(face)) continue;
                        return true;
                    }
                    return false;
                }
                case JOINED_TYPE: {
                    if (this.op(CardTranslation.getTranslatedType(card.getName(), card.getType().toString()), this.operand) || this.op(card.getType().toString(), this.operand)) {
                        return true;
                    }
                    for (ICardFace face : card.getAllFaces()) {
                        if (!this.checkType(face)) continue;
                        return true;
                    }
                    return false;
                }
                case COST: {
                    String cost = card.getManaCost().toString();
                    return this.op(cost, this.operand);
                }
            }
            return false;
        }

        public LeafString(CardField field, PredicateString.StringOp operator, String operand) {
            super(operator);
            this.field = field;
            this.operand = operand;
        }

        public static enum CardField {
            ORACLE_TEXT,
            NAME,
            SUBTYPE,
            JOINED_TYPE,
            COST;

        }
    }
}

