/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

public enum CardRarity {
    BasicLand("L", "Basic Land"),
    Common("C", "Common"),
    Uncommon("U", "Uncommon"),
    Rare("R", "Rare"),
    MythicRare("M", "Mythic Rare"),
    Special("S", "Special"),
    Token("T", "Token"),
    Unknown("?", "Unknown");

    public static final CardRarity[] FILTER_OPTIONS;
    private final String shortName;
    private final String longName;

    private CardRarity(String shortName0, String longName0) {
        this.shortName = shortName0;
        this.longName = longName0;
    }

    public String toString() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public static CardRarity smartValueOf(String input) {
        for (CardRarity r : CardRarity.values()) {
            if (!r.name().equalsIgnoreCase(input) && !r.shortName.equalsIgnoreCase(input) && !r.longName.equalsIgnoreCase(input)) continue;
            return r;
        }
        return Unknown;
    }

    static {
        FILTER_OPTIONS = new CardRarity[]{Common, Uncommon, Rare, MythicRare, Special};
    }
}

