/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import forge.Graphics;
import forge.assets.FImage;
import forge.assets.ImageCache;
import forge.card.CardRenderer;
import forge.item.PaperCard;

public class CardAvatarImage
implements FImage {
    private final String imageKey;
    private FImage image;

    public CardAvatarImage(PaperCard card0) {
        this(card0.getImageKey(false));
    }

    public CardAvatarImage(String imageKey0) {
        this.imageKey = imageKey0;
    }

    @Override
    public float getWidth() {
        return this.getHeight();
    }

    @Override
    public float getHeight() {
        if (this.image != null) {
            return this.image.getHeight();
        }
        return (float)ImageCache.getDefaultImage().getHeight() * 0.43f;
    }

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        this.image = CardRenderer.getCardArt(this.imageKey, false, false, false, false, false, false, false, false, true, false);
        if (this.image == null) {
            return;
        }
        g2.startClip(x, y, w, h2);
        float aspectRatio = w / h2;
        float imageAspectRatio = this.image.getWidth() / this.image.getHeight();
        if (imageAspectRatio > aspectRatio) {
            float w0 = w * imageAspectRatio / aspectRatio;
            x -= (w0 - w) / 2.0f;
            w = w0;
        } else {
            float h0 = h2 * aspectRatio / imageAspectRatio;
            y -= (h0 - h2) / 2.0f;
            h2 = h0;
        }
        this.image.draw(g2, x, y, w, h2);
        g2.endClip();
    }
}

