/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntSet;
import forge.Forge;
import forge.assets.BitmapFontWriter;
import forge.assets.FSkin;
import forge.gui.FThreads;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import forge.util.LineReader;
import forge.util.TextBounds;
import forge.util.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;

public class FSkinFont {
    private static final int MIN_FONT_SIZE = 8;
    private static int MAX_FONT_SIZE = 72;
    private static final int MAX_FONT_SIZE_LESS_GLYPHS = 72;
    private static final int MAX_FONT_SIZE_MANY_GLYPHS = 36;
    private static final String TTF_FILE = "font1.ttf";
    private static HashMap<String, String> langUniqueCharacterSet = new HashMap();
    private final int fontSize;
    private final float scale;
    BitmapFont font;

    public static FSkinFont get(int unscaledSize) {
        return FSkinFont._get((int)Utils.scale(unscaledSize));
    }

    public static FSkinFont _get(int scaledSize) {
        FSkinFont skinFont = Forge.getAssets().fonts().get(scaledSize);
        if (skinFont == null) {
            skinFont = new FSkinFont(scaledSize);
            Forge.getAssets().fonts().put(scaledSize, skinFont);
        }
        return skinFont;
    }

    public static FSkinFont forHeight(float height) {
        int size = 9;
        FSkinFont f;
        while ((f = FSkinFont._get(size)) == null || !(f.getLineHeight() > height)) {
            ++size;
        }
        return FSkinFont._get(size - 1);
    }

    public static void preloadAll(String language) {
        MAX_FONT_SIZE = language.equals("zh-CN") || language.equals("ja-JP") ? 36 : 72;
        for (int size = 8; size <= MAX_FONT_SIZE; ++size) {
            FSkinFont._get(size);
        }
    }

    public static void deleteCachedFiles() {
        FileHandle dir = Gdx.files.absolute(ForgeConstants.FONTS_DIR);
        for (FileHandle fontFile : dir.list()) {
            String name = fontFile.name();
            if (!name.endsWith(".fnt") && !name.endsWith(".png")) continue;
            fontFile.delete();
        }
    }

    public static void updateAll() {
        for (FSkinFont skinFont : Forge.getAssets().fonts().values()) {
            skinFont.updateFont();
        }
    }

    private FSkinFont(int fontSize0) {
        this.scale = fontSize0 > MAX_FONT_SIZE ? (float)fontSize0 / (float)MAX_FONT_SIZE : (fontSize0 < 8 ? (float)fontSize0 / 8.0f : 1.0f);
        this.fontSize = fontSize0;
        this.updateFont();
    }

    static int indexOf(CharSequence text, char ch, int start) {
        int n = text.length();
        while (start < n) {
            if (text.charAt(start) == ch) {
                return start;
            }
            ++start;
        }
        return n;
    }

    public int computeVisibleGlyphs(CharSequence str, int start, int end, float availableWidth) {
        int index;
        if (this.font == null) {
            return 0;
        }
        BitmapFont.BitmapFontData data = this.font.getData();
        float width = 0.0f;
        BitmapFont.Glyph lastGlyph = null;
        availableWidth /= data.scaleX;
        for (index = start; index < end; ++index) {
            char ch = str.charAt(index);
            if (ch == '[' && data.markupEnabled && (++index >= end || str.charAt(index) != '[')) {
                while (index < end && str.charAt(index) != ']') {
                    ++index;
                }
                continue;
            }
            BitmapFont.Glyph g2 = data.getGlyph(ch);
            if (g2 == null) continue;
            if (lastGlyph != null) {
                width += (float)lastGlyph.getKerning(ch);
            }
            if (width + (float)g2.xadvance - availableWidth > 0.001f) break;
            width += (float)g2.xadvance;
            lastGlyph = g2;
        }
        return index - start;
    }

    public boolean isBreakChar(char c) {
        BitmapFont.BitmapFontData data = this.font.getData();
        if (data.breakChars == null) {
            return false;
        }
        for (char br : data.breakChars) {
            if (c != br) continue;
            return true;
        }
        return false;
    }

    static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public TextBounds getBounds(CharSequence str) {
        this.updateScale();
        return this.getBounds(str, 0, str.length());
    }

    public TextBounds getBounds(CharSequence str, int start, int end) {
        char ch;
        if (this.font == null) {
            return new TextBounds(0.0f, 0.0f);
        }
        BitmapFont.BitmapFontData data = this.font.getData();
        int width = 0;
        BitmapFont.Glyph lastGlyph = null;
        while (start < end) {
            if ((ch = str.charAt(start++)) == '[' && data.markupEnabled) {
                if (start >= end || str.charAt(start) != '[') {
                    while (start < end && str.charAt(start) != ']') {
                        ++start;
                    }
                    ++start;
                    continue;
                }
                ++start;
            }
            if ((lastGlyph = data.getGlyph(ch)) == null) continue;
            width = lastGlyph.xadvance;
            break;
        }
        while (start < end) {
            BitmapFont.Glyph g2;
            if ((ch = str.charAt(start++)) == '[' && data.markupEnabled) {
                if (start >= end || str.charAt(start) != '[') {
                    while (start < end && str.charAt(start) != ']') {
                        ++start;
                    }
                    ++start;
                    continue;
                }
                ++start;
            }
            if ((g2 = data.getGlyph(ch)) == null) continue;
            width += lastGlyph.getKerning(ch);
            lastGlyph = g2;
            width += g2.xadvance;
        }
        return new TextBounds((float)width * data.scaleX, data.capHeight);
    }

    public TextBounds getMultiLineBounds(CharSequence str) {
        this.updateScale();
        if (this.font == null) {
            return new TextBounds(0.0f, 0.0f);
        }
        BitmapFont.BitmapFontData data = this.font.getData();
        int start = 0;
        float maxWidth = 0.0f;
        int numLines = 0;
        int length = str.length();
        while (start < length) {
            int lineEnd = FSkinFont.indexOf(str, '\n', start);
            float lineWidth = this.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
            maxWidth = Math.max(maxWidth, lineWidth);
            start = lineEnd + 1;
            ++numLines;
        }
        return new TextBounds(maxWidth, data.capHeight + (float)(numLines - 1) * data.lineHeight);
    }

    public TextBounds getWrappedBounds(CharSequence str, float wrapWidth) {
        this.updateScale();
        if (this.font == null) {
            return new TextBounds(0.0f, 0.0f);
        }
        BitmapFont.BitmapFontData data = this.font.getData();
        if (wrapWidth <= 0.0f) {
            wrapWidth = 2.1474836E9f;
        }
        int start = 0;
        int numLines = 0;
        int length = str.length();
        float maxWidth = 0.0f;
        while (start < length) {
            int lineEnd;
            int newLine = FSkinFont.indexOf(str, '\n', start);
            int nextStart = lineEnd + 1;
            if (lineEnd < newLine) {
                for (lineEnd = start + this.computeVisibleGlyphs(str, start, newLine, wrapWidth); lineEnd > start && !FSkinFont.isWhitespace(str.charAt(lineEnd)) && !this.isBreakChar(str.charAt(lineEnd - 1)); --lineEnd) {
                }
                if (lineEnd == start) {
                    if (nextStart > start + 1) {
                        --nextStart;
                    }
                    lineEnd = nextStart;
                } else {
                    char c;
                    for (nextStart = lineEnd; nextStart < length && FSkinFont.isWhitespace(c = str.charAt(nextStart)); ++nextStart) {
                        if (c != '\n') continue;
                        break;
                    }
                    while (lineEnd > start && FSkinFont.isWhitespace(str.charAt(lineEnd - 1))) {
                        --lineEnd;
                    }
                }
            }
            if (lineEnd > start) {
                float lineWidth = this.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                maxWidth = Math.max(maxWidth, lineWidth);
            }
            start = nextStart;
            ++numLines;
        }
        return new TextBounds(maxWidth, data.capHeight + (float)(numLines - 1) * data.lineHeight);
    }

    public float getAscent() {
        if (this.font == null) {
            return 0.0f;
        }
        this.updateScale();
        return this.font.getAscent();
    }

    public float getCapHeight() {
        if (this.font == null) {
            return 0.0f;
        }
        this.updateScale();
        return this.font.getCapHeight();
    }

    public float getLineHeight() {
        if (this.font == null) {
            return 0.0f;
        }
        this.updateScale();
        return this.font.getLineHeight();
    }

    public void draw(SpriteBatch batch, String text, Color color, float x, float y, float w, boolean wrap, int horzAlignment) {
        this.updateScale();
        this.font.setColor(color);
        this.font.draw(batch, text, x, y, w, horzAlignment, wrap);
    }

    private void updateScale() {
        try {
            if (this.font.getScaleX() != this.scale) {
                this.font.getData().setScale(this.scale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canShrink() {
        return this.fontSize > 8;
    }

    public boolean canIncrease() {
        return MAX_FONT_SIZE - this.fontSize > 2;
    }

    public FSkinFont shrink() {
        return FSkinFont._get(this.fontSize - 1);
    }

    public FSkinFont increase() {
        return FSkinFont._get(this.fontSize + 3);
    }

    public String getCharacterSet(String langCode) {
        String[] translationFilePaths;
        int codePoint;
        if (langUniqueCharacterSet.containsKey(langCode)) {
            return langUniqueCharacterSet.get(langCode);
        }
        StringBuilder characters = new StringBuilder("\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff");
        characters.append("\u2022").append("\u2014");
        IntSet characterSet = new IntSet();
        for (int offset = 0; offset < "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".length(); offset += Character.charCount(codePoint)) {
            codePoint = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".codePointAt(offset);
            characterSet.add(codePoint);
        }
        for (String translationFilePath : translationFilePaths = new String[]{ForgeConstants.LANG_DIR + "cardnames-" + langCode + ".txt", ForgeConstants.LANG_DIR + langCode + ".properties"}) {
            try (LineReader translationFile = new LineReader(Files.newInputStream(Paths.get(translationFilePath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                for (String fileLine : translationFile.readLines()) {
                    int codePoint2;
                    int stringLength = fileLine.length();
                    for (int offset = 0; offset < stringLength; offset += Character.charCount(codePoint2)) {
                        codePoint2 = fileLine.codePointAt(offset);
                        if (characterSet.contains(codePoint2)) continue;
                        characterSet.add(codePoint2);
                        characters.append(Character.toChars(codePoint2));
                    }
                }
                translationFile.close();
            }
            catch (IOException e) {
                if ("en-US".equalsIgnoreCase(langCode)) continue;
                System.err.println("Error reading translation file: " + translationFilePath);
            }
        }
        langUniqueCharacterSet.put(langCode, characters.toString());
        return characters.toString();
    }

    private void updateFont() {
        String fontName = "f";
        fontName = this.scale != 1.0f ? (this.fontSize > MAX_FONT_SIZE ? fontName + MAX_FONT_SIZE : fontName + 8) : fontName + this.fontSize;
        if (Forge.locale.equals("zh-CN") || Forge.locale.equals("ja-JP") && !Forge.forcedEnglishonCJKMissing) {
            fontName = fontName + Forge.locale;
        }
        FileHandle fontFile = Gdx.files.absolute(ForgeConstants.FONTS_DIR + fontName + ".fnt");
        boolean[] found = new boolean[]{false};
        if (fontFile != null && fontFile.exists()) {
            FThreads.invokeInEdtNowOrLater(() -> {
                try {
                    this.font = Forge.getAssets().manager().get(fontFile.path(), BitmapFont.class, false);
                    if (this.font == null && fontFile.toString().endsWith(".fnt")) {
                        Forge.getAssets().manager().load(fontFile.path(), BitmapFont.class);
                        Forge.getAssets().manager().finishLoadingAsset(fontFile.path());
                        this.font = Forge.getAssets().manager().get(fontFile.path(), BitmapFont.class, false);
                    }
                    if (this.font != null) {
                        found[0] = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    found[0] = false;
                }
            });
        }
        if (found[0]) {
            return;
        }
        if (Forge.locale.equals("zh-CN") || Forge.locale.equals("ja-JP") && !Forge.forcedEnglishonCJKMissing) {
            String ttfName = Forge.CJK_Font;
            FileHandle ttfFile = Gdx.files.absolute(ForgeConstants.FONTS_DIR + ttfName + ".ttf");
            if (ttfFile != null && ttfFile.exists()) {
                this.generateFont(ttfFile, fontName, this.fontSize);
            }
        } else {
            this.generateFont(FSkin.getSkinFile(TTF_FILE), fontName, this.fontSize);
        }
    }

    private void generateFont(FileHandle ttfFile, final String fontName, final int fontSize) {
        if (!ttfFile.exists()) {
            return;
        }
        final FreeTypeFontGenerator generator = new FreeTypeFontGenerator(ttfFile);
        int pageSize = fontSize >= 50 ? 1024 : (fontSize >= 20 ? 512 : 256);
        if (Forge.locale.equals("zh-CN") || Forge.locale.equals("ja-JP") && !Forge.forcedEnglishonCJKMissing) {
            pageSize = 1024;
        }
        final PixmapPacker packer = new PixmapPacker(pageSize, pageSize, Pixmap.Format.RGBA8888, 2, false);
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.characters = this.getCharacterSet(Forge.locale);
        parameter.size = fontSize;
        parameter.packer = packer;
        final FreeTypeFontGenerator.FreeTypeBitmapFontData fontData = generator.generateData(parameter);
        final Array<PixmapPacker.Page> pages = packer.getPages();
        FThreads.invokeInEdtNowOrLater(new Runnable(){

            @Override
            public void run() {
                Array<TextureRegion> textureRegions = new Array<TextureRegion>();
                for (int i = 0; i < pages.size; ++i) {
                    PixmapPacker.Page p = (PixmapPacker.Page)pages.get(i);
                    Texture texture = new Texture(new PixmapTextureData(p.getPixmap(), p.getPixmap().getFormat(), false, false)){

                        @Override
                        public void dispose() {
                            super.dispose();
                            this.getTextureData().consumePixmap().dispose();
                        }
                    };
                    texture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
                    textureRegions.addAll((TextureRegion[])new TextureRegion[]{new TextureRegion(texture)});
                }
                BitmapFont temp = new BitmapFont((BitmapFont.BitmapFontData)fontData, textureRegions, true);
                FileHandle pixmapDir = Gdx.files.absolute(ForgeConstants.FONTS_DIR);
                if (pixmapDir != null) {
                    FileHandle fontFile = pixmapDir.child(fontName + ".fnt");
                    BitmapFontWriter.setOutputFormat(BitmapFontWriter.OutputFormat.Text);
                    String[] pageRefs = BitmapFontWriter.writePixmaps(packer.getPages(), pixmapDir, fontName);
                    BitmapFontWriter.writeFont(temp.getData(), pageRefs, fontFile, new BitmapFontWriter.FontInfo(fontName, fontSize), 1, 1);
                    Forge.getAssets().manager().load(fontFile.path(), BitmapFont.class);
                    Forge.getAssets().manager().finishLoadingAsset(fontFile.path());
                    FSkinFont.this.font = Forge.getAssets().manager().get(fontFile.path(), BitmapFont.class);
                }
                generator.dispose();
                packer.dispose();
                temp.dispose();
            }
        });
    }

    public static Iterable<String> getAllCJKFonts() {
        Array<String> allCJKFonts = new Array<String>();
        allCJKFonts.add("None");
        FileHandle dir = Gdx.files.absolute(ForgeConstants.FONTS_DIR);
        for (FileHandle fontFile : dir.list()) {
            String fontName = fontFile.name();
            if (!fontName.endsWith(".ttf")) continue;
            allCJKFonts.add(fontName.replace(".ttf", ""));
        }
        return allCJKFonts;
    }

    static {
        FileUtil.ensureDirectoryExists(ForgeConstants.FONTS_DIR);
    }
}

