/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.graphics.Color;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.TargetingOverlay;
import java.util.HashMap;

public class FSkinColor {
    private static final HashMap<Colors, FSkinColor> baseColors = new HashMap();
    private static final HashMap<String, FSkinColor> derivedColors = new HashMap();
    private static final int NO_BRIGHTNESS_DELTA = 0;
    private static final int NO_STEP = -999;
    private static final int NO_ALPHA = -1;
    private final Colors baseColor;
    private final int brightnessDelta;
    private final int step;
    private final int contrastStep;
    private final float alpha;
    protected Color color;

    public static FSkinColor get(Colors c0) {
        return baseColors.get((Object)c0);
    }

    public static FSkinColor getStandardColor(int r, int g2, int b) {
        return FSkinColor.getStandardColor(FSkinColor.fromRGB(r, g2, b));
    }

    public static FSkinColor getStandardColor(Color c0) {
        return new FSkinColor(c0, 0, -999, -999, -1.0f);
    }

    public Color getColor() {
        return this.color;
    }

    private FSkinColor(Colors baseColor0) {
        this(baseColor0, 0, -999, -999, -1.0f);
    }

    private FSkinColor(Colors baseColor0, int brightnessDelta0, int step0, int contrastStep0, float alpha0) {
        this.baseColor = baseColor0;
        this.brightnessDelta = brightnessDelta0;
        this.step = step0;
        this.contrastStep = contrastStep0;
        this.alpha = alpha0;
        this.updateColor();
    }

    private FSkinColor(Color color0, int brightnessDelta0, int step0, int contrastStep0, float alpha0) {
        this.color = color0;
        this.baseColor = null;
        this.brightnessDelta = brightnessDelta0;
        this.step = step0;
        this.contrastStep = contrastStep0;
        this.alpha = alpha0;
        this.updateColor();
    }

    private FSkinColor getDerivedColor(int brightnessDelta0, int step0, int contrastStep0, float alpha0) {
        if (this.baseColor == null) {
            return new FSkinColor(this.color, brightnessDelta0, step0, contrastStep0, alpha0);
        }
        String key = this.baseColor.name() + "|" + brightnessDelta0 + "|" + step0 + "|" + contrastStep0 + "|" + alpha0;
        FSkinColor derivedColor = derivedColors.get(key);
        if (derivedColor == null) {
            derivedColor = new FSkinColor(this.baseColor, brightnessDelta0, step0, contrastStep0, alpha0);
            derivedColors.put(key, derivedColor);
        }
        return derivedColor;
    }

    public FSkinColor brighter() {
        return this.getDerivedColor(this.brightnessDelta + 1, this.step, this.contrastStep, this.alpha);
    }

    public FSkinColor darker() {
        return this.getDerivedColor(this.brightnessDelta - 1, this.step, this.contrastStep, this.alpha);
    }

    public FSkinColor stepColor(int step0) {
        if (this.step != -999) {
            step0 += this.step;
        }
        return this.getDerivedColor(this.brightnessDelta, step0, this.contrastStep, this.alpha);
    }

    public FSkinColor getContrastColor(int contrastStep0) {
        if (this.contrastStep != -999) {
            contrastStep0 += this.contrastStep;
        }
        return this.getDerivedColor(this.brightnessDelta, this.step, contrastStep0, this.alpha);
    }

    public FSkinColor getHighContrastColor() {
        return this.getContrastColor(255);
    }

    public FSkinColor alphaColor(float alpha0) {
        return this.getDerivedColor(this.brightnessDelta, this.step, this.contrastStep, alpha0);
    }

    protected void updateColor() {
        if (this.baseColor != null) {
            this.color = this.baseColor.color;
        }
        if (this.brightnessDelta != 0) {
            if (this.brightnessDelta < 0) {
                for (int i = 0; i > this.brightnessDelta; --i) {
                    this.color = FSkinColor.stepColor(this.color, -20);
                }
            } else {
                for (int i = 0; i < this.brightnessDelta; ++i) {
                    this.color = FSkinColor.stepColor(this.color, 20);
                }
            }
        }
        if (this.step != -999) {
            this.color = FSkinColor.stepColor(this.color, this.step);
        }
        if (this.contrastStep != -999) {
            this.color = FSkinColor.stepColor(this.color, FSkinColor.isColorBright(this.color) ? -this.contrastStep : this.contrastStep);
        }
        if (this.alpha != -1.0f) {
            this.color = FSkinColor.alphaColor(this.color, this.alpha);
        }
    }

    public static Color stepColor(Color clr0, int step) {
        float r = clr0.r * 255.0f;
        float g2 = clr0.g * 255.0f;
        float b = clr0.b * 255.0f;
        if (step < 0) {
            r = r + (float)step > 0.0f ? r + (float)step : 0.0f;
            g2 = g2 + (float)step > 0.0f ? g2 + (float)step : 0.0f;
            b = b + (float)step > 0.0f ? b + (float)step : 0.0f;
        } else {
            r = r + (float)step < 255.0f ? r + (float)step : 255.0f;
            g2 = g2 + (float)step < 255.0f ? g2 + (float)step : 255.0f;
            b = b + (float)step < 255.0f ? b + (float)step : 255.0f;
        }
        return new Color(r / 255.0f, g2 / 255.0f, b / 255.0f, clr0.a);
    }

    public static Color alphaColor(Color clr0, float alpha) {
        return new Color(clr0.r, clr0.g, clr0.b, alpha);
    }

    public static boolean isColorBright(Color c) {
        double v = Math.sqrt((double)(c.r * c.r) * 0.241 + (double)(c.g * c.g) * 0.691 + (double)(c.b * c.b) * 0.068);
        return v > 0.5;
    }

    public static Color getHighContrastColor(Color c) {
        return FSkinColor.isColorBright(c) ? Color.BLACK : Color.WHITE;
    }

    public static Color tintColor(Color source, Color tint, float alpha) {
        float r = (tint.r - source.r) * alpha + source.r;
        float g2 = (tint.g - source.g) * alpha + source.g;
        float b = (tint.b - source.b) * alpha + source.b;
        return new Color(r, g2, b, 1.0f);
    }

    public static Color[] tintColors(Color source, Color[] tints, float alpha) {
        Color[] tintedColors = new Color[tints.length];
        for (int i = 0; i < tints.length; ++i) {
            tintedColors[i] = FSkinColor.tintColor(source, tints[i], alpha);
        }
        return tintedColors;
    }

    public static Color fromRGB(int r, int g2, int b) {
        return new Color((float)r / 255.0f, (float)g2 / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public static void updateAll() {
        if (baseColors.size() == 0) {
            for (Colors c : Colors.values()) {
                baseColors.put(c, new FSkinColor(c));
            }
        } else {
            for (FSkinColor c : baseColors.values()) {
                c.updateColor();
            }
            for (FSkinColor c : derivedColors.values()) {
                c.updateColor();
            }
        }
        TargetingOverlay.updateColors();
    }

    public float getAlpha() {
        return this.color.a;
    }

    public static enum Colors {
        CLR_THEME(FSkinProp.CLR_THEME),
        CLR_BORDERS(FSkinProp.CLR_BORDERS),
        CLR_ZEBRA(FSkinProp.CLR_ZEBRA),
        CLR_HOVER(FSkinProp.CLR_HOVER),
        CLR_ACTIVE(FSkinProp.CLR_ACTIVE),
        CLR_INACTIVE(FSkinProp.CLR_INACTIVE),
        CLR_TEXT(FSkinProp.CLR_TEXT),
        CLR_PHASE_INACTIVE_ENABLED(FSkinProp.CLR_PHASE_INACTIVE_ENABLED),
        CLR_PHASE_INACTIVE_DISABLED(FSkinProp.CLR_PHASE_INACTIVE_DISABLED),
        CLR_PHASE_ACTIVE_ENABLED(FSkinProp.CLR_PHASE_ACTIVE_ENABLED),
        CLR_PHASE_ACTIVE_DISABLED(FSkinProp.CLR_PHASE_ACTIVE_DISABLED),
        CLR_THEME2(FSkinProp.CLR_THEME2),
        CLR_OVERLAY(FSkinProp.CLR_OVERLAY),
        CLR_COMBAT_TARGETING_ARROW(FSkinProp.CLR_COMBAT_TARGETING_ARROW),
        CLR_NORMAL_TARGETING_ARROW(FSkinProp.CLR_NORMAL_TARGETING_ARROW),
        CLR_PWATTK_TARGETING_ARROW(FSkinProp.CLR_PWATTK_TARGETING_ARROW),
        ADV_CLR_THEME(FSkinProp.ADV_CLR_THEME),
        ADV_CLR_BORDERS(FSkinProp.ADV_CLR_BORDERS),
        ADV_CLR_ZEBRA(FSkinProp.ADV_CLR_ZEBRA),
        ADV_CLR_HOVER(FSkinProp.ADV_CLR_HOVER),
        ADV_CLR_ACTIVE(FSkinProp.ADV_CLR_ACTIVE),
        ADV_CLR_INACTIVE(FSkinProp.ADV_CLR_INACTIVE),
        ADV_CLR_TEXT(FSkinProp.ADV_CLR_TEXT),
        ADV_CLR_PHASE_INACTIVE_ENABLED(FSkinProp.ADV_CLR_PHASE_INACTIVE_ENABLED),
        ADV_CLR_PHASE_INACTIVE_DISABLED(FSkinProp.ADV_CLR_PHASE_INACTIVE_DISABLED),
        ADV_CLR_PHASE_ACTIVE_ENABLED(FSkinProp.ADV_CLR_PHASE_ACTIVE_ENABLED),
        ADV_CLR_PHASE_ACTIVE_DISABLED(FSkinProp.ADV_CLR_PHASE_ACTIVE_DISABLED),
        ADV_CLR_THEME2(FSkinProp.ADV_CLR_THEME2),
        ADV_CLR_OVERLAY(FSkinProp.ADV_CLR_OVERLAY),
        ADV_CLR_COMBAT_TARGETING_ARROW(FSkinProp.ADV_CLR_COMBAT_TARGETING_ARROW),
        ADV_CLR_NORMAL_TARGETING_ARROW(FSkinProp.ADV_CLR_NORMAL_TARGETING_ARROW),
        ADV_CLR_PWATTK_TARGETING_ARROW(FSkinProp.ADV_CLR_PWATTK_TARGETING_ARROW);

        private Color color;
        private final int x;
        private final int y;
        private final FSkinProp skinProp;

        private Colors(FSkinProp skinProp0) {
            this.skinProp = skinProp0;
            int[] coords = this.skinProp.getCoords();
            this.x = coords[0];
            this.y = coords[1];
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setColor(Color color0) {
            this.color = color0;
        }

        public static Colors fromSkinProp(FSkinProp skinProp) {
            for (Colors c : Colors.values()) {
                if (c.skinProp != skinProp) continue;
                return c;
            }
            return null;
        }
    }
}

