/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import java.util.ArrayList;

public class FLanguage {
    public static void changeLanguage(String languageName) {
        ForgePreferences prefs = FModel.getPreferences();
        if (languageName.equals(prefs.getPref(ForgePreferences.FPref.UI_LANGUAGE))) {
            return;
        }
        prefs.setPref(ForgePreferences.FPref.UI_LANGUAGE, languageName);
        prefs.save();
    }

    public static Iterable<String> getAllLanguages() {
        ArrayList<String> allLanguages = new ArrayList<String>();
        FileHandle dir = Gdx.files.absolute(ForgeConstants.LANG_DIR);
        for (FileHandle languageFile : dir.list()) {
            String languageName = languageFile.name();
            if (!languageName.endsWith(".properties")) continue;
            allLanguages.add(languageName.replace(".properties", ""));
        }
        return allLanguages;
    }
}

