/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.assets.FSkin;
import forge.assets.FSkinFont;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadZipService;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgeConstants;
import forge.screens.SplashScreen;
import forge.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class AssetsDownloader {
    public static final boolean SHARE_DESKTOP_ASSETS = true;
    private static final ImmutableList<String> downloadIgnoreExit = ImmutableList.of("Download", "Ignore", "Exit");
    private static final ImmutableList<String> downloadExit = ImmutableList.of("Download", "Exit");

    public static void checkForUpdates(SplashScreen splashScreen) {
        ImmutableList<String> options;
        boolean canIgnoreDownload;
        File versionFile;
        String message;
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            return;
        }
        boolean isSnapshots = "1.6.65-SNAPSHOT".contains("SNAPSHOT");
        String snapsURL = "https://downloads.cardforge.org/dailysnapshots/";
        String releaseURL = "https://releases.cardforge.org/forge/forge-gui-android/";
        String versionText = isSnapshots ? "https://downloads.cardforge.org/dailysnapshots/version.txt" : "https://releases.cardforge.org/forge/forge-gui-android/version.txt";
        splashScreen.getProgressBar().setDescription("Checking for updates...");
        boolean connectedToInternet = Forge.getDeviceAdapter().isConnectedToInternet();
        if (connectedToInternet) {
            try {
                String apkURL;
                URL versionUrl = new URL(versionText);
                String version = FileUtil.readFileToString(versionUrl);
                String filename = "forge-android-" + version + "-signed-aligned.apk";
                String string = apkURL = isSnapshots ? "https://downloads.cardforge.org/dailysnapshots/" + filename : "https://releases.cardforge.org/forge/forge-gui-android/" + version + "/" + filename;
                if (!StringUtils.isEmpty(version) && !"1.6.65-SNAPSHOT".equals(version)) {
                    splashScreen.prepareForDialogs();
                    message = "A new version of Forge is available (" + version + ").\nYou are currently on an older version (" + "1.6.65-SNAPSHOT" + ").\n\nWould you like to update to the new version now?";
                    if (!Forge.getDeviceAdapter().isConnectedToWifi()) {
                        message = message + " If so, you may want to connect to wifi first. The download is around 12MB.";
                    }
                    if (SOptionPane.showConfirmDialog(message, "New Version Available", "Update Now", "Update Later", true, true)) {
                        String apkFile = new GuiDownloadZipService("", "update", apkURL, Forge.getDeviceAdapter().getDownloadsDir(), null, splashScreen.getProgressBar()).download(filename);
                        if (apkFile != null) {
                            Forge.getDeviceAdapter().openFile(apkFile);
                            Forge.isMobileAdventureMode = Forge.advStartup;
                            Forge.exitAnimation(false);
                            return;
                        }
                        SOptionPane.showOptionDialog("Could not download update. Press OK to proceed without update.", "Update Failed", null, ImmutableList.of("Ok"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(versionFile = new File(ForgeConstants.ASSETS_DIR + "version.txt")).exists()) {
            try {
                versionFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                Forge.exitAnimation(false);
                return;
            }
        } else if ("1.6.65-SNAPSHOT".equals(FileUtil.readFileToString(versionFile)) && FSkin.getSkinDir() != null) {
            return;
        }
        splashScreen.prepareForDialogs();
        boolean bl = canIgnoreDownload = FSkin.getAllSkins() != null;
        if (!connectedToInternet) {
            message = "Updated resource files cannot be downloaded due to lack of internet connection.\n\n";
            message = canIgnoreDownload ? message + "You can continue without this download, but you may miss out on card fixes or experience other problems." : message + "You cannot start the app since you haven't previously downloaded these files.";
            switch (SOptionPane.showOptionDialog(message, "No Internet Connection", null, ImmutableList.of("Ok"))) {
                default: 
            }
            if (!canIgnoreDownload) {
                Forge.exitAnimation(false);
            }
            return;
        }
        message = "There are updated resource files to download. This download is around 50MB, ";
        message = Forge.getDeviceAdapter().isConnectedToWifi() ? message + "which shouldn't take long if your wifi connection is good." : message + "so it's highly recommended that you connect to wifi first.";
        message = message + "\n\n";
        if (canIgnoreDownload) {
            message = message + "If you choose to ignore this download, you may miss out on card fixes or experience other problems.";
            options = downloadIgnoreExit;
        } else {
            message = message + "This download is mandatory to start the app since you haven't previously downloaded these files.";
            options = downloadExit;
        }
        switch (SOptionPane.showOptionDialog(message, "", null, options)) {
            case 1: {
                if (!canIgnoreDownload) {
                    Forge.exitAnimation(false);
                }
                return;
            }
            case 2: {
                Forge.exitAnimation(false);
                return;
            }
        }
        boolean allowDeletion = Forge.androidVersion < 30 || GuiBase.isUsingAppDirectory();
        String assetURL = isSnapshots ? "https://downloads.cardforge.org/dailysnapshots/assets.zip" : "https://releases.cardforge.org/forge/forge-gui-android/1.6.65-SNAPSHOT/assets.zip";
        new GuiDownloadZipService("", "resource files", assetURL, ForgeConstants.ASSETS_DIR, ForgeConstants.RES_DIR, splashScreen.getProgressBar(), allowDeletion).downloadAndUnzip();
        if (allowDeletion) {
            FSkinFont.deleteCachedFiles();
        }
        FThreads.invokeInEdtAndWait(() -> {
            FSkinFont.updateAll();
            FSkin.loadLight(FSkin.getName(), splashScreen);
        });
        FileUtil.writeFile(versionFile, "1.6.65-SNAPSHOT");
        String msg = allowDeletion ? "Resource update finished..." : "Forge misses some files for deletion.\nIf you encounter issues, try deleting the Forge/res folder and/or deleting Forge/cache/fonts folder and try to download and update the assets.";
        switch (SOptionPane.showOptionDialog(msg, "", null, ImmutableList.of("Restart"))) {
            default: 
        }
        Forge.exitAnimation(true);
    }
}

