/*
 * Decompiled with CFR 0.152.
 */
package forge.animation;

import com.badlogic.gdx.math.Rectangle;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FOverlay;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ForgeTransition
extends ForgeAnimation {
    private static final FOverlay overlay = new FOverlay(null){

        @Override
        protected void doLayout(float width, float height) {
        }
    };
    private static final Map<FDisplayObject, TransitionObject> transitionLookup = new LinkedHashMap<FDisplayObject, TransitionObject>();
    private final TransitionObject obj;
    private final Runnable onFinished;

    public static void queue(FDisplayObject obj, Rectangle destBounds, float duration, Runnable onFinished) {
        ForgeTransition.queue(obj, destBounds, duration, 0.0f, false, onFinished);
    }

    public static void queue(FDisplayObject obj, Rectangle destBounds, float duration, float arcAmount, boolean arcOriginBelow, Runnable onFinished) {
        TransitionObject transitionObj = transitionLookup.get(obj);
        if (transitionObj == null) {
            transitionObj = new TransitionObject(obj);
            transitionLookup.put(obj, transitionObj);
            overlay.add(transitionObj);
            obj.setVisible(false);
        }
        ForgeTransition transition = new ForgeTransition(transitionObj, destBounds, duration, arcAmount, arcOriginBelow, onFinished);
        transitionObj.transitions.add(transition);
        if (transitionObj.transitions.size() == 1) {
            transition.start();
            overlay.setVisible(true);
        }
    }

    private ForgeTransition(TransitionObject obj0, Rectangle destBounds0, float duration0, float arcAmount0, boolean arcOriginBelow0, Runnable onFinished0) {
        this.obj = obj0;
        this.onFinished = onFinished0;
    }

    @Override
    protected boolean advance(float dt) {
        return false;
    }

    @Override
    protected void onEnd(boolean endingAll) {
        if (this.onFinished != null) {
            this.onFinished.run();
        }
        if (endingAll) {
            transitionLookup.clear();
            return;
        }
        int index = this.obj.transitions.indexOf(this);
        this.obj.transitions.remove(index);
        if (index == 0) {
            if (this.obj.transitions.isEmpty()) {
                transitionLookup.remove(this.obj.originalObj);
                overlay.remove(this.obj);
                this.obj.originalObj.setVisible(true);
                if (transitionLookup.isEmpty()) {
                    overlay.setVisible(false);
                }
            } else {
                ((ForgeTransition)this.obj.transitions.getFirst()).start();
            }
        }
    }

    private static class TransitionObject
    extends FDisplayObject {
        private final FDisplayObject originalObj;
        private final LinkedList<ForgeTransition> transitions = new LinkedList();

        private TransitionObject(FDisplayObject originalObj0) {
            this.originalObj = originalObj0;
            this.setBounds(this.originalObj.screenPos.x, this.originalObj.screenPos.y, this.originalObj.getWidth(), this.originalObj.getHeight());
        }

        @Override
        public void draw(Graphics g2) {
            this.originalObj.draw(g2);
        }
    }
}

