/*
 * Decompiled with CFR 0.152.
 */
package forge.animation;

import com.badlogic.gdx.Gdx;
import forge.Forge;
import java.util.ArrayList;
import java.util.List;

public abstract class ForgeAnimation {
    private static final List<ForgeAnimation> activeAnimations = new ArrayList<ForgeAnimation>();
    private static boolean changingActiveAnimations = false;

    public void start() {
        if (activeAnimations.contains(this)) {
            return;
        }
        activeAnimations.add(this);
        if (activeAnimations.size() == 1 && !changingActiveAnimations) {
            Forge.startContinuousRendering();
        }
    }

    public void stop() {
        if (!activeAnimations.contains(this)) {
            return;
        }
        activeAnimations.remove(this);
        this.onEnd(false);
        if (activeAnimations.isEmpty()) {
            Forge.stopContinuousRendering();
        }
    }

    public static void advanceAll() {
        if (activeAnimations.isEmpty()) {
            return;
        }
        float dt = Gdx.graphics.getDeltaTime();
        for (int i = 0; i < activeAnimations.size(); ++i) {
            if (activeAnimations.get(i).advance(dt)) continue;
            changingActiveAnimations = true;
            activeAnimations.remove(i).onEnd(false);
            changingActiveAnimations = false;
            --i;
        }
        if (activeAnimations.isEmpty()) {
            Forge.stopContinuousRendering();
        }
    }

    public static void endAll() {
        if (activeAnimations.isEmpty()) {
            return;
        }
        for (ForgeAnimation animation : activeAnimations) {
            animation.onEnd(true);
        }
        activeAnimations.clear();
        Forge.stopContinuousRendering();
    }

    protected abstract boolean advance(float var1);

    protected abstract void onEnd(boolean var1);
}

