/*
 * Decompiled with CFR 0.152.
 */
package forge.animation;

import forge.Graphics;
import forge.animation.GifAnimation;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.sound.AudioClip;

public enum AbilityEffect {
    LIGHTNING("lightning.gif", "lightning.wav");

    private final String gif;
    private final String wav;
    private GifAnimation animation;
    private AudioClip soundClip;

    private AbilityEffect(String gif0, String wav0) {
        this.gif = gif0;
        this.wav = wav0;
    }

    public void start() {
        if (this.animation == null) {
            this.animation = new GifAnimation(ForgeConstants.EFFECTS_DIR + this.gif);
        }
        if (this.soundClip == null) {
            this.soundClip = AudioClip.createClip(ForgeConstants.EFFECTS_DIR + this.wav);
        }
        if (this.soundClip != null) {
            this.soundClip.play((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_SOUNDS) / 100.0f);
        }
        this.animation.start();
    }

    public void draw(Graphics g2, float x, float y, float w, float h2) {
        if (this.animation != null) {
            this.animation.draw(g2, x, y, w, h2);
        }
    }
}

