/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import forge.ai.simulation.GameCopier;
import forge.ai.simulation.GameSimulator;
import forge.ai.simulation.GameStateEvaluator;
import forge.ai.simulation.MultiTargetSelector;
import forge.ai.simulation.Plan;
import forge.ai.simulation.SpellAbilityPicker;
import forge.game.GameObject;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimulationController {
    private static boolean DEBUG = false;
    private static int MAX_DEPTH = 3;
    private List<Plan.Decision> currentStack;
    private List<GameStateEvaluator.Score> scoreStack;
    private List<GameSimulator> simulatorStack;
    private Plan.Decision bestSequence;
    private GameStateEvaluator.Score bestScore;
    private List<CachedEffect> effectCache = new ArrayList<CachedEffect>();
    private GameObject[] currentHostAndTarget;

    public SimulationController(GameStateEvaluator.Score score) {
        this.bestScore = score;
        this.scoreStack = new ArrayList<GameStateEvaluator.Score>();
        this.scoreStack.add(score);
        this.simulatorStack = new ArrayList<GameSimulator>();
        this.currentStack = new ArrayList<Plan.Decision>();
    }

    private int getRecursionDepth() {
        return this.scoreStack.size() - 1;
    }

    public boolean shouldRecurse() {
        return this.bestScore.value != Integer.MAX_VALUE && this.getRecursionDepth() < MAX_DEPTH;
    }

    public Plan.Decision getLastDecision() {
        if (this.currentStack.isEmpty()) {
            return null;
        }
        return this.currentStack.get(this.currentStack.size() - 1);
    }

    private GameStateEvaluator.Score getCurrentScore() {
        return this.scoreStack.get(this.scoreStack.size() - 1);
    }

    public void evaluateSpellAbility(List<SpellAbility> saList, int saIndex) {
        this.currentStack.add(new Plan.Decision(this.getCurrentScore(), this.getLastDecision(), new Plan.SpellAbilityRef(saList, saIndex)));
    }

    public void evaluateCardChoice(Card choice) {
        this.currentStack.add(new Plan.Decision(this.getCurrentScore(), this.getLastDecision(), choice));
    }

    public void evaluateChosenModes(int[] chosenModes, String modesStr) {
        this.currentStack.add(new Plan.Decision(this.getCurrentScore(), this.getLastDecision(), chosenModes, modesStr));
    }

    public void evaluateTargetChoices(SpellAbility sa, MultiTargetSelector.Targets targets) {
        this.currentStack.add(new Plan.Decision(this.getCurrentScore(), this.getLastDecision(), targets));
    }

    public void doneEvaluating(GameStateEvaluator.Score score) {
        if (this.getLastDecision().initialScore.value < score.value && score.value > this.bestScore.value) {
            this.bestScore = score;
            this.bestSequence = this.getLastDecision();
        }
        this.currentStack.remove(this.currentStack.size() - 1);
    }

    public GameStateEvaluator.Score getBestScore() {
        return this.bestScore;
    }

    public Plan getBestPlan() {
        if (!this.currentStack.isEmpty()) {
            throw new RuntimeException("getBestPlan() expects currentStack to be empty!");
        }
        ArrayList<Plan.Decision> sequence = new ArrayList<Plan.Decision>();
        Plan.Decision current = this.bestSequence;
        while (current != null) {
            sequence.add(current);
            current = current.prevDecision;
        }
        Collections.reverse(sequence);
        int writeIndex = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            Plan.Decision d = (Plan.Decision)sequence.get(i);
            if (d.saRef != null) {
                sequence.set(writeIndex, d);
                ++writeIndex;
                continue;
            }
            if (d.targets != null) {
                sequence.get((int)(writeIndex - 1)).targets = d.targets;
                continue;
            }
            if (d.choices != null) {
                Plan.Decision to = sequence.get(writeIndex - 1);
                if (to.choices == null) {
                    to.choices = new ArrayList<String>();
                }
                to.choices.addAll(d.choices);
                continue;
            }
            if (d.modes == null) continue;
            sequence.get((int)(writeIndex - 1)).modes = d.modes;
            sequence.get((int)(writeIndex - 1)).modesStr = d.modesStr;
        }
        sequence.subList(writeIndex, sequence.size()).clear();
        return new Plan(sequence, this.getBestScore());
    }

    private Plan.Decision getLastMergedDecision() {
        MultiTargetSelector.Targets targets = null;
        ArrayList<String> choices = new ArrayList<String>();
        int[] modes = null;
        String modesStr = null;
        Plan.Decision d = this.currentStack.get(this.currentStack.size() - 1);
        while (d.saRef == null) {
            if (d.targets != null) {
                targets = d.targets;
            } else if (d.choices != null) {
                choices.addAll(0, d.choices);
            } else if (d.modes != null) {
                modes = d.modes;
                modesStr = d.modesStr;
            }
            d = d.prevDecision;
        }
        Plan.Decision merged = new Plan.Decision(d.initialScore, d.prevDecision, d.saRef);
        merged.targets = targets;
        if (!choices.isEmpty()) {
            merged.choices = choices;
        }
        merged.modes = modes;
        merged.modesStr = modesStr;
        merged.xMana = d.xMana;
        return merged;
    }

    public void push(SpellAbility sa, GameStateEvaluator.Score score, GameSimulator simulator) {
        GameSimulator.debugPrint("Recursing DEPTH=" + this.getRecursionDepth());
        GameSimulator.debugPrint("  With: " + sa);
        this.scoreStack.add(score);
        this.simulatorStack.add(simulator);
    }

    public void pop(GameStateEvaluator.Score score, SpellAbility nextSa) {
        this.scoreStack.remove(this.scoreStack.size() - 1);
        this.simulatorStack.remove(this.simulatorStack.size() - 1);
        GameSimulator.debugPrint("DEPTH" + this.getRecursionDepth() + " best score " + score + " " + nextSa);
    }

    public GameObject[] getOriginalHostCardAndTarget(SpellAbility sa) {
        GameObject target;
        SpellAbility saOrSubSa;
        for (saOrSubSa = sa; saOrSubSa != null && !saOrSubSa.usesTargeting(); saOrSubSa = saOrSubSa.getSubAbility()) {
        }
        if (saOrSubSa == null || saOrSubSa.getTargets() == null || saOrSubSa.getTargets().size() != 1) {
            return null;
        }
        GameObject originalTarget = target = (GameObject)saOrSubSa.getTargets().get(0);
        if (!(target instanceof Card)) {
            return null;
        }
        Card hostCard = sa.getHostCard();
        for (int i = this.simulatorStack.size() - 1; i >= 0; --i) {
            if (target == null || hostCard == null) {
                return null;
            }
            GameCopier copier = this.simulatorStack.get(i).getGameCopier();
            if (copier.getCopiedGame() != hostCard.getGame()) {
                throw new RuntimeException("Expected hostCard and copier game to match!");
            }
            if (copier.getCopiedGame() != ((Card)target).getGame()) {
                throw new RuntimeException("Expected target and copier game to match!");
            }
            target = copier.reverseFind(target);
            hostCard = (Card)copier.reverseFind(hostCard);
        }
        return new GameObject[]{hostCard, target, originalTarget};
    }

    public void setHostAndTarget(SpellAbility sa, GameSimulator simulator) {
        this.simulatorStack.add(simulator);
        this.currentHostAndTarget = this.getOriginalHostCardAndTarget(sa);
        this.simulatorStack.remove(this.simulatorStack.size() - 1);
    }

    public GameStateEvaluator.Score shouldSkipTarget(SpellAbility sa, GameSimulator simulator) {
        this.simulatorStack.add(simulator);
        GameObject[] hostAndTarget = this.getOriginalHostCardAndTarget(sa);
        this.simulatorStack.remove(this.simulatorStack.size() - 1);
        if (hostAndTarget != null) {
            String saString = sa.toString();
            for (CachedEffect effect : this.effectCache) {
                Player player;
                GameStateEvaluator evaluator;
                int cardScore;
                if (effect.hostCard != hostAndTarget[0] || effect.target != hostAndTarget[1] || !effect.sa.equals(saString) || (cardScore = (evaluator = new GameStateEvaluator()).evalCard((player = sa.getActivatingPlayer()).getGame(), player, (Card)hostAndTarget[2])) != effect.targetScore) continue;
                GameStateEvaluator.Score currentScore = this.getCurrentScore();
                return new GameStateEvaluator.Score(currentScore.value + effect.scoreDelta, currentScore.summonSickValue);
            }
        }
        return null;
    }

    public void possiblyCacheResult(GameStateEvaluator.Score score, SpellAbility sa) {
        String cached = "";
        if (!this.currentStack.isEmpty()) {
            Plan.Decision d = this.currentStack.get(this.currentStack.size() - 1);
            int scoreDelta = score.value - d.initialScore.value;
            if (scoreDelta <= 0 && d.targets != null) {
                GameObject[] hostAndTarget = this.currentHostAndTarget;
                if (this.currentHostAndTarget != null) {
                    GameStateEvaluator evaluator = new GameStateEvaluator();
                    Player player = sa.getActivatingPlayer();
                    int cardScore = evaluator.evalCard(player.getGame(), player, (Card)hostAndTarget[2]);
                    this.effectCache.add(new CachedEffect(hostAndTarget[0], sa, hostAndTarget[1], cardScore, scoreDelta));
                    cached = " (added to cache)";
                }
            }
        }
        this.currentHostAndTarget = null;
        this.printState(score, sa, cached, true);
    }

    public void printState(GameStateEvaluator.Score score, SpellAbility origSa, String suffix, boolean useStack) {
        if (!DEBUG) {
            return;
        }
        int recursionDepth = this.getRecursionDepth();
        for (int i = 0; i < recursionDepth; ++i) {
            System.err.print("  ");
        }
        String str = useStack && !this.currentStack.isEmpty() ? this.getLastMergedDecision().toString(true) : SpellAbilityPicker.abilityToString(origSa);
        System.err.println(recursionDepth + ": [" + score.value + "] " + str + suffix);
    }

    private static class CachedEffect {
        final GameObject hostCard;
        final String sa;
        final GameObject target;
        final int targetScore;
        final int scoreDelta;

        public CachedEffect(GameObject hostCard, SpellAbility sa, GameObject target, int targetScore, int scoreDelta) {
            this.hostCard = hostCard;
            this.sa = sa.toString();
            this.target = target;
            this.targetScore = targetScore;
            this.scoreDelta = scoreDelta;
        }
    }
}

