/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import com.google.common.base.Joiner;
import forge.ai.simulation.GameStateEvaluator;
import forge.ai.simulation.MultiTargetSelector;
import forge.ai.simulation.SpellAbilityPicker;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.List;

public class Plan {
    private final List<Decision> decisions;
    private final GameStateEvaluator.Score finalScore;
    private int nextDecisionIndex;
    private int nextChoice;
    private Decision selectedDecision;
    private PhaseType startPhase;

    public Plan(ArrayList<Decision> decisions, GameStateEvaluator.Score finalScore) {
        this.decisions = decisions;
        this.finalScore = finalScore;
    }

    public GameStateEvaluator.Score getFinalScore() {
        return this.finalScore;
    }

    public PhaseType getStartPhase() {
        return this.startPhase;
    }

    public List<Decision> getDecisions() {
        return this.decisions;
    }

    public boolean hasNextDecision() {
        return this.nextDecisionIndex < this.decisions.size();
    }

    public Decision selectNextDecision() {
        this.selectedDecision = this.decisions.get(this.nextDecisionIndex);
        ++this.nextDecisionIndex;
        this.nextChoice = 0;
        return this.selectedDecision;
    }

    public Decision getSelectedDecision() {
        return this.selectedDecision;
    }

    public String getSelectedDecisionNextChoice() {
        if (this.selectedDecision.choices != null && this.nextChoice < this.selectedDecision.choices.size()) {
            return this.selectedDecision.choices.get(this.nextChoice);
        }
        return null;
    }

    public void advanceNextChoice() {
        ++this.nextChoice;
    }

    public int getNextDecisionIndex() {
        return this.nextDecisionIndex;
    }

    public static class Decision {
        final Decision prevDecision;
        final GameStateEvaluator.Score initialScore;
        final SpellAbilityRef saRef;
        Integer xMana;
        MultiTargetSelector.Targets targets;
        List<String> choices;
        int[] modes;
        String modesStr;

        public Decision(GameStateEvaluator.Score initialScore, Decision prevDecision, SpellAbilityRef saRef) {
            this.initialScore = initialScore;
            this.prevDecision = prevDecision;
            this.saRef = saRef;
        }

        public Decision(GameStateEvaluator.Score initialScore, Decision prevDecision, MultiTargetSelector.Targets targets) {
            this.initialScore = initialScore;
            this.prevDecision = prevDecision;
            this.saRef = null;
            this.targets = targets;
        }

        public Decision(GameStateEvaluator.Score initialScore, Decision prevDecision, Card choice) {
            this.initialScore = initialScore;
            this.prevDecision = prevDecision;
            this.saRef = null;
            this.choices = new ArrayList<String>();
            this.choices.add(choice.getName());
        }

        public Decision(GameStateEvaluator.Score initialScore, Decision prevDecision, int[] modes, String modesStr) {
            this.initialScore = initialScore;
            this.prevDecision = prevDecision;
            this.saRef = null;
            this.modes = modes;
            this.modesStr = modesStr;
        }

        public String toString(boolean showHostCard) {
            StringBuilder sb = new StringBuilder();
            if (!showHostCard) {
                sb.append("[initScore=").append(this.initialScore).append(" ");
            }
            if (this.modesStr != null) {
                sb.append(this.modesStr);
            } else {
                String sa = this.saRef.toString(showHostCard);
                if (this.xMana != null) {
                    sa = sa.replace("(X=0)", "(X=" + this.xMana + ")");
                }
                sb.append(sa);
            }
            if (this.targets != null) {
                sb.append(" (targets: ").append(this.targets).append(")");
            }
            if (this.choices != null) {
                sb.append(" (chosen: ").append(Joiner.on(", ").join(this.choices)).append(")");
            }
            if (!showHostCard) {
                sb.append("]");
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString(false);
        }
    }

    public static class SpellAbilityRef {
        private final int saIndex;
        private final int saCount;
        private final String saStr;
        private final String saHumanStr;

        public SpellAbilityRef(List<SpellAbility> saList, int saIndex) {
            this.saIndex = saIndex;
            this.saCount = saList.size();
            SpellAbility sa = saList.get(saIndex);
            this.saStr = sa.toString();
            this.saHumanStr = SpellAbilityPicker.abilityToString(sa, false);
        }

        public SpellAbility findReferencedAbility(List<SpellAbility> availableSAs) {
            if (availableSAs.size() != this.saCount) {
                return null;
            }
            SpellAbility sa = availableSAs.get(this.saIndex);
            return sa.toString().equals(this.saStr) ? sa : null;
        }

        public String toString(boolean showHostCard) {
            return showHostCard ? this.saHumanStr : this.saStr;
        }

        public String toString() {
            return this.toString(false);
        }
    }
}

