/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import forge.ai.AIDeckStatistics;
import forge.ai.CreatureEvaluator;
import forge.ai.simulation.GameCopier;
import forge.ai.simulation.GameSimulator;
import forge.card.mana.ManaAtom;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.cost.CostSacrifice;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import java.util.Arrays;
import java.util.HashSet;

public class GameStateEvaluator {
    private boolean debugging = false;
    private SimulationCreatureEvaluator eval = new SimulationCreatureEvaluator();

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    private static void debugPrint(String s2) {
        GameSimulator.debugPrint(s2);
    }

    private CombatSimResult simulateUpcomingCombatThisTurn(Game evalGame, Player aiPlayer) {
        PhaseType phase = evalGame.getPhaseHandler().getPhase();
        if (phase.isAfter(PhaseType.COMBAT_DAMAGE) || evalGame.isGameOver()) {
            return null;
        }
        if (evalGame.getPhaseHandler().getPlayerTurn().getCreaturesInPlay().isEmpty()) {
            return null;
        }
        GameCopier copier = new GameCopier(evalGame);
        Game gameCopy = evalGame.EXPERIMENTAL_RESTORE_SNAPSHOT ? copier.makeCopy() : copier.makeCopy(null, aiPlayer);
        gameCopy.getPhaseHandler().devAdvanceToPhase(PhaseType.COMBAT_DAMAGE, () -> GameSimulator.resolveStack(gameCopy, aiPlayer.getWeakestOpponent()));
        CombatSimResult result = new CombatSimResult();
        result.copier = copier;
        result.gameCopy = gameCopy;
        return result;
    }

    private static String cardToString(Card c) {
        String str = c.getName();
        if (c.isCreature()) {
            str = str + " " + c.getNetPower() + "/" + c.getNetToughness();
        }
        return str;
    }

    private Score getScoreForGameOver(Game game, Player aiPlayer) {
        if (game.getOutcome().getWinningTeam() == aiPlayer.getTeam() || game.getOutcome().isWinner(aiPlayer.getRegisteredPlayer())) {
            return new Score(Integer.MAX_VALUE);
        }
        return new Score(Integer.MIN_VALUE);
    }

    public Score getScoreForGameState(Game game, Player aiPlayer) {
        if (game.isGameOver()) {
            return this.getScoreForGameOver(game, aiPlayer);
        }
        CombatSimResult result = this.simulateUpcomingCombatThisTurn(game, aiPlayer);
        if (result != null) {
            Player aiPlayerCopy = (Player)result.copier.find(aiPlayer);
            if (result.gameCopy.isGameOver()) {
                return this.getScoreForGameOver(result.gameCopy, aiPlayerCopy);
            }
            return this.getScoreForGameStateImpl(result.gameCopy, aiPlayerCopy);
        }
        return this.getScoreForGameStateImpl(game, aiPlayer);
    }

    private Score getScoreForGameStateImpl(Game game, Player aiPlayer) {
        int score = 0;
        int myCards = 0;
        int theirCards = 0;
        for (Card c : game.getCardsIn(ZoneType.Hand)) {
            if (c.getController() == aiPlayer) {
                ++myCards;
                continue;
            }
            ++theirCards;
        }
        GameStateEvaluator.debugPrint("My cards in hand: " + myCards);
        GameStateEvaluator.debugPrint("Their cards in hand: " + theirCards);
        if (!aiPlayer.isUnlimitedHandSize() && myCards > aiPlayer.getMaxHandSize()) {
            score += myCards - aiPlayer.getMaxHandSize();
            myCards = aiPlayer.getMaxHandSize();
        }
        score += 5 * myCards - 4 * theirCards;
        GameStateEvaluator.debugPrint("  My life: " + aiPlayer.getLife());
        score += 2 * aiPlayer.getLife();
        int opponentIndex = 1;
        int opponentLife = 0;
        for (Player opponent : aiPlayer.getOpponents()) {
            GameStateEvaluator.debugPrint("  Opponent " + opponentIndex + " life: -" + opponent.getLife());
            opponentLife += opponent.getLife();
            ++opponentIndex;
        }
        score -= 2 * opponentLife / (game.getPlayers().size() - 1);
        int summonSickScore = score += this.evalManaBase(game, aiPlayer, AIDeckStatistics.fromPlayer(aiPlayer));
        PhaseType gamePhase = game.getPhaseHandler().getPhase();
        for (Card c : game.getCardsIn(ZoneType.Battlefield)) {
            String nonAbilityText;
            int value;
            int summonSickValue = value = this.evalCard(game, aiPlayer, c);
            if (gamePhase.isBefore(PhaseType.MAIN2) && c.isSick() && c.getController() == aiPlayer) {
                summonSickValue = 0;
            }
            String str = GameStateEvaluator.cardToString(c);
            if (c.getController() == aiPlayer) {
                GameStateEvaluator.debugPrint("  Battlefield: " + str + " = " + value);
                score += value;
                summonSickScore += summonSickValue;
            } else {
                GameStateEvaluator.debugPrint("  Battlefield: " + str + " = -" + value);
                score -= value;
                summonSickScore -= summonSickValue;
            }
            if ((nonAbilityText = c.getNonAbilityText()).isEmpty()) continue;
            GameStateEvaluator.debugPrint("    " + nonAbilityText.replaceAll("CARDNAME", c.getName()));
        }
        GameStateEvaluator.debugPrint("Score = " + score);
        return new Score(score, summonSickScore);
    }

    public int evalManaBase(Game game, Player player, AIDeckStatistics statistics) {
        int value = 0;
        boolean max_colored = false;
        int max_total = 0;
        int[] counts = new int[6];
        for (Card c : player.getCardsIn(ZoneType.Battlefield)) {
            int max_produced = 0;
            for (SpellAbility m4 : c.getManaAbilities()) {
                m4.setActivatingPlayer(c.getController());
                int mana_cost = m4.getPayCosts().getTotalMana().getCMC();
                max_produced = Math.max(max_produced, m4.amountOfManaGenerated(true) - mana_cost);
                for (AbilityManaPart mp : m4.getAllManaParts()) {
                    for (String part : mp.mana(m4).split(" ")) {
                        int index = ManaAtom.getIndexFromName(part);
                        if (index == -1) continue;
                        int n = index;
                        counts[n] = counts[n] + 1;
                    }
                }
            }
            max_total += max_produced;
        }
        for (int i = 0; i < counts.length; ++i) {
            value += Math.min(counts[i], statistics.maxPips[i]) * 100;
        }
        value += Math.min(max_total, statistics.maxCost) * 100;
        return value += Math.max(0, max_total - statistics.maxCost) * 5;
    }

    public int evalCard(Game game, Player aiPlayer, Card c) {
        if (c.isCreature()) {
            return this.eval.evaluateCreature(c);
        }
        if (c.isLand()) {
            return GameStateEvaluator.evaluateLand(c);
        }
        if (c.isEnchantingCard()) {
            return 0;
        }
        int value = 50 + 30 * c.getCMC();
        if (c.isPlaneswalker()) {
            value += 2 * c.getCounters(CounterEnumType.LOYALTY);
        }
        return value;
    }

    public static int evaluateLand(Card c) {
        int value = 3;
        int max_produced = 0;
        HashSet<String> colors_produced = new HashSet<String>();
        for (SpellAbility m4 : c.getManaAbilities()) {
            m4.setActivatingPlayer(c.getController());
            int mana_cost = m4.getPayCosts().getTotalMana().getCMC();
            max_produced = Math.max(max_produced, m4.amountOfManaGenerated(true) - mana_cost);
            for (AbilityManaPart mp : m4.getAllManaParts()) {
                colors_produced.addAll(Arrays.asList(mp.mana(m4).split(" ")));
            }
        }
        value += 100 * max_produced;
        int size = Math.max(colors_produced.size(), colors_produced.contains("Any") ? 5 : 0);
        value += size * 3;
        for (SpellAbility m5 : c.getNonManaAbilities()) {
            if (m5.isLandAbility()) continue;
            if (!m5.getPayCosts().hasTapCost()) {
                value += 25;
                continue;
            }
            if (m5.getPayCosts().hasSpecificCostType(CostSacrifice.class)) {
                value += 10;
                continue;
            }
            value += 50;
        }
        for (StaticAbility s2 : c.getStaticAbilities()) {
            value += 6;
        }
        return value;
    }

    public static class Score {
        public final int value;
        public final int summonSickValue;

        public Score(int value) {
            this.value = value;
            this.summonSickValue = value;
        }

        public Score(int value, int summonSickValue) {
            this.value = value;
            this.summonSickValue = summonSickValue;
        }

        public boolean equals(Score other) {
            if (other == null) {
                return false;
            }
            return this.value == other.value && this.summonSickValue == other.summonSickValue;
        }

        public String toString() {
            return this.value + (this.summonSickValue != this.value ? " (ss " + this.summonSickValue + ")" : "");
        }
    }

    private class SimulationCreatureEvaluator
    extends CreatureEvaluator {
        private SimulationCreatureEvaluator() {
        }

        @Override
        protected int addValue(int value, String text) {
            if (GameStateEvaluator.this.debugging && value != 0) {
                GameSimulator.debugPrint(value + " via " + text);
            }
            return super.addValue(value, text);
        }
    }

    private static class CombatSimResult {
        public GameCopier copier;
        public Game gameCopy;

        private CombatSimResult() {
        }
    }
}

