/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import forge.ai.ComputerUtil;
import forge.ai.PlayerControllerAi;
import forge.ai.simulation.GameCopier;
import forge.ai.simulation.GameStateEvaluator;
import forge.ai.simulation.SimulationController;
import forge.ai.simulation.SpellAbilityChoicesIterator;
import forge.ai.simulation.SpellAbilityPicker;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class GameSimulator {
    public static boolean COPY_STACK = false;
    private final SimulationController controller;
    private GameCopier copier;
    private Game simGame;
    private Player aiPlayer;
    private GameStateEvaluator eval;
    private List<String> origLines;
    private GameStateEvaluator.Score origScore;
    private SpellAbilityChoicesIterator interceptor;
    public static boolean debugPrint;
    public static List<String> debugLines;

    public GameSimulator(SimulationController controller, Game origGame, Player origAiPlayer, PhaseType advanceToPhase) {
        this.controller = controller;
        this.copier = new GameCopier(origGame);
        this.simGame = this.copier.makeCopy(advanceToPhase, origAiPlayer);
        this.aiPlayer = (Player)this.copier.find(origAiPlayer);
        this.eval = new GameStateEvaluator();
        this.origLines = new ArrayList<String>();
        debugLines = this.origLines;
        debugPrint = false;
        this.origScore = this.eval.getScoreForGameState(origGame, origAiPlayer);
        if (advanceToPhase == null) {
            this.ensureGameCopyScoreMatches(origGame, origAiPlayer);
        }
        if (COPY_STACK && !origGame.getStackZone().isEmpty()) {
            this.origLines = new ArrayList<String>();
            debugLines = this.origLines;
            Game copyOrigGame = this.copier.makeCopy();
            Player copyOrigAiPlayer = (Player)copyOrigGame.getPlayers().get(true);
            GameSimulator.resolveStack(copyOrigGame, (Player)copyOrigGame.getPlayers().get(false));
            this.origScore = this.eval.getScoreForGameState(copyOrigGame, copyOrigAiPlayer);
        }
        debugPrint = false;
        debugLines = null;
    }

    private void ensureGameCopyScoreMatches(Game origGame, Player origAiPlayer) {
        this.eval.setDebugging(true);
        ArrayList<String> simLines = new ArrayList<String>();
        debugLines = simLines;
        GameStateEvaluator.Score simScore = this.eval.getScoreForGameState(this.simGame, this.aiPlayer);
        if (!simScore.equals(this.origScore)) {
            this.origLines = new ArrayList<String>();
            debugLines = this.origLines;
            this.eval.getScoreForGameState(origGame, origAiPlayer);
            this.printDiff(this.origLines, simLines);
            System.out.flush();
            throw new RuntimeException("Game copy error. See diff output above for details.");
        }
        this.eval.setDebugging(false);
    }

    public void setInterceptor(SpellAbilityChoicesIterator interceptor) {
        this.interceptor = interceptor;
        ((PlayerControllerAi)this.aiPlayer.getController()).getAi().getSimulationPicker().setInterceptor(interceptor);
    }

    private void printDiff(List<String> lines1, List<String> lines2) {
        int i = 0;
        int j = 0;
        Collections.sort(lines1);
        Collections.sort(lines2);
        while (i < lines1.size() && j < lines2.size()) {
            String right;
            String left = lines1.get(i);
            int cmp = left.compareTo(right = lines2.get(j));
            if (cmp == 0) {
                ++i;
                ++j;
                continue;
            }
            if (cmp < 0) {
                System.out.println("-" + left);
                ++i;
                continue;
            }
            System.out.println("+" + right);
            ++j;
        }
        while (i < lines1.size()) {
            System.out.println("-" + lines1.get(i++));
        }
        while (j < lines2.size()) {
            System.out.println("+" + lines2.get(j++));
        }
    }

    public static void debugPrint(String str) {
        if (debugPrint) {
            System.out.println(str);
        }
        if (debugLines != null) {
            debugLines.add(str);
        }
    }

    private SpellAbility findSaInSimGame(SpellAbility sa) {
        if (sa.getHostCard().getGame().equals(this.simGame)) {
            return sa;
        }
        Card origHostCard = sa.getHostCard();
        Card hostCard = (Card)this.copier.find(origHostCard);
        String desc = sa.getDescription();
        FCollectionView<SpellAbility> candidates = hostCard.getSpellAbilities();
        for (SpellAbility cSa : candidates) {
            if (!desc.equals(cSa.getDescription())) continue;
            return cSa;
        }
        for (SpellAbility cSa : candidates) {
            if (!desc.startsWith(cSa.getDescription())) continue;
            return cSa;
        }
        return null;
    }

    public GameStateEvaluator.Score simulateSpellAbility(SpellAbility origSa) {
        return this.simulateSpellAbility(origSa, this.eval, true);
    }

    public GameStateEvaluator.Score simulateSpellAbility(SpellAbility origSa, boolean resolve) {
        return this.simulateSpellAbility(origSa, this.eval, resolve);
    }

    public GameStateEvaluator.Score simulateSpellAbility(SpellAbility origSa, GameStateEvaluator eval, boolean resolve) {
        SpellAbility sa;
        if (origSa.isLandAbility()) {
            Card hostCard = (Card)this.copier.find(origSa.getHostCard());
            if (!this.aiPlayer.playLand(hostCard, false, origSa)) {
                System.err.println("Simulation: Couldn't play land! " + origSa);
            }
            sa = origSa;
        } else {
            sa = this.findSaInSimGame(origSa);
            if (sa == null) {
                System.err.println("Simulation: SA not found! " + origSa + " / " + origSa.getClass());
                return new GameStateEvaluator.Score(Integer.MIN_VALUE);
            }
            GameSimulator.debugPrint("Found SA " + sa + " on host card " + sa.getHostCard() + " with owner:" + sa.getHostCard().getOwner());
            sa.setActivatingPlayer(this.aiPlayer, true);
            SpellAbility origSaOrSubSa = origSa;
            SpellAbility saOrSubSa = sa;
            do {
                if (origSaOrSubSa.usesTargeting()) {
                    boolean divided = origSaOrSubSa.isDividedAsYouChoose();
                    for (GameObject o : origSaOrSubSa.getTargets()) {
                        GameObject target = this.copier.find(o);
                        saOrSubSa.getTargets().add(target);
                        if (!divided) continue;
                        saOrSubSa.addDividedAllocation(target, origSaOrSubSa.getDividedValue(o));
                    }
                }
                origSaOrSubSa = origSaOrSubSa.getSubAbility();
            } while ((saOrSubSa = saOrSubSa.getSubAbility()) != null);
            if (debugPrint && !sa.getAllTargetChoices().isEmpty()) {
                GameSimulator.debugPrint("Targets: ");
                for (TargetChoices target : sa.getAllTargetChoices()) {
                    System.out.print(target);
                }
                System.out.println();
            }
            SpellAbility playingSa = sa;
            this.simGame.copyLastState();
            boolean success = ComputerUtil.handlePlayingSpellAbility(this.aiPlayer, sa, this.simGame, () -> {
                if (this.interceptor != null) {
                    this.interceptor.announceX(playingSa);
                    this.interceptor.chooseTargets(playingSa, this);
                }
            });
            if (!success) {
                return new GameStateEvaluator.Score(Integer.MIN_VALUE);
            }
        }
        if (resolve) {
            Player opponent = this.aiPlayer.getWeakestOpponent();
            GameSimulator.resolveStack(this.simGame, opponent);
        }
        ArrayList<String> simLines = null;
        if (debugPrint) {
            GameSimulator.debugPrint("SimGame:");
            simLines = new ArrayList<String>();
            debugLines = simLines;
            debugPrint = false;
        }
        GameStateEvaluator.Score score = eval.getScoreForGameState(this.simGame, this.aiPlayer);
        if (simLines != null) {
            debugLines = null;
            debugPrint = true;
            this.printDiff(this.origLines, simLines);
        }
        this.controller.possiblyCacheResult(score, origSa);
        if (this.controller.shouldRecurse() && !this.simGame.isGameOver()) {
            this.controller.push(sa, score, this);
            SpellAbilityPicker sim = new SpellAbilityPicker(this.simGame, this.aiPlayer);
            SpellAbility nextSa = sim.chooseSpellAbilityToPlay(this.controller);
            if (nextSa != null) {
                score = sim.getScoreForChosenAbility();
            }
            this.controller.pop(score, nextSa);
        }
        return score;
    }

    public static void resolveStack(Game game, Player opponent) {
        PlayerControllerAi sim = new PlayerControllerAi(game, opponent, opponent.getLobbyPlayer());
        sim.setUseSimulation(true);
        opponent.runWithController(() -> {
            HashSet<Card> allAffectedCards = new HashSet<Card>();
            game.getAction().checkStateEffects(false, allAffectedCards);
            game.getStack().addAllTriggeredAbilitiesToStack();
            while (!game.getStack().isEmpty() && !game.isGameOver()) {
                GameSimulator.debugPrint("Resolving:" + game.getStack().peekAbility());
                game.getStack().resolveStack();
                game.getAction().checkStateEffects(false, allAffectedCards);
                game.getStack().addAllTriggeredAbilitiesToStack();
            }
        }, sim);
    }

    public Game getSimulatedGameState() {
        return this.simGame;
    }

    public GameStateEvaluator.Score getScoreForOrigGame() {
        return this.origScore;
    }

    public GameCopier getGameCopier() {
        return this.copier;
    }
}

