/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class VoteAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        String logic = sa.getParam("AILogic");
        Card host = sa.getHostCard();
        if ("Always".equals(logic)) {
            return true;
        }
        if ("Judgment".equals(logic)) {
            return !CardLists.getValidCards((Iterable<Card>)host.getGame().getCardsIn(ZoneType.Battlefield), sa.getParam("VoteCard"), host.getController(), host, (CardTraitBase)sa).isEmpty();
        }
        if ("Torture".equals(logic)) {
            return aiPlayer.getGame().getPhaseHandler().getPhase().isAfter(PhaseType.MAIN1);
        }
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return this.canPlayAI(aiPlayer, sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        return true;
    }

    @Override
    public int chooseNumber(Player player, SpellAbility sa, int min2, int max, Map<String, Object> params) {
        Player p;
        if (params.containsKey("Voter") && (p = (Player)params.get("Voter")).isOpponentOf(player)) {
            return min2;
        }
        if (sa.getActivatingPlayer().isOpponentOf(player)) {
            return min2;
        }
        return max;
    }
}

