/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Lists;
import forge.ai.AiPlayDecision;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VentureAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        PhaseHandler ph = aiPlayer.getGame().getPhaseHandler();
        if (sa.getPayCosts().hasManaCost() || sa.getPayCosts().hasTapCost()) {
            if (VentureAi.isSorcerySpeed(sa, aiPlayer)) {
                return ph.is(PhaseType.MAIN2, aiPlayer);
            }
            return ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn() == aiPlayer;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        return mandatory || this.canPlayAI(aiPlayer, sa);
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    public SpellAbility chooseSingleSpellAbility(Player player, SpellAbility sa, List<SpellAbility> spells, Map<String, Object> params) {
        ArrayList<SpellAbility> viableRooms = Lists.newArrayList();
        for (SpellAbility room : spells) {
            if (!player.getController().isAI()) continue;
            room.setActivatingPlayer(player, true);
            if (((PlayerControllerAi)player.getController()).getAi().canPlaySa(room) != AiPlayDecision.WillPlay) continue;
            viableRooms.add(room);
        }
        if (!viableRooms.isEmpty()) {
            return (SpellAbility)Aggregates.random(viableRooms);
        }
        return Aggregates.random(spells);
    }
}

