/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.cost.CostTap;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.phase.Untap;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import java.util.List;
import java.util.Map;

public class UntapAi
extends SpellAbilityAi {
    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        Card source = sa.getHostCard();
        if ("EOT".equals(aiLogic) && (source.getGame().getPhaseHandler().getNextTurn() != ai || !source.getGame().getPhaseHandler().getPhase().equals((Object)PhaseType.END_OF_TURN))) {
            return false;
        }
        if ("PoolExtraMana".equals(aiLogic)) {
            return this.doPoolExtraManaLogic(ai, sa);
        }
        if ("PreventCombatDamage".equals(aiLogic)) {
            return this.doPreventCombatDamageLogic(ai, sa);
        }
        return !"Never".equals(aiLogic);
    }

    @Override
    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        if (!ComputerUtilCost.checkAddM1M1CounterCost(cost, source)) {
            return false;
        }
        return ComputerUtilCost.checkDiscardCost(ai, cost, source, sa);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (sa.usesTargeting()) {
            return UntapAi.untapPrefTargeting(ai, sa, false);
        }
        CardCollection pDefined = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
        return pDefined.isEmpty() || ((Card)pDefined.get(0)).isTapped() && ((Card)pDefined.get(0)).getController() == ai;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
            if ("Never".equals(sa.getParam("AILogic"))) {
                return false;
            }
            CardCollection pDefined = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            return pDefined.isEmpty() || ((Card)pDefined.get(0)).isTapped() && ((Card)pDefined.get(0)).getController() == ai;
        }
        if (UntapAi.untapPrefTargeting(ai, sa, mandatory)) {
            return true;
        }
        if (mandatory) {
            return this.untapUnpreferredTargeting(sa, mandatory);
        }
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        boolean randomReturn = true;
        if (sa.usesTargeting() && !UntapAi.untapPrefTargeting(ai, sa, false)) {
            return false;
        }
        return randomReturn;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean untapPrefTargeting(Player ai, SpellAbility sa, boolean mandatory) {
        AbilitySub subSa;
        Card source = sa.getHostCard();
        if (UntapAi.alreadyAssignedTarget(sa) && sa.getTargets().size() > 0) {
            return true;
        }
        sa.resetTargets();
        PlayerCollection targetController = sa.isCurse() || sa.getSubAbility() != null && sa.getSubAbility().getApi() == ApiType.GainControl ? ai.getOpponents() : ai.getYourTeam();
        CardCollection list = CardLists.getTargetableCards(targetController.getCardsIn(ZoneType.Battlefield), sa);
        if (!sa.isCurse()) {
            list = ComputerUtil.getSafeTargets(ai, sa, list);
        }
        if (list.isEmpty()) {
            return false;
        }
        boolean targetUntapped = false;
        if (sa.getSubAbility() != null && (subSa = sa.getSubAbility()).getApi() == ApiType.RemoveFromCombat && "RemoveBestAttacker".equals(subSa.getParam("AILogic"))) {
            targetUntapped = true;
        }
        CardCollection untapList = targetUntapped ? list : CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.TAPPED);
        String[] tappablePermanents = new String[]{"Creature", "Land", "Artifact"};
        untapList = CardLists.getValidCards((Iterable<Card>)untapList, tappablePermanents, source.getController(), source, (CardTraitBase)sa);
        if (sa.getPayCosts().hasOnlySpecificCostType(CostTap.class)) {
            CardCollection toRemove = new CardCollection();
            block0: for (Card c : untapList) {
                for (SpellAbility ab : c.getAllSpellAbilities()) {
                    if (ab.getApi() != ApiType.Untap || !ab.getPayCosts().hasOnlySpecificCostType(CostTap.class) || !ab.canTarget(source)) continue;
                    toRemove.add(c);
                    continue block0;
                }
            }
            untapList.removeAll(toRemove);
        }
        if (!sa.isTrigger() || mandatory) {
            CardCollection toExclude = ComputerUtilAbility.getCardsTargetedWithApi(ai, untapList, sa, ApiType.Untap);
            untapList.removeAll(toExclude);
        }
        while (sa.canAddMoreTarget()) {
            Card choice;
            block18: {
                choice = null;
                if (untapList.isEmpty()) {
                    if (sa.getSubAbility() != null && sa.getSubAbility().getApi() == ApiType.Animate && !list.isEmpty() && ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                        choice = ComputerUtilCard.getWorstPermanentAI(list, false, false, false, false);
                        break block18;
                    } else {
                        if (sa.isMinTargetChosen() && !sa.isZeroTargets()) break;
                        if (ComputerUtil.activateForCost(sa, ai)) {
                            return true;
                        }
                        sa.resetTargets();
                        return false;
                    }
                }
                choice = UntapAi.detectPriorityUntapTargets(untapList);
                if (choice == null) {
                    if (CardLists.getNotType(untapList, "Creature").isEmpty()) {
                        choice = ComputerUtilCard.getBestCreatureAI(untapList);
                    } else if (!sa.getPayCosts().hasManaCost() || sa.isTrigger() || "Always".equals(sa.getParam("AILogic"))) {
                        choice = ComputerUtilCard.getMostExpensivePermanentAI(untapList);
                    }
                }
            }
            if (choice == null) {
                if (sa.isMinTargetChosen() && !sa.isZeroTargets()) break;
                sa.resetTargets();
                return false;
            }
            untapList.remove(choice);
            list.remove(choice);
            sa.getTargets().add(choice);
        }
        return true;
    }

    private boolean untapUnpreferredTargeting(SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        CardCollection list = CardLists.getTargetableCards(source.getGame().getCardsIn(ZoneType.Battlefield), sa);
        String[] tappablePermanents = new String[]{"Enchantment", "Planeswalker"};
        CardCollection tapList = CardLists.getValidCards((Iterable<Card>)list, tappablePermanents, source.getController(), source, (CardTraitBase)sa);
        if (this.untapTargetList(source, tgt, sa, mandatory, tapList)) {
            return true;
        }
        tapList = CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.UNTAPPED);
        if (this.untapTargetList(source, tgt, sa, mandatory, tapList)) {
            return true;
        }
        tapList = list;
        return this.untapTargetList(source, tgt, sa, mandatory, tapList);
    }

    private boolean untapTargetList(Card source, TargetRestrictions tgt, SpellAbility sa, boolean mandatory, CardCollection tapList) {
        tapList.removeAll(sa.getTargets().getTargetCards());
        if (tapList.isEmpty()) {
            return false;
        }
        while (sa.canAddMoreTarget()) {
            Card choice = null;
            if (tapList.isEmpty()) {
                if (sa.getTargets().size() >= tgt.getMinTargets(source, sa) && sa.getTargets().size() != 0) break;
                if (!mandatory) {
                    sa.resetTargets();
                }
                return false;
            }
            choice = ComputerUtilCard.getBestAI(tapList);
            if (choice == null) {
                if (sa.getTargets().size() >= tgt.getMinTargets(source, sa) && sa.getTargets().size() != 0) break;
                if (!mandatory) {
                    sa.resetTargets();
                }
                return false;
            }
            tapList.remove(choice);
            sa.getTargets().add(choice);
        }
        return true;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> list, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CardCollection pref = CardLists.filterControlledBy(list, ai.getYourTeam());
        if (Iterables.isEmpty(pref)) {
            if (isOptional) {
                return null;
            }
        } else {
            list = pref;
        }
        return ComputerUtilCard.getBestAI(list);
    }

    private static Card detectPriorityUntapTargets(List<Card> untapList) {
        for (Card c : untapList) {
            if (!"True".equals(c.getSVar("UntapMe"))) continue;
            return c;
        }
        CardCollection noAutoUntap = CardLists.filter(untapList, Predicates.not(Untap.CANUNTAP));
        if (!noAutoUntap.isEmpty()) {
            return ComputerUtilCard.getBestAI(noAutoUntap);
        }
        return null;
    }

    private boolean doPreventCombatDamageLogic(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        Card source = sa.getHostCard();
        sa.resetTargets();
        if (!game.getPhaseHandler().getPlayerTurn().isOpponentOf(ai)) {
            return false;
        }
        Combat activeCombat = game.getCombat();
        if (activeCombat == null) {
            return false;
        }
        CardCollection list = CardLists.getTargetableCards(activeCombat.getAttackers(), sa);
        if (list.isEmpty()) {
            return false;
        }
        if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            Card card = ComputerUtilCombat.mostDangerousAttacker(list, ai, activeCombat, true);
            if (card == null) {
                return false;
            }
            sa.getTargets().add(card);
            return true;
        }
        return false;
    }

    private static boolean alreadyAssignedTarget(SpellAbility sa) {
        if (sa.hasParam("AILogic")) {
            String aiLogic = sa.getParam("AILogic");
            return "PreventCombatDamage".equals(aiLogic);
        }
        return false;
    }

    private boolean doPoolExtraManaLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        PhaseHandler ph = source.getGame().getPhaseHandler();
        Game game = ai.getGame();
        if (source.isTapped()) {
            return true;
        }
        CardCollection inHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), Predicates.not(CardPredicates.Presets.LANDS));
        CardCollection playable = CardLists.filter((Iterable<Card>)inHand, CardPredicates.Presets.PERMANENTS);
        CardCollection untappingCards = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), card -> {
            boolean hasUntapLandLogic = false;
            for (SpellAbility sa1 : card.getSpellAbilities()) {
                if (!"PoolExtraMana".equals(sa1.getParam("AILogic"))) continue;
                hasUntapLandLogic = true;
                break;
            }
            return hasUntapLandLogic && card.isUntapped();
        });
        if (ph.is(PhaseType.MAIN2, ai)) {
            for (Card c : playable) {
                for (SpellAbility ab : c.getBasicSpells()) {
                    if (ComputerUtilMana.hasEnoughManaSourcesToCast(ab, ai)) continue;
                    ManaCostBeingPaid reduced = new ManaCostBeingPaid(ab.getPayCosts().getCostMana().getManaCostFor(ab));
                    reduced.decreaseShard(ManaCostShard.GENERIC, untappingCards.size());
                    if (!ComputerUtilMana.canPayManaCost(reduced, ab, ai, false)) continue;
                    CardCollection manaLandsTapped = CardLists.filter(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA, CardPredicates.Presets.TAPPED);
                    if (!(manaLandsTapped = CardLists.getValidCards((Iterable<Card>)manaLandsTapped, sa.getParam("ValidTgts"), ai, source, null)).isEmpty()) {
                        return true;
                    }
                    CardCollection manaLands = CardLists.filter(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA, CardPredicates.Presets.CAN_TAP);
                    if ((manaLands = CardLists.getValidCards((Iterable<Card>)manaLands, sa.getParam("ValidTgts"), ai, source, null)).isEmpty()) {
                        return false;
                    }
                    Card landToPool = (Card)manaLands.getFirst();
                    SpellAbility manaAb = landToPool.getManaAbilities().getFirst();
                    ComputerUtil.playNoStack(ai, manaAb, game, false);
                    return true;
                }
            }
        }
        return ph.getNextTurn() == ai && (ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS) || ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS));
    }
}

