/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.List;

public class UnattachAllAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        boolean chance;
        boolean bl = chance = (double)MyRandom.getRandom().nextFloat() <= 0.9;
        if (sa.usesTargeting()) {
            sa.resetTargets();
        }
        if (sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            if (xPay == 0) {
                return false;
            }
            sa.setXManaCostPaid(xPay);
        }
        if (ai.getGame().getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) && !"Curse".equals(sa.getParam("AILogic"))) {
            return false;
        }
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card card = sa.getHostCard();
        List<Object> targets = new ArrayList();
        if (!sa.usesTargeting()) {
            targets = AbilityUtils.getDefinedObjects(sa.getHostCard(), sa.getParam("Defined"), sa);
        }
        if (!mandatory && card.isEquipment() && !targets.isEmpty()) {
            Card newTarget = (Card)targets.get(0);
            if (!newTarget.getController().equals(ai)) {
                return false;
            }
            if (card.isEquipping()) {
                Card oldTarget = card.getEquipping();
                return ComputerUtilCard.evaluateCreature(oldTarget) <= ComputerUtilCard.evaluateCreature(newTarget);
            }
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.canPlayAI(ai, sa);
    }
}

