/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.ability.TapAiBase;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class TapAi
extends TapAiBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        PhaseHandler phase = ai.getGame().getPhaseHandler();
        Player turn = phase.getPlayerTurn();
        if (!turn.isOpponentOf(ai) || !phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            if (turn.equals(ai)) {
                if (!TapAi.isSorcerySpeed(sa, ai) || !phase.getPhase().isBefore(PhaseType.COMBAT_BEGIN)) {
                    if (!phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) return false;
                    AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
                    if (!aic.getBooleanProperty(AiProps.PLAY_AGGRO)) {
                        return false;
                    }
                }
            } else if (!TapAi.playReusable(ai, sa)) {
                return false;
            }
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        Card source = sa.getHostCard();
        Cost abCost = sa.getPayCosts();
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if ("GoblinPolkaBand".equals(aiLogic)) {
            return SpecialCardAi.GoblinPolkaBand.consider(ai, sa);
        }
        if ("Arena".equals(aiLogic)) {
            return SpecialCardAi.Arena.consider(ai, sa);
        }
        if (!ComputerUtilCost.checkDiscardCost(ai, abCost, source, sa)) {
            return false;
        }
        if (!sa.usesTargeting()) {
            CardCollection untap = sa.hasParam("CardChoices") ? CardLists.getValidCards((Iterable<Card>)source.getGame().getCardsIn(ZoneType.Battlefield), sa.getParam("CardChoices"), ai, source, (CardTraitBase)sa) : AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            boolean bFlag = false;
            for (Card c : untap) {
                bFlag |= c.isUntapped();
            }
            return bFlag;
        }
        if ("X".equals(sa.getTargetRestrictions().getMinTargets()) && sa.getSVar("X").equals("Count$xPaid")) {
            sa.setXManaCostPaid(ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()));
        }
        sa.resetTargets();
        return this.tapPrefTargeting(ai, source, sa, false);
    }
}

