/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import forge.ai.ComputerUtilMana;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Map;

public class ScryAi
extends SpellAbilityAi {
    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            } else {
                for (Player p : ai.getAllies()) {
                    if (!sa.canTarget(p)) continue;
                    sa.getTargets().add(p);
                    break;
                }
                if (mandatory && !sa.isTargetNumberValid()) {
                    for (Player p : ai.getOpponents()) {
                        if (!sa.canTarget(p)) continue;
                        sa.getTargets().add(p);
                        break;
                    }
                }
            }
            return mandatory || sa.isTargetNumberValid();
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.doTriggerAINoCost(ai, sa, false);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        String logic = sa.getParamOrDefault("AILogic", "");
        if ("BrainJar".equals(logic)) {
            return ph.getPhase().isAfter(PhaseType.MAIN2);
        }
        if (logic.equals("AtOppEOT") || sa.getPayCosts().hasTapCost() && (sa.getPayCosts().hasManaCost() || sa.getHostCard() != null && sa.getHostCard().isCreature()) && !ScryAi.isSorcerySpeed(sa, ai)) {
            return ph.getNextTurn() == ai && ph.is(PhaseType.END_OF_TURN);
        }
        if ("BestOpportunity".equals(logic)) {
            return this.doBestOpportunityLogic(ai, sa, ph);
        }
        if (ph.isPlayerTurn(ai)) {
            if (ScryAi.isSorcerySpeed(sa, ai)) {
                return ph.is(PhaseType.MAIN1) || sa.isPwAbility();
            }
            return ph.is(PhaseType.UPKEEP);
        }
        return true;
    }

    private boolean doBestOpportunityLogic(Player ai, SpellAbility sa, PhaseHandler ph) {
        boolean hasSomethingElse = false;
        block0: for (Card c : CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), Predicates.not(CardPredicates.Presets.LANDS))) {
            for (SpellAbility ab : c.getAllSpellAbilities()) {
                if (!ab.getPayCosts().hasManaCost() || !ComputerUtilMana.hasEnoughManaSourcesToCast(ab, ai) || ab.getApi() == ApiType.Scry) continue;
                hasSomethingElse = true;
                continue block0;
            }
        }
        return !hasSomethingElse && ph.getPlayerTurn() == ai && ph.getPhase().isAfter(PhaseType.DRAW) || ph.getNextTurn() == ai && ph.is(PhaseType.END_OF_TURN);
    }

    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        if ("Never".equals(aiLogic)) {
            return false;
        }
        if ("BrainJar".equals(aiLogic)) {
            return SpecialCardAi.BrainInAJar.consider(ai, sa);
        }
        if ("MultipleChoice".equals(aiLogic)) {
            return SpecialCardAi.MultipleChoice.consider(ai, sa);
        }
        return true;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        boolean randomReturn;
        if (ai.getCardsIn(ZoneType.Library).isEmpty()) {
            return false;
        }
        double chance = 0.4;
        if (ScryAi.isSorcerySpeed(sa, ai)) {
            chance = 0.667;
        }
        boolean bl = randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(chance, sa.getActivationsThisTurn() + 1);
        if (ScryAi.playReusable(ai, sa)) {
            randomReturn = true;
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            } else {
                for (Player p : ai.getAllies()) {
                    if (!sa.canTarget(p)) continue;
                    sa.getTargets().add(p);
                    break;
                }
            }
            randomReturn = sa.isTargetNumberValid();
        }
        return randomReturn;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }
}

