/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.TextUtil;

public class RollPlanarDiceAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        if (ai.getGame().getActivePlanes() == null) {
            return false;
        }
        for (Card c : ai.getGame().getActivePlanes()) {
            if (!this.willRollOnPlane(ai, c)) continue;
            return true;
        }
        return false;
    }

    private boolean willRollOnPlane(Player ai, Card plane) {
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        boolean decideToRoll = false;
        boolean rollInMain1 = false;
        String modeName = "never";
        int maxActivations = aic.getIntProperty(AiProps.DEFAULT_MAX_PLANAR_DIE_ROLLS_PER_TURN);
        int chance = aic.getIntProperty(AiProps.DEFAULT_PLANAR_DIE_ROLL_CHANCE);
        int hesitationChance = aic.getIntProperty(AiProps.PLANAR_DIE_ROLL_HESITATION_CHANCE);
        int minTurnToRoll = aic.getIntProperty(AiProps.DEFAULT_MIN_TURN_TO_ROLL_PLANAR_DIE);
        if (plane.hasSVar("AIRollPlanarDieParams")) {
            String[] params = plane.getSVar("AIRollPlanarDieParams").toLowerCase().trim().split("\\|");
            block44: for (String param : params) {
                String[] paramData = param.split("\\$");
                String paramName = paramData[0].trim();
                String paramValue = paramData[1].trim();
                switch (paramName) {
                    case "mode": {
                        modeName = paramValue;
                        continue block44;
                    }
                    case "chance": {
                        chance = Integer.parseInt(paramValue);
                        continue block44;
                    }
                    case "minturn": {
                        minTurnToRoll = Integer.parseInt(paramValue);
                        continue block44;
                    }
                    case "maxrollsperturn": {
                        maxActivations = Integer.parseInt(paramValue);
                        continue block44;
                    }
                    case "rollinmain1": {
                        if (!paramValue.equals("true")) continue block44;
                        rollInMain1 = true;
                        continue block44;
                    }
                    case "lowpriority": {
                        continue block44;
                    }
                    case "cardsinhandle": {
                        if (ai.getCardsIn(ZoneType.Hand).size() <= Integer.parseInt(paramValue)) continue block44;
                        return false;
                    }
                    case "cardsinhandge": {
                        if (ai.getCardsIn(ZoneType.Hand).size() >= Integer.parseInt(paramValue)) continue block44;
                        return false;
                    }
                    case "cardsingraveyardle": {
                        if (ai.getCardsIn(ZoneType.Graveyard).size() <= Integer.parseInt(paramValue)) continue block44;
                        return false;
                    }
                    case "cardsingraveyardge": {
                        if (ai.getCardsIn(ZoneType.Graveyard).size() >= Integer.parseInt(paramValue)) continue block44;
                        return false;
                    }
                    case "hascreatureinplay": {
                        if (this.detectCreatureInZone(ai, ZoneType.Battlefield)) continue block44;
                        return false;
                    }
                    case "opphascreatureinplay": {
                        boolean oppHasCreature = false;
                        for (Player op : ai.getOpponents()) {
                            oppHasCreature |= this.detectCreatureInZone(op, ZoneType.Battlefield);
                        }
                        if (oppHasCreature) continue block44;
                        return false;
                    }
                    case "hascolorcreatureinplay": {
                        if (this.detectColorInZone(ai, paramValue, ZoneType.Battlefield, true)) continue block44;
                        return false;
                    }
                    case "hascolorinplay": {
                        if (this.detectColorInZone(ai, paramValue, ZoneType.Battlefield, false)) continue block44;
                        return false;
                    }
                    case "hascoloringraveyard": {
                        if (this.detectColorInZone(ai, paramValue, ZoneType.Graveyard, false)) continue block44;
                        return false;
                    }
                    default: {
                        System.out.println(TextUtil.concatNoSpace("Unexpected AI hint parameter in card ", plane.getName(), " in RollPlanarDiceAi: ", paramName, "."));
                    }
                }
            }
            switch (modeName) {
                case "always": {
                    decideToRoll = true;
                    break;
                }
                case "random": {
                    if (MyRandom.getRandom().nextInt(100) >= chance) break;
                    decideToRoll = true;
                    break;
                }
                case "never": {
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (ai.getGame().getPhaseHandler().getTurn() < minTurnToRoll) {
                decideToRoll = false;
            } else if (!rollInMain1 && ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2)) {
                decideToRoll = false;
            }
            if (ai.getGame().getPhaseHandler().getPlanarDiceSpecialActionThisTurn() >= maxActivations) {
                decideToRoll = false;
            }
            if (MyRandom.getRandom().nextInt(100) < hesitationChance) {
                decideToRoll = false;
            }
        }
        return decideToRoll;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return this.canPlayAI(aiPlayer, sa);
    }

    private boolean detectColorInZone(Player p, String paramValue, ZoneType zone, boolean creaturesOnly) {
        boolean hasColorInPlay = false;
        for (Card c : p.getCardsIn(zone)) {
            if (creaturesOnly && !c.isCreature()) continue;
            if (paramValue.contains("u") && c.isBlue()) {
                hasColorInPlay = true;
                break;
            }
            if (paramValue.contains("g") && c.isGreen()) {
                hasColorInPlay = true;
                break;
            }
            if (paramValue.contains("r") && c.isRed()) {
                hasColorInPlay = true;
                break;
            }
            if (paramValue.contains("w") && c.isWhite()) {
                hasColorInPlay = true;
                break;
            }
            if (!paramValue.contains("b") || !c.isBlack()) continue;
            hasColorInPlay = true;
            break;
        }
        return hasColorInPlay;
    }

    private boolean detectCreatureInZone(Player p, ZoneType zone) {
        boolean hasCreatureInPlay = false;
        for (Card c : p.getCardsIn(zone)) {
            if (!c.isCreature()) continue;
            hasCreatureInPlay = true;
            break;
        }
        return hasCreatureInPlay;
    }
}

