/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.util.Map;

public class RepeatEachAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        String logic = sa.getParam("AILogic");
        if ("PriceOfProgress".equals(logic)) {
            return SpecialCardAi.PriceOfProgress.consider(aiPlayer, sa);
        }
        if ("Never".equals(logic)) {
            return false;
        }
        if ("CloneAllTokens".equals(logic)) {
            CardCollection humTokenCreats = CardLists.filter((Iterable<Card>)aiPlayer.getOpponents().getCreaturesInPlay(), CardPredicates.Presets.TOKEN);
            CardCollection compTokenCreats = aiPlayer.getTokensInPlay();
            return compTokenCreats.size() > humTokenCreats.size();
        }
        if ("BalanceLands".equals(logic)) {
            if (aiPlayer.getLandsInPlay().size() >= 5) {
                return false;
            }
            PlayerCollection opponents = aiPlayer.getOpponents();
            for (Player opp : opponents) {
                if (opp.getLandsInPlay().size() >= 4) continue;
                return false;
            }
        } else {
            if ("AllPlayerLoseLife".equals(logic)) {
                int lossYou;
                Card source = sa.getHostCard();
                SpellAbility repeat = sa.getAdditionalAbility("RepeatSubAbility");
                String svar = repeat.getSVar(repeat.getParam("LifeAmount"));
                String svarYou = TextUtil.fastReplace(svar, "RememberedPlayer", "You");
                if (aiPlayer.canLoseLife() && (lossYou = AbilityUtils.calculateAmount(source, svarYou, repeat)) + 5 > aiPlayer.getLife()) {
                    return false;
                }
                boolean hitOpp = false;
                Card sourceLKI = CardCopyService.getLKICopy(source);
                for (Player opp : aiPlayer.getOpponents()) {
                    if (!opp.canLoseLife()) continue;
                    sourceLKI.setOwner(opp);
                    int lossOpp = AbilityUtils.calculateAmount(source, svarYou, repeat);
                    if (lossOpp <= 0) continue;
                    hitOpp = true;
                }
                return hitOpp;
            }
            if ("EquipAll".equals(logic)) {
                if (aiPlayer.getGame().getPhaseHandler().is(PhaseType.MAIN1, aiPlayer)) {
                    CardCollection unequipped = CardLists.filter((Iterable<Card>)aiPlayer.getCardsIn(ZoneType.Battlefield), card -> card.isEquipment() && card.getAttachedTo() != sa.getHostCard());
                    return !unequipped.isEmpty();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        return ComputerUtilCard.getBestCreatureAI(options);
    }
}

