/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.phase.Untap;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.List;

public abstract class PumpAiBase
extends SpellAbilityAi {
    public boolean containsUsefulKeyword(Player ai, List<String> keywords, Card card, SpellAbility sa, int attack) {
        for (String keyword : keywords) {
            if (!sa.isCurse() && this.isUsefulPumpKeyword(ai, keyword, card, sa, attack)) {
                return true;
            }
            if (!sa.isCurse() || !this.isUsefulCurseKeyword(ai, keyword, card, sa)) continue;
            return true;
        }
        return false;
    }

    public boolean grantsUsefulExtraBlockOpts(Player ai, SpellAbility sa, Card card, List<String> keywords) {
        int canBlockNum;
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        Card pumped = ComputerUtilCard.getPumpedCreature(ai, sa, card, 0, 0, keywords);
        if (ph.isPlayerTurn(ai) || !ph.getPhase().equals((Object)PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            return false;
        }
        int canBlockNumPumped = canBlockNum = 1 + card.canBlockAdditional();
        if (sa.hasParam("CanBlockAny")) {
            canBlockNumPumped = Integer.MAX_VALUE;
        } else if (sa.hasParam("CanBlockAmount")) {
            canBlockNumPumped += AbilityUtils.calculateAmount(pumped, sa.getParam("CanBlockAmount"), sa);
        }
        int possibleBlockNum = 0;
        int possibleBlockNumPumped = 0;
        for (Card attacker : ai.getGame().getCombat().getAttackers()) {
            if (!CombatUtil.canBlock(attacker, card) || ++possibleBlockNum <= canBlockNum) continue;
            possibleBlockNum = canBlockNum;
            break;
        }
        for (Card attacker : ai.getGame().getCombat().getAttackers()) {
            if (!CombatUtil.canBlock(attacker, pumped) || ++possibleBlockNumPumped <= canBlockNumPumped) continue;
            possibleBlockNumPumped = canBlockNumPumped;
            break;
        }
        return possibleBlockNumPumped > possibleBlockNum;
    }

    public boolean isUsefulCurseKeyword(Player ai, String keyword, Card card, SpellAbility sa) {
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        PhaseHandler ph = game.getPhaseHandler();
        if (!CardUtil.isStackingKeyword(keyword) && card.hasKeyword(keyword)) {
            return false;
        }
        if (keyword.equals("Defender") || keyword.endsWith("CARDNAME can't attack.")) {
            return ph.isPlayerTurn(card.getController()) && CombatUtil.canAttack(card, ai) && card.getNetCombatDamage() > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS);
        }
        if (keyword.endsWith("CARDNAME can't attack or block.")) {
            if ("UntilYourNextTurn".equals(sa.getParam("Duration"))) {
                return CombatUtil.canAttack(card, ai) || CombatUtil.canBlock(card, true);
            }
            if (!ph.isPlayerTurn(ai)) {
                return card.getNetCombatDamage() > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && CombatUtil.canAttack(card, ai);
            }
            if (ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) || ph.getPhase().isBefore(PhaseType.MAIN1)) {
                return false;
            }
            CardCollection attackers = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), c -> {
                if (c.equals(sa.getHostCard()) && sa.getPayCosts().hasTapCost() && (combat == null || !combat.isAttacking((Card)c))) {
                    return false;
                }
                return combat != null && combat.isAttacking((Card)c) || CombatUtil.canAttack(c, card.getController());
            });
            return CombatUtil.canBlockAtLeastOne(card, attackers);
        }
        if (keyword.endsWith("CARDNAME can't block.")) {
            if (!ph.isPlayerTurn(ai) || ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) || ph.getPhase().isBefore(PhaseType.MAIN1)) {
                return false;
            }
            CardCollection attackers = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), c -> {
                if (c.equals(sa.getHostCard()) && sa.getPayCosts().hasTapCost() && (combat == null || !combat.isAttacking((Card)c))) {
                    return false;
                }
                return combat != null && combat.isAttacking((Card)c) && card.getController().equals(combat.getDefenderPlayerByAttacker((Card)c)) || CombatUtil.canAttack(c, card.getController());
            });
            return CombatUtil.canBlockAtLeastOne(card, attackers);
        }
        if (keyword.endsWith("This card doesn't untap during your next untap step.")) {
            return !ph.getPhase().isBefore(PhaseType.MAIN2) && !card.isUntapped() && ph.isPlayerTurn(ai) && Untap.canUntap(card);
        }
        if (keyword.endsWith("Prevent all combat damage that would be dealt by CARDNAME.") || keyword.endsWith("Prevent all damage that would be dealt by CARDNAME.")) {
            if (ph.isPlayerTurn(ai) && (!CombatUtil.canBlock(card) && (combat == null || !combat.isBlocking(card)) || card.getNetCombatDamage() <= 0 || ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) || ph.getPhase().isBefore(PhaseType.MAIN1) || CardLists.getNotKeyword((Iterable<Card>)ai.getCreaturesInPlay(), Keyword.DEFENDER).isEmpty())) {
                return false;
            }
            return ph.isPlayerTurn(ai) || combat != null && combat.isAttacking(card) && card.getNetCombatDamage() > 0;
        }
        return !keyword.endsWith("CARDNAME's activated abilities can't be activated.");
    }

    public boolean isUsefulPumpKeyword(Player ai, String keyword, Card card, SpellAbility sa, int attack) {
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        PhaseHandler ph = game.getPhaseHandler();
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        int newPower = card.getNetCombatDamage() + attack;
        if (!CardUtil.isStackingKeyword(keyword) && card.hasKeyword(keyword)) {
            return false;
        }
        boolean evasive = keyword.endsWith("Shadow");
        if (evasive) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.endsWith("Flying")) {
            CardCollectionView attackingFlyer = CardCollection.EMPTY;
            if (combat != null) {
                attackingFlyer = CardLists.getKeyword((Iterable<Card>)combat.getAttackers(), Keyword.FLYING);
            }
            if (ph.isPlayerTurn(opp) && ph.getPhase() == PhaseType.COMBAT_DECLARE_ATTACKERS && !attackingFlyer.isEmpty() && !card.hasKeyword(Keyword.REACH) && CombatUtil.canBlock(card) && ComputerUtilCombat.lifeInDanger(ai, game.getCombat())) {
                return true;
            }
            Predicate<Card> flyingOrReach = Predicates.or(CardPredicates.hasKeyword(Keyword.FLYING), CardPredicates.hasKeyword(Keyword.REACH));
            if (ph.isPlayerTurn(opp) && combat != null && !attackingFlyer.isEmpty() && CombatUtil.canBlock(card)) {
                for (Card c : attackingFlyer) {
                    if (ComputerUtilCombat.combatantCantBeDestroyed(c.getController(), c) || (card.getNetPower() < c.getNetToughness() || card.getNetToughness() <= c.getNetPower()) && !ComputerUtilCombat.combatantCantBeDestroyed(ai, card)) continue;
                    return true;
                }
            }
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && Iterables.any(CardLists.filter((Iterable<Card>)opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card)), Predicates.not(flyingOrReach));
        }
        if (keyword.endsWith("Horsemanship")) {
            if (ph.isPlayerTurn(opp) && ph.getPhase().equals((Object)PhaseType.COMBAT_DECLARE_ATTACKERS) && !CardLists.getKeyword((Iterable<Card>)game.getCombat().getAttackers(), Keyword.HORSEMANSHIP).isEmpty() && CombatUtil.canBlock(card) && ComputerUtilCombat.lifeInDanger(ai, game.getCombat())) {
                return true;
            }
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getNotKeyword((Iterable<Card>)CardLists.filter((Iterable<Card>)opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card)), Keyword.HORSEMANSHIP).isEmpty();
        }
        if (keyword.endsWith("Intimidate")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getNotType(CardLists.filter((Iterable<Card>)opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card)), "Artifact").isEmpty();
        }
        if (keyword.endsWith("Fear")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getNotColor(CardLists.getNotType(CardLists.filter((Iterable<Card>)opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card)), "Artifact"), (byte)4).isEmpty();
        }
        if (keyword.endsWith("Haste")) {
            return CombatUtil.isAttackerSick(card, opp) && !ph.isPlayerTurn(opp) && !card.isTapped() && newPower > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.endsWith("Indestructible")) {
            return combat != null && (combat.isBlocked(card) || combat.isBlocking(card)) && ComputerUtilCombat.combatantWouldBeDestroyed(ai, card, combat);
        }
        if (keyword.endsWith("Deathtouch")) {
            if (ph.isPlayerTurn(opp) && ph.getPhase().equals((Object)PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                CardCollection attackers = combat.getAttackers();
                for (Card attacker : attackers) {
                    if (!CombatUtil.canBlock(attacker, card, combat) || ComputerUtilCombat.canDestroyAttacker(ai, attacker, card, combat, false)) continue;
                    return true;
                }
            } else if (ph.isPlayerTurn(ai) && ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && CombatUtil.canAttack(card, opp)) {
                CardCollection blockers = opp.getCreaturesInPlay();
                for (Card blocker : blockers) {
                    if (!CombatUtil.canBlock(card, blocker, combat) || ComputerUtilCombat.canDestroyBlocker(ai, blocker, card, combat, false)) continue;
                    return true;
                }
            }
            return false;
        }
        if (keyword.startsWith("Bushido")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) && !opp.getCreaturesInPlay().isEmpty() && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("First Strike")) {
            if (card.hasDoubleStrike()) {
                return false;
            }
            if (combat != null && combat.isBlocked(card) && !combat.getBlockers(card).isEmpty()) {
                Card blocker = (Card)combat.getBlockers(card).get(false);
                if (ComputerUtilCombat.canDestroyAttacker(ai, card, blocker, combat, true) && !ComputerUtilCombat.canDestroyAttacker(ai, card, blocker, combat, false)) {
                    return true;
                }
                if (!ComputerUtilCombat.canDestroyBlocker(ai, blocker, card, combat, true) && ComputerUtilCombat.canDestroyBlocker(ai, blocker, card, combat, false)) {
                    return true;
                }
            }
            if (combat != null && combat.isBlocking(card) && !combat.getAttackersBlockedBy(card).isEmpty()) {
                Card attacker = (Card)combat.getAttackersBlockedBy(card).get(false);
                if (!ComputerUtilCombat.canDestroyAttacker(ai, attacker, card, combat, true) && ComputerUtilCombat.canDestroyAttacker(ai, attacker, card, combat, false)) {
                    return true;
                }
                return ComputerUtilCombat.canDestroyBlocker(ai, card, attacker, combat, true) && !ComputerUtilCombat.canDestroyBlocker(ai, card, attacker, combat, false);
            }
            return false;
        }
        if (keyword.equals("Double Strike")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && newPower > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS);
        }
        if (keyword.startsWith("Rampage")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && newPower > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && CardLists.filter((Iterable<Card>)opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card)).size() >= 2;
        }
        if (keyword.startsWith("Flanking")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && newPower > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && !CardLists.getNotKeyword((Iterable<Card>)CardLists.filter((Iterable<Card>)opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card)), Keyword.FLANKING).isEmpty();
        }
        if (keyword.startsWith("Trample")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && CombatUtil.canBeBlocked(card, null, opp) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 1 && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("Infect")) {
            if (newPower <= 0) {
                return false;
            }
            if (combat != null && combat.isBlocking(card) && !card.hasKeyword(Keyword.WITHER)) {
                return true;
            }
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS);
        }
        if (keyword.endsWith("Wither")) {
            if (newPower <= 0 || card.isWitherDamage()) {
                return false;
            }
            return combat != null && (combat.isBlocking(card) || combat.isAttacking(card) && combat.isBlocked(card));
        }
        if (keyword.equals("Lifelink")) {
            if (newPower <= 0 || ai.canGainLife()) {
                return false;
            }
            return combat != null && (combat.isAttacking(card) || combat.isBlocking(card));
        }
        if (keyword.equals("Vigilance")) {
            return !ph.isPlayerTurn(opp) && CombatUtil.canAttack(card, opp) && newPower > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && !CardLists.getNotKeyword((Iterable<Card>)opp.getCreaturesInPlay(), Keyword.DEFENDER).isEmpty();
        }
        if (keyword.equals("Reach")) {
            return !ph.isPlayerTurn(ai) && ph.getPhase().equals((Object)PhaseType.COMBAT_DECLARE_ATTACKERS) && !CardLists.getKeyword((Iterable<Card>)game.getCombat().getAttackers(), Keyword.FLYING).isEmpty() && !card.hasKeyword(Keyword.FLYING) && CombatUtil.canBlock(card);
        }
        if (keyword.equals("Shroud") || keyword.equals("Hexproof")) {
            return ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa).contains(card);
        }
        if (keyword.equals("Persist")) {
            return card.getBaseToughness() > 1 && !card.hasKeyword(Keyword.UNDYING);
        }
        if (keyword.equals("Landwalk:Plains")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getType(opp.getLandsInPlay(), "Plains").isEmpty() && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("Landwalk:Island")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getType(opp.getLandsInPlay(), "Island").isEmpty() && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("Landwalk:Swamp")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getType(opp.getLandsInPlay(), "Swamp").isEmpty() && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("Landwalk:Mountain")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getType(opp.getLandsInPlay(), "Mountain").isEmpty() && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("Landwalk:Forest")) {
            return !ph.isPlayerTurn(opp) && (combat != null && combat.isAttacking(card) || CombatUtil.canAttack(card, opp)) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && newPower > 0 && !CardLists.getType(opp.getLandsInPlay(), "Forest").isEmpty() && Iterables.any(opp.getCreaturesInPlay(), CardPredicates.possibleBlockers(card));
        }
        if (keyword.equals("Prevent all combat damage that would be dealt to CARDNAME.")) {
            return combat != null && (combat.isBlocking(card) || combat.isBlocked(card));
        }
        if (keyword.equals("Menace")) {
            return combat != null && combat.isAttacking(card);
        }
        return true;
    }

    protected CardCollection getPumpCreatures(Player ai, SpellAbility sa, int defense, int attack, List<String> keywords, boolean immediately) {
        CardCollection list = CardLists.getTargetableCards(ai.getCreaturesInPlay(), sa);
        list = CardLists.filter((Iterable<Card>)list, c -> ComputerUtilCard.shouldPumpCard(ai, sa, c, defense, attack, keywords, immediately));
        return list;
    }

    protected CardCollection getCurseCreatures(Player ai, SpellAbility sa, int defense, int attack, List<String> keywords) {
        CardCollection list = ai.getOpponents().getCardsIn(ZoneType.Battlefield);
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        if ((list = CardLists.getTargetableCards(list, sa)).isEmpty()) {
            return list;
        }
        if (defense < 0) {
            list = CardLists.filter((Iterable<Card>)list, c -> {
                if (c.getSVar("Targeting").equals("Dies") || c.getNetToughness() <= -defense) {
                    return true;
                }
                return ComputerUtilCombat.getDamageToKill(c, false) <= -defense && !c.hasKeyword(Keyword.INDESTRUCTIBLE);
            });
        } else if (attack < 0 && !game.getReplacementHandler().isPreventCombatDamageThisTurn()) {
            boolean isMyTurn = game.getPhaseHandler().isPlayerTurn(ai);
            list = isMyTurn ? (game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_BEGIN) ? new CardCollection() : new CardCollection()) : (game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS) ? CardLists.filter((Iterable<Card>)list, c -> {
                if (combat == null || !combat.isAttacking((Card)c)) {
                    return false;
                }
                if (c.getNetPower() > 0 && ai.getLife() < 5) {
                    return true;
                }
                return c.getNetPower() + attack > -2 || c.getNetPower() > 3;
            }) : new CardCollection());
        } else {
            boolean addsKeywords;
            boolean bl = addsKeywords = !keywords.isEmpty();
            if (addsKeywords) {
                if ((keywords.contains("CARDNAME can't attack.") || keywords.contains("CARDNAME can't attack or block.") || keywords.contains("HIDDEN CARDNAME can't attack.") || keywords.contains("HIDDEN CARDNAME can't attack or block.")) && CardLists.getNotType(list, "Creature").isEmpty()) {
                    list = ComputerUtilCard.prioritizeCreaturesWorthRemovingNow(ai, list, true);
                }
                list = CardLists.filter((Iterable<Card>)list, c -> this.containsUsefulKeyword(ai, keywords, (Card)c, sa, attack));
            } else if (sa.hasParam("NumAtt") || sa.hasParam("NumDef")) {
                list = new CardCollection();
            }
        }
        return list;
    }

    protected boolean containsNonCombatKeyword(List<String> keywords) {
        for (String keyword : keywords) {
            if (!keyword.endsWith("This card doesn't untap during your next untap step.") && !keyword.endsWith("Shroud") && !keyword.endsWith("Hexproof")) continue;
            return true;
        }
        return false;
    }
}

