/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpecialAiLogic;
import forge.ai.SpecialCardAi;
import forge.ai.ability.FightAi;
import forge.ai.ability.PumpAiBase;
import forge.ai.ability.SacrificeAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostTapType;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PumpAi
extends PumpAiBase {
    private static boolean hasTapCost(Cost cost, Card source) {
        if (cost == null) {
            return true;
        }
        return cost.hasSpecificCostType(CostTapType.class);
    }

    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        if ("MoveCounter".equals(aiLogic)) {
            Game game = ai.getGame();
            CardCollection tgtCards = CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.isTargetableBy(sa));
            if (tgtCards.isEmpty()) {
                return false;
            }
            AbilitySub moveSA = null;
            for (AbilitySub sub = sa.getSubAbility(); sub != null; sub = sub.getSubAbility()) {
                if (!ApiType.MoveCounter.equals((Object)sub.getApi())) continue;
                moveSA = sub;
                break;
            }
            if (moveSA == null) {
                System.err.println("MoveCounter AiLogic without MoveCounter SubAbility!");
                return false;
            }
        } else {
            if ("Aristocrat".equals(aiLogic)) {
                return SpecialAiLogic.doAristocratLogic(ai, sa);
            }
            if (aiLogic.startsWith("AristocratCounters")) {
                return SpecialAiLogic.doAristocratWithCountersLogic(ai, sa);
            }
            if (aiLogic.equals("SwitchPT") && sa.isActivatedAbility() && sa.getActivationsThisTurn() > 0 && !sa.usesTargeting()) {
                return false;
            }
        }
        return super.checkAiLogic(ai, sa, aiLogic);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph, String logic) {
        if (logic.equals("MoveCounter")) {
            if (ph.inCombat() && ph.getPlayerTurn().isOpponentOf(ai)) {
                return true;
            }
            return PumpAi.isSorcerySpeed(sa, ai) || ph.getNextTurn().equals(ai) && !ph.getPhase().isBefore(PhaseType.END_OF_TURN);
        }
        if (logic.equals("Aristocrat")) {
            boolean isThreatened = ComputerUtil.predictThreatenedObjects(ai, null, true).contains(sa.getHostCard());
            if (!ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS) && !isThreatened) {
                return false;
            }
        } else if (logic.equals("SwitchPT") && (ph.getPhase().isAfter(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE) || !ph.inCombat())) {
            return false;
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        boolean main1Preferred;
        Game game = ai.getGame();
        boolean bl = main1Preferred = "Main1IfAble".equals(sa.getParam("AILogic")) && ph.is(PhaseType.MAIN1, ai);
        if (game.getStack().isEmpty() && PumpAi.hasTapCost(sa.getPayCosts(), sa.getHostCard())) {
            if (ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && ph.isPlayerTurn(ai)) {
                return false;
            }
            if (ph.getPhase().isBefore(PhaseType.COMBAT_BEGIN) && ph.getPlayerTurn().isOpponentOf(ai)) {
                return false;
            }
        }
        if (game.getStack().isEmpty() && (ph.getPhase().isBefore(PhaseType.COMBAT_BEGIN) || ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS))) {
            return sa.isCurse() || PumpAi.isSorcerySpeed(sa, ai) || main1Preferred;
        }
        return true;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        int attack;
        int defense;
        Game game = ai.getGame();
        Card source = sa.getHostCard();
        SpellAbility root = sa.getRootAbility();
        ArrayList<String> keywords = sa.hasParam("KW") ? Arrays.asList(sa.getParam("KW").split(" & ")) : Lists.newArrayList();
        String numDefense = sa.getParamOrDefault("NumDef", "");
        String numAttack = sa.getParamOrDefault("NumAtt", "");
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        boolean isFight = "Fight".equals(aiLogic) || "PowerDmg".equals(aiLogic);
        boolean isBerserk = "Berserk".equals(aiLogic);
        if ("Pummeler".equals(aiLogic)) {
            return SpecialCardAi.ElectrostaticPummeler.consider(ai, sa);
        }
        if (aiLogic.startsWith("AristocratCounters")) {
            return true;
        }
        if ("GideonBlackblade".equals(aiLogic)) {
            return SpecialCardAi.GideonBlackblade.consider(ai, sa);
        }
        if ("MoveCounter".equals(aiLogic)) {
            SpellAbility moveSA = sa.findSubAbilityByType(ApiType.MoveCounter);
            if (moveSA == null) {
                return false;
            }
            String counterType = moveSA.getParam("CounterType");
            String amountStr = moveSA.getParamOrDefault("CounterNum", "1");
            CounterType cType = "Any".equals(counterType) ? null : CounterType.getType(counterType);
            PhaseHandler ph = game.getPhaseHandler();
            if (ph.inCombat() && ph.getPlayerTurn().isOpponentOf(ai)) {
                CardCollection attr = ph.getCombat().getAttackers();
                attr = CardLists.getTargetableCards(attr, sa);
                if (cType != null) {
                    if ((attr = CardLists.filter((Iterable<Card>)attr, CardPredicates.hasCounter(cType))).isEmpty()) {
                        return false;
                    }
                    CardCollection best = CardLists.filter((Iterable<Card>)attr, card -> {
                        int amount = 0;
                        if (StringUtils.isNumeric(amountStr)) {
                            amount = AbilityUtils.calculateAmount(source, amountStr, moveSA);
                        } else if (source.hasSVar(amountStr) && "Count$ChosenNumber".equals(source.getSVar(amountStr))) {
                            amount = card.getCounters(cType);
                        }
                        int i = card.getCounters(cType);
                        if (i < amount) {
                            return false;
                        }
                        Card srcCardCpy = CardCopyService.getLKICopy(card);
                        srcCardCpy.setCounters(cType, (Integer)(srcCardCpy.getCounters(cType) - amount));
                        if (cType.is(CounterEnumType.P1P1) && srcCardCpy.getNetToughness() <= 0) {
                            return srcCardCpy.getCounters(cType) > 0 || !card.hasKeyword(Keyword.UNDYING) || card.isToken();
                        }
                        return false;
                    });
                    if (best.isEmpty()) {
                        best = attr;
                    }
                    Card card2 = ComputerUtilCard.getBestCreatureAI(best);
                    sa.getTargets().add(card2);
                    return true;
                }
            } else {
                boolean sameCtrl = moveSA.getTargetRestrictions().isSameController();
                CardCollection list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
                if (cType != null) {
                    if ((list = CardLists.filter((Iterable<Card>)list, CardPredicates.hasCounter(cType))).isEmpty()) {
                        return false;
                    }
                    CardCollection oppList = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents());
                    if (!oppList.isEmpty() && !sameCtrl) {
                        CardCollection best = CardLists.filter((Iterable<Card>)oppList, card -> {
                            int amount = 0;
                            if (StringUtils.isNumeric(amountStr)) {
                                amount = AbilityUtils.calculateAmount(source, amountStr, moveSA);
                            } else if (source.hasSVar(amountStr) && "Count$ChosenNumber".equals(source.getSVar(amountStr))) {
                                amount = card.getCounters(cType);
                            }
                            int i = card.getCounters(cType);
                            if (i < amount) {
                                return false;
                            }
                            Card srcCardCpy = CardCopyService.getLKICopy(card);
                            srcCardCpy.setCounters(cType, (Integer)(srcCardCpy.getCounters(cType) - amount));
                            if (cType.is(CounterEnumType.P1P1) && srcCardCpy.getNetToughness() <= 0) {
                                return srcCardCpy.getCounters(cType) > 0 || !card.hasKeyword(Keyword.UNDYING) || card.isToken();
                            }
                            return true;
                        });
                        if (best.isEmpty()) {
                            best = oppList;
                        }
                        Card card3 = ComputerUtilCard.getBestCreatureAI(best);
                        sa.getTargets().add(card3);
                        return true;
                    }
                }
            }
        } else {
            if (aiLogic.startsWith("Donate")) {
                return SpecialCardAi.Donate.considerTargetingOpponent(ai, sa);
            }
            if (aiLogic.equals("InfernoOfTheStarMounts")) {
                int numRedMana = ComputerUtilMana.determineLeftoverMana(new SpellAbility.EmptySa(source), ai, "R", false);
                int currentPower = source.getNetPower();
                if (currentPower < 20 && currentPower + numRedMana >= 20) {
                    return true;
                }
            }
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (!(game.getStack().isEmpty() || sa.isCurse() || isFight)) {
            return ComputerUtilCard.canPumpAgainstRemoval(ai, sa);
        }
        if (sa.hasParam("ConditionActivationLimit")) {
            int sacActivations = Integer.parseInt(sa.getParam("ConditionActivationLimit").substring(2));
            int activations = sa.getActivationsThisTurn();
            if (activations >= sacActivations - 1) {
                return false;
            }
        }
        if (sa.getSVar("X").equals("Count$xPaid")) {
            root.setXManaCostPaid(null);
        }
        if (numDefense.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
            defense = xPay;
            if (numDefense.equals("-X")) {
                defense = -xPay;
            }
        } else {
            defense = AbilityUtils.calculateAmount(sa.getHostCard(), numDefense, sa);
            if (numDefense.contains("X") && sa.getSVar("X").equals("Count$CardsInYourHand") && source.isInZone(ZoneType.Hand)) {
                --defense;
            }
        }
        if (numAttack.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            if (root.getXManaCostPaid() == null) {
                int xPay = ComputerUtilCost.getMaxXValue(root, ai, sa.isTrigger());
                root.setXManaCostPaid(xPay);
                attack = xPay;
            } else {
                attack = root.getXManaCostPaid();
            }
        } else {
            attack = AbilityUtils.calculateAmount(sa.getHostCard(), numAttack, sa);
            if (numAttack.contains("X") && sa.getSVar("X").equals("Count$CardsInYourHand") && source.isInZone(ZoneType.Hand)) {
                --attack;
            }
        }
        if (numDefense.contains("X") && defense == 0 || numAttack.contains("X") && attack == 0 && !isBerserk) {
            return false;
        }
        if (!sa.usesTargeting()) {
            CardCollection cards = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            if (cards.isEmpty()) {
                return false;
            }
            for (Card card4 : cards) {
                if (sa.isCurse()) {
                    if (!card4.getController().isOpponentOf(ai)) {
                        return false;
                    }
                    if (!this.containsUsefulKeyword(ai, keywords, card4, sa, attack)) continue;
                    return true;
                }
                if (card4.getController().isOpponentOf(ai)) continue;
                if (ComputerUtilCard.shouldPumpCard(ai, sa, card4, defense, attack, keywords, false)) {
                    return true;
                }
                if (this.containsUsefulKeyword(ai, keywords, card4, sa, attack)) {
                    if (game.getPhaseHandler().is(PhaseType.MAIN1) && PumpAi.isSorcerySpeed(sa, ai) || game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_ATTACKERS, ai) || game.getPhaseHandler().is(PhaseType.COMBAT_BEGIN, ai)) {
                        Card pumped = ComputerUtilCard.getPumpedCreature(ai, sa, card4, 0, 0, keywords);
                        return ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, pumped);
                    }
                    return true;
                }
                if (!this.grantsUsefulExtraBlockOpts(ai, sa, card4, keywords)) continue;
                return true;
            }
            return false;
        }
        return this.pumpTgtAI(ai, sa, defense, attack, false, false);
    }

    private boolean pumpTgtAI(Player ai, SpellAbility sa, int defense, int attack, boolean mandatory, boolean immediately) {
        CardCollection list;
        ArrayList<String> keywords = sa.hasParam("KW") ? Arrays.asList(sa.getParam("KW").split(" & ")) : Lists.newArrayList();
        Game game = ai.getGame();
        Card source = sa.getHostCard();
        boolean isFight = "Fight".equals(sa.getParam("AILogic")) || "PowerDmg".equals(sa.getParam("AILogic"));
        boolean bl = immediately = immediately || ComputerUtil.playImmediately(ai, sa);
        if (!(mandatory || immediately || !game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) || "AnyPhase".equals(sa.getParam("AILogic")) || sa.isCurse() && defense < 0 || this.containsNonCombatKeyword(keywords) || "UntilYourNextTurn".equals(sa.getParam("Duration")) || "ReplaySpell".equals(sa.getParam("AILogic")) || isFight)) {
            return false;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        sa.resetTargets();
        if ("PowerStruggle".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.PowerStruggle.considerFirstTarget(ai, sa);
        }
        if (sa.hasParam("TargetingPlayer") && sa.getActivatingPlayer().equals(ai) && !sa.isTrigger()) {
            if (!ComputerUtilAbility.isFullyTargetable(sa)) {
                return false;
            }
            Player targetingPlayer = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("TargetingPlayer"), sa).get(false);
            sa.setTargetingPlayer(targetingPlayer);
            return targetingPlayer.getController().chooseTargetsFor(sa);
        }
        if (sa.hasParam("AILogic")) {
            if (sa.getParam("AILogic").equals("HighestPower") || sa.getParam("AILogic").equals("ContinuousBonus")) {
                CardCollection list2 = CardLists.getValidCards((Iterable<Card>)CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES), tgt.getValidTgts(), ai, source, (CardTraitBase)sa);
                list2 = CardLists.getTargetableCards(list2, sa);
                CardLists.sortByPowerDesc(list2);
                if (list2.contains(source) && source.hasKeyword("You may choose not to untap CARDNAME during your untap step.") && sa.getPayCosts().hasTapCost()) {
                    list2.remove(source);
                }
                CardCollection canDieToPump = new CardCollection();
                for (Card c : list2) {
                    if (c.isCreature() && c.getController() == ai && c.getNetToughness() - c.getTempToughnessBoost() + defense <= 0) {
                        canDieToPump.add(c);
                    }
                    if (!sa.getHostCard().equals(c) || !ComputerUtilCost.isSacrificeSelfCost(sa.getPayCosts())) continue;
                    canDieToPump.add(c);
                }
                list2.removeAll(canDieToPump);
                if ("ContinuousBonus".equals(sa.getParam("AILogic"))) {
                    list2 = CardLists.filter((Iterable<Card>)list2, CardPredicates.isController(ai));
                }
                if (!list2.isEmpty()) {
                    sa.getTargets().add((GameObject)list2.get(false));
                    return true;
                }
                return false;
            }
            if (sa.getParam("AILogic").equals("SameName")) {
                return this.doSameNameLogic(ai, sa);
            }
            if (sa.getParam("AILogic").equals("SacOneEach")) {
                return SacrificeAi.doSacOneEachLogic(ai, sa);
            }
            if (sa.getParam("AILogic").equals("Destroy")) {
                CardCollection tgts = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
                if (tgts.isEmpty()) {
                    return false;
                }
                CardCollection alliedTgts = CardLists.filter((Iterable<Card>)tgts, Predicates.or(CardPredicates.isControlledByAnyOf(ai.getAllies()), CardPredicates.isController(ai)));
                CardCollection oppTgts = CardLists.filter((Iterable<Card>)tgts, CardPredicates.isControlledByAnyOf(ai.getOpponents()));
                Card destroyTgt = null;
                destroyTgt = !oppTgts.isEmpty() ? ComputerUtilCard.getBestAI(oppTgts) : ComputerUtilCard.getWorstAI(alliedTgts);
                if (destroyTgt != null) {
                    sa.getTargets().add(destroyTgt);
                    return true;
                }
                return false;
            }
            if (isFight) {
                return FightAi.canFightAi(ai, sa, attack, defense);
            }
        }
        if (sa.isCurse()) {
            for (Player opp : ai.getOpponents()) {
                if (!sa.canTarget(opp)) continue;
                sa.getTargets().add(opp);
                return true;
            }
            list = this.getCurseCreatures(ai, sa, defense, attack, keywords);
        } else {
            if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
                return true;
            }
            if (tgt.canTgtCreature()) {
                list = this.getPumpCreatures(ai, sa, defense, attack, keywords, immediately);
            } else {
                ZoneType zone = tgt.getZone().get(0);
                list = CardLists.getTargetableCards(game.getCardsIn(zone), sa);
            }
        }
        if (game.getStack().isEmpty() && sa.getPayCosts().hasTapCost()) {
            if (game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && game.getPhaseHandler().isPlayerTurn(ai)) {
                list.remove(sa.getHostCard());
            }
            if (game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS) && game.getPhaseHandler().getPlayerTurn().isOpponentOf(ai)) {
                list.remove(sa.getHostCard());
            }
        }
        if ("DetainNonLand".equals(sa.getParam("AILogic"))) {
            list = CardLists.filter((Iterable<Card>)list, Predicates.or(CardPredicates.Presets.CREATURES, card -> {
                for (SpellAbility sa1 : card.getSpellAbilities()) {
                    if (!sa1.isActivatedAbility()) continue;
                    return true;
                }
                return false;
            }));
        }
        if ((list = ComputerUtil.filterAITgts(sa, ai, list, true)).isEmpty() && (mandatory || ComputerUtil.activateForCost(sa, ai))) {
            return this.pumpMandatoryTarget(ai, sa);
        }
        if (!sa.isCurse()) {
            list = ComputerUtil.getSafeTargets(ai, sa, list);
        }
        if ("BetterCreatureThanSource".equals(sa.getParam("AILogic"))) {
            int sourceValue = ComputerUtilCard.evaluateCreature(source);
            list = CardLists.filter((Iterable<Card>)list, card -> card.isCreature() && ComputerUtilCard.evaluateCreature(card) > sourceValue + 30);
        }
        if ("ReplaySpell".equals(sa.getParam("AILogic")) && !ComputerUtil.targetPlayableSpellCard(ai, list, sa, false, mandatory)) {
            return false;
        }
        while (sa.canAddMoreTarget()) {
            Card t2 = null;
            if (list.isEmpty()) {
                if (sa.isMinTargetChosen() && !sa.isZeroTargets()) break;
                if (mandatory || ComputerUtil.activateForCost(sa, ai)) {
                    return this.pumpMandatoryTarget(ai, sa);
                }
                sa.resetTargets();
                return false;
            }
            t2 = ComputerUtilCard.getBestAI(list);
            if (!immediately && tgt.getMaxTargets(source, sa) == 1 && sa.isCurse() && defense < 0 && !ComputerUtilCard.useRemovalNow(sa, t2, -defense, ZoneType.Graveyard) && !ComputerUtil.activateForCost(sa, ai)) {
                return false;
            }
            sa.getTargets().add(t2);
            list.remove(t2);
        }
        return true;
    }

    private boolean pumpMandatoryTarget(Player ai, SpellAbility sa) {
        Card c;
        CardCollection forced;
        CardCollection pref;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        List<Card> list = CardUtil.getValidCardsToTarget(sa);
        if (list.size() < tgt.getMinTargets(sa.getHostCard(), sa)) {
            sa.resetTargets();
            return false;
        }
        if (sa.isCurse()) {
            pref = CardLists.filterControlledBy(list, ai.getOpponents());
            forced = CardLists.filterControlledBy(list, ai.getYourTeam());
        } else {
            pref = CardLists.filterControlledBy(list, ai.getYourTeam());
            forced = CardLists.filterControlledBy(list, ai.getOpponents());
        }
        while (sa.canAddMoreTarget() && !pref.isEmpty()) {
            c = ComputerUtilCard.getBestAI(pref);
            pref.remove(c);
            sa.getTargets().add(c);
        }
        while (!sa.isMinTargetChosen() && !forced.isEmpty()) {
            c = CardLists.getNotType(forced, "Creature").isEmpty() ? ComputerUtilCard.getWorstCreatureAI(forced) : ComputerUtilCard.getCheapestPermanentAI(forced, sa, false);
            forced.remove(c);
            sa.getTargets().add(c);
        }
        if (!sa.isMinTargetChosen()) {
            sa.resetTargets();
            return false;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        int attack;
        int defense;
        SpellAbility root = sa.getRootAbility();
        String numDefense = sa.getParamOrDefault("NumDef", "");
        String numAttack = sa.getParamOrDefault("NumAtt", "");
        if (sa.getSVar("X").equals("Count$xPaid")) {
            sa.setXManaCostPaid(null);
        }
        if (numDefense.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            if (root.getXManaCostPaid() == null) {
                int xPay = ComputerUtilCost.getMaxXValue(root, ai, true);
                root.setXManaCostPaid(xPay);
                defense = xPay;
            } else {
                defense = root.getXManaCostPaid();
            }
        } else {
            defense = AbilityUtils.calculateAmount(sa.getHostCard(), numDefense, sa);
        }
        if (numAttack.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            if (root.getXManaCostPaid() == null) {
                int xPay = ComputerUtilCost.getMaxXValue(root, ai, true);
                root.setXManaCostPaid(xPay);
                attack = xPay;
            } else {
                attack = root.getXManaCostPaid();
            }
        } else {
            attack = AbilityUtils.calculateAmount(sa.getHostCard(), numAttack, sa);
        }
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
        } else {
            return this.pumpTgtAI(ai, sa, defense, attack, mandatory, true);
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        int defense;
        int attack;
        SpellAbility root = sa.getRootAbility();
        Card source = sa.getHostCard();
        String numDefense = sa.getParamOrDefault("NumDef", "");
        String numAttack = sa.getParamOrDefault("NumAtt", "");
        if (numDefense.equals("-X") && sa.getSVar("X").equals("Count$ChosenNumber")) {
            int energy = ai.getCounters(CounterEnumType.ENERGY);
            for (SpellAbility s2 : source.getSpellAbilities()) {
                if (!"PayEnergy".equals(s2.getParam("AILogic"))) continue;
                energy += AbilityUtils.calculateAmount(source, s2.getParam("CounterNum"), sa);
                break;
            }
            int minus = 0;
            while (energy > 0) {
                if (this.pumpTgtAI(ai, sa, -energy, -energy, false, true) && (minus = sa.getTargetCard().getNetToughness()) <= energy && minus >= 1) {
                    root.setSVar("EnergyToPay", "Number$" + minus);
                    return true;
                }
                --energy;
            }
            return false;
        }
        if (numAttack.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            if (root.getXManaCostPaid() == null) {
                int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                root.setXManaCostPaid(xPay);
                attack = xPay;
            } else {
                attack = root.getXManaCostPaid();
            }
        } else {
            attack = AbilityUtils.calculateAmount(sa.getHostCard(), numAttack, sa);
        }
        if (numDefense.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            if (root.getXManaCostPaid() == null) {
                int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                root.setXManaCostPaid(xPay);
                defense = xPay;
            } else {
                defense = root.getXManaCostPaid();
            }
        } else {
            defense = AbilityUtils.calculateAmount(sa.getHostCard(), numDefense, sa);
        }
        if (sa.usesTargeting()) {
            return this.pumpTgtAI(ai, sa, defense, attack, false, true);
        }
        if (source.isCreature()) {
            if (!source.hasKeyword(Keyword.INDESTRUCTIBLE) && source.getNetToughness() + defense <= source.getDamage()) {
                return false;
            }
            return source.getNetToughness() + defense > 0;
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    private boolean doSameNameLogic(Player aiPlayer, SpellAbility sa) {
        Game game = aiPlayer.getGame();
        Card source = sa.getHostCard();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        ZoneType origin = ZoneType.listValueOf(sa.getSubAbility().getParam("Origin")).get(0);
        CardCollection list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(origin), tgt.getValidTgts(), aiPlayer, source, (CardTraitBase)sa);
        if ((list = CardLists.filterControlledBy((Iterable<Card>)list, aiPlayer.getOpponents())).isEmpty()) {
            return false;
        }
        HashMap data = Maps.newHashMap();
        for (Player opp : aiPlayer.getOpponents()) {
            CardCollection oppList = CardLists.filterControlledBy((Iterable<Card>)list, opp);
            if (oppList.isEmpty()) continue;
            Map<String, Integer> values = ComputerUtilCard.evaluateCreatureListByName(oppList);
            if ((oppList = CardLists.filter((Iterable<Card>)oppList, CardPredicates.isTargetableBy(sa))).isEmpty()) continue;
            ArrayList<String> toRemove = Lists.newArrayList();
            for (String name : values.keySet()) {
                if (Iterables.any(oppList, CardPredicates.nameEquals(name))) continue;
                toRemove.add(name);
            }
            values.keySet().removeAll(toRemove);
            data.put(opp, Collections.max(values.entrySet(), Map.Entry.comparingByValue()));
        }
        if (!data.isEmpty()) {
            Map.Entry max = Collections.max(data.entrySet(), Comparator.comparingInt(o -> (Integer)((Map.Entry)o.getValue()).getValue()));
            list = CardLists.filter(CardLists.filterControlledBy((Iterable<Card>)list, (Player)max.getKey()), CardPredicates.nameEquals((String)((Map.Entry)max.getValue()).getKey()), CardPredicates.isTargetableBy(sa));
            sa.resetTargets();
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                Card c = (Card)iterator.next();
                sa.getTargets().add(c);
                return true;
            }
        }
        return false;
    }
}

