/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Collection;
import java.util.Map;

public class PhasesAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        boolean randomReturn;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Card source = sa.getHostCard();
        boolean bl = randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        if (tgt == null) {
            CardCollection tgtCards = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            if (tgtCards.contains(source)) {
                boolean isThreatened = ComputerUtil.predictThreatenedObjects(aiPlayer, null, true).contains(source);
                return isThreatened;
            }
            return false;
        }
        if (!this.phasesPrefTargeting(tgt, sa, false)) {
            return false;
        }
        return randomReturn;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt == null) {
            return mandatory;
        }
        if (this.phasesPrefTargeting(tgt, sa, mandatory)) {
            return true;
        }
        if (mandatory) {
            return sa.isTargetNumberValid() || this.phasesUnpreferredTargeting(aiPlayer.getGame(), sa, mandatory);
        }
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        TargetRestrictions tgt = sa.getTargetRestrictions();
        boolean randomReturn = true;
        if (tgt != null && !this.phasesPrefTargeting(tgt, sa, false)) {
            return false;
        }
        return randomReturn;
    }

    private boolean phasesPrefTargeting(TargetRestrictions tgt, SpellAbility sa, boolean mandatory) {
        return false;
    }

    private boolean phasesUnpreferredTargeting(Game game, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        CardCollection list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
        if (!list.isEmpty()) {
            CardCollection oppList = CardLists.filter((Iterable<Card>)list, Predicates.not(CardPredicates.isController(source.getController())));
            sa.resetTargets();
            sa.getTargets().add(!oppList.isEmpty() ? ComputerUtilCard.getBestAI(oppList) : ComputerUtilCard.getWorstAI(list));
            return true;
        }
        return false;
    }

    @Override
    public <T extends GameEntity> T chooseSingleEntity(Player ai, SpellAbility sa, Collection<T> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        if ("DontPhaseOut".equals(sa.getParam("AILogic"))) {
            return null;
        }
        return super.chooseSingleEntity(ai, sa, options, isOptional, targetedPlayer, params);
    }
}

