/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class MutateAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        CardCollection mutateTgts = CardLists.getTargetableCards(aiPlayer.getCreaturesInPlay(), sa);
        mutateTgts = ComputerUtil.getSafeTargets(aiPlayer, sa, mutateTgts);
        if ((mutateTgts = CardLists.filter((Iterable<Card>)mutateTgts, Predicates.not(Predicates.or(CardPredicates.hasKeyword(Keyword.DEFENDER), CardPredicates.hasKeyword("CARDNAME can't attack."), CardPredicates.hasKeyword("CARDNAME can't block."), card -> ComputerUtilCard.isUselessCreature(aiPlayer, card))))).isEmpty()) {
            return false;
        }
        Card mutateTgt = ComputerUtilCard.getBestCreatureAI(mutateTgts);
        sa.getTargets().add(mutateTgt);
        return true;
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        Card choice = null;
        for (Card c : options) {
            if (choice != null && c.getBasePower() <= choice.getBasePower() && c.getBaseToughness() <= choice.getBaseToughness()) continue;
            choice = c;
        }
        return choice;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }
}

