/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Map;

public abstract class ManifestBaseAi
extends SpellAbilityAi {
    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        if (ph.isPlayerTurn(ai)) {
            if (ph.getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !ComputerUtil.castSpellInMain1(ai, sa)) {
                boolean buff = false;
                for (Card c : ai.getCardsIn(ZoneType.Battlefield)) {
                    if (!"Creature".equals(c.getSVar("BuffedBy"))) continue;
                    buff = true;
                }
                if (!buff) {
                    return false;
                }
            } else if (!ManifestBaseAi.isSorcerySpeed(sa, ai)) {
                return false;
            }
        } else if (ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            return false;
        }
        if (sa.getSVar("X").equals("Count$xPaid")) {
            int x = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(x);
            if (x <= 0) {
                return false;
            }
        }
        return true;
    }

    protected abstract boolean shouldApply(Card var1, Player var2, SpellAbility var3);

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        Card host = sa.getHostCard();
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (sa.hasParam("Choices") || sa.hasParam("ChoiceZone")) {
            ZoneType choiceZone = ZoneType.Hand;
            if (sa.hasParam("ChoiceZone")) {
                choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
            }
            CardCollection choices = new CardCollection(game.getCardsIn(choiceZone));
            if (sa.hasParam("Choices")) {
                choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), ai, host, (CardTraitBase)sa);
            }
            if (choices.isEmpty()) {
                return false;
            }
        } else if ("TopOfLibrary".equals(sa.getParamOrDefault("Defined", "TopOfLibrary"))) {
            CardCollectionView library = ai.getCardsIn(ZoneType.Library);
            if (library.isEmpty()) {
                return false;
            }
            if (library.size() < 5 && !ai.isCardInPlay("Laboratory Maniac")) {
                return false;
            }
            if (!this.shouldApply((Card)library.getFirst(), ai, sa)) {
                return false;
            }
        }
        if (ManifestBaseAi.playReusable(ai, sa)) {
            return true;
        }
        if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            return true;
        }
        if (sa.isAbility()) {
            return true;
        }
        return (double)MyRandom.getRandom().nextFloat() < 0.8;
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        if (Iterables.size(options) > 1 || isOptional) {
            CardCollection filtered = CardLists.filter(options, input -> this.shouldApply((Card)input, ai, sa));
            if (!filtered.isEmpty()) {
                return ComputerUtilCard.getBestAI(filtered);
            }
            if (isOptional) {
                return null;
            }
        }
        return Iterables.getFirst(options, null);
    }
}

