/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostSacrifice;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.util.MyRandom;

public class LifeGainAi
extends SpellAbilityAi {
    @Override
    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        boolean lifeCritical;
        Game game = source.getGame();
        PhaseHandler ph = game.getPhaseHandler();
        int life = ai.getLife();
        boolean bl = lifeCritical = life <= 5 || ph.getPhase().isBefore(PhaseType.COMBAT_DAMAGE) && ComputerUtilCombat.lifeInDanger(ai, game.getCombat());
        if (!lifeCritical) {
            if (!ComputerUtilCost.checkSacrificeCost(ai, cost, source, sa, false)) {
                return false;
            }
            if (!ComputerUtilCost.checkLifeCost(ai, cost, source, 4, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkDiscardCost(ai, cost, source, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkRemoveCounterCost(cost, source, sa)) {
                return false;
            }
        } else if (!ph.getPhase().equals((Object)PhaseType.COMBAT_DECLARE_BLOCKERS) || !game.getCombat().getDefenders().contains(ai)) {
            boolean skipCheck = false;
            if (!(skipCheck |= ComputerUtilCost.isSacrificeSelfCost(cost) && !source.isCreature()) && !ComputerUtilCost.checkSacrificeCost(ai, cost, source, sa, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        Game game = ai.getGame();
        int life = ai.getLife();
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        boolean activateForCost = ComputerUtil.activateForCost(sa, ai);
        boolean lifeCritical = life <= 5;
        if ((lifeCritical |= ph.getPhase().isBefore(PhaseType.COMBAT_DAMAGE) && ComputerUtilCombat.lifeInDanger(ai, game.getCombat())) && sa.isAbility() && sa.getHostCard() != null && sa.getHostCard().isCreature() && (sa.getPayCosts().hasSpecificCostType(CostRemoveCounter.class) || sa.getPayCosts().hasSpecificCostType(CostSacrifice.class))) {
            SpellAbility saTop;
            if (!game.getStack().isEmpty() && (saTop = game.getStack().peekAbility()).getTargets() != null && Iterables.contains(saTop.getTargets().getTargetPlayers(), ai)) {
                return ComputerUtil.predictDamageFromSpell(saTop, ai) > 0;
            }
            if (!ph.inCombat()) {
                return false;
            }
            if (!ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                return false;
            }
        }
        boolean isSacCost = false;
        if (sa.getPayCosts() != null && sa.getPayCosts().hasSpecificCostType(CostSacrifice.class)) {
            isSacCost = true;
        }
        if (!(lifeCritical || !ph.getPhase().isBefore(PhaseType.MAIN2) || sa.hasParam("ActivationPhases") || ComputerUtil.castSpellInMain1(ai, sa) || aiLogic.contains("AnyPhase") || isSacCost)) {
            return false;
        }
        return lifeCritical || activateForCost || ph.getNextTurn().equals(ai) && !ph.getPhase().isBefore(PhaseType.END_OF_TURN) || sa.hasParam("PlayerTurn") || LifeGainAi.isSorcerySpeed(sa, ai);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        int life = ai.getLife();
        String amountStr = sa.getParam("LifeAmount");
        int lifeAmount = 0;
        boolean activateForCost = ComputerUtil.activateForCost(sa, ai);
        if (sourceName.equals("Dawnglow Infusion") || amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
            lifeAmount = xPay;
        } else {
            lifeAmount = AbilityUtils.calculateAmount(source, amountStr, sa);
        }
        if (sourceName.equals("Ugin, the Spirit Dragon")) {
            return true;
        }
        if (!activateForCost && lifeAmount <= 0) {
            return false;
        }
        if (!activateForCost && !sa.metConditions()) {
            AbilitySub abSub = sa.getSubAbility();
            if (abSub != null && !sa.isWrapper() && "True".equals(source.getSVar("AIPlayForSub"))) {
                if (!abSub.getConditions().areMet(abSub)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!activateForCost && !ai.canGainLife()) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (sa.usesTargeting() && !this.target(ai, sa, true)) {
            return false;
        }
        if (ComputerUtil.playImmediately(ai, sa)) {
            return true;
        }
        if (LifeGainAi.isSorcerySpeed(sa, ai) || sa.getSubAbility() != null || LifeGainAi.playReusable(ai, sa)) {
            return true;
        }
        if (sa.getPayCosts() != null && sa.getPayCosts().hasSpecificCostType(CostSacrifice.class)) {
            return true;
        }
        float value = 0.9f * (float)lifeAmount / (float)life;
        if (value < 0.2f) {
            return false;
        }
        return MyRandom.getRandom().nextFloat() < value;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting() && !this.target(ai, sa, mandatory)) {
            return false;
        }
        String amountStr = sa.getParam("LifeAmount");
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, true);
            sa.setXManaCostPaid(xPay);
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.doTriggerAINoCost(ai, sa, true);
    }

    private boolean target(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        sa.resetTargets();
        PlayerCollection opps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        PlayerCollection allies = ai.getAllies().filter(PlayerPredicates.isTargetableBy(sa));
        if (!sa.canTarget(ai) || !ComputerUtil.lifegainPositive(ai, source)) {
            boolean hasTgt = false;
            for (Player opp : opps) {
                if (!ComputerUtil.lifegainNegative(opp, source)) continue;
                sa.getTargets().add(opp);
                hasTgt = true;
                break;
            }
            if (!hasTgt) {
                for (Player ally : allies) {
                    if (!ComputerUtil.lifegainPositive(ally, source)) continue;
                    sa.getTargets().add(ally);
                    hasTgt = true;
                    break;
                }
            }
            if (!hasTgt && mandatory) {
                for (Player ally : allies) {
                    if (ComputerUtil.lifegainNegative(ally, source)) continue;
                    sa.getTargets().add(ally);
                    hasTgt = true;
                    break;
                }
                if (!hasTgt) {
                    for (Player opp : opps) {
                        if (ComputerUtil.lifegainPositive(opp, source)) continue;
                        sa.getTargets().add(opp);
                        hasTgt = true;
                        break;
                    }
                }
                if (!allies.isEmpty()) {
                    Player ally = allies.max(PlayerPredicates.compareByLife());
                    sa.getTargets().add(ally);
                    hasTgt = true;
                }
                if (!hasTgt) {
                    Player opp = opps.max(PlayerPredicates.compareByLife());
                    sa.getTargets().add(opp);
                    hasTgt = true;
                }
            }
            return hasTgt;
        }
        sa.getTargets().add(ai);
        return true;
    }
}

