/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class LearnAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        return mandatory || this.canPlayAI(aiPlayer, sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return this.canPlayAI(aiPlayer, sa);
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    public static Card chooseCardToLearn(CardCollection options, Player ai, SpellAbility sa) {
        CardCollection sideboard = CardLists.filter((Iterable<Card>)options, CardPredicates.inZone(ZoneType.Sideboard));
        CardCollection hand = CardLists.filter((Iterable<Card>)options, CardPredicates.inZone(ZoneType.Hand));
        hand.remove(sa.getHostCard());
        CardCollection lessons = CardLists.getType(sideboard, "Lesson");
        CardCollection goodDiscards = ((PlayerControllerAi)ai.getController()).getAi().getCardsToDiscard(1, 1, hand, sa);
        if (!lessons.isEmpty()) {
            return ComputerUtilCard.getBestAI(lessons);
        }
        if (goodDiscards != null && !goodDiscards.isEmpty()) {
            return ComputerUtilCard.getWorstAI(goodDiscards);
        }
        return null;
    }
}

