/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiCardMemory;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCombat;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.combat.Combat;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.List;

public class FogAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        Card hostCard = sa.getHostCard();
        Combat combat = game.getCombat();
        if (game.getReplacementHandler().isPreventCombatDamageThisTurn()) {
            return false;
        }
        if (this.handleMemoryCheck(ai, sa)) {
            return true;
        }
        if (!game.getStack().isEmpty()) {
            return false;
        }
        if (combat == null) {
            return false;
        }
        if (!game.getPhaseHandler().getPlayerTurn().isOpponentOf(ai) || !game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            return false;
        }
        int remainingLife = ComputerUtilCombat.lifeThatWouldRemain(ai, combat);
        int dmg = ai.getLife() - remainingLife;
        int fogs = this.countAvailableFogs(ai);
        if (fogs > 2 && dmg > 2) {
            return true;
        }
        if (dmg > 2 && hostCard.hasKeyword(Keyword.BUYBACK) && CardLists.count(ai.getCardsIn(ZoneType.Battlefield), Card::isLand) > 3) {
            return true;
        }
        if ("SeriousDamage".equals(sa.getParam("AILogic"))) {
            if (dmg > ai.getLife() / 4) {
                return true;
            }
            if (dmg >= 5) {
                return true;
            }
            if (ai.getLife() < ai.getStartingLife() / 3) {
                return true;
            }
        }
        return ComputerUtilCombat.lifeInDanger(ai, game.getCombat());
    }

    private boolean handleMemoryCheck(Player ai, SpellAbility sa) {
        boolean reserved;
        List<GameObject> objects;
        Card hostCard = sa.getHostCard();
        Game game = ai.getGame();
        if (AiCardMemory.isRememberedCard(ai, hostCard, AiCardMemory.MemorySet.CHOSEN_FOG_EFFECT) && !game.getStack().isEmpty() && !game.getPhaseHandler().isPlayerTurn(sa.getActivatingPlayer()) && (objects = ComputerUtil.predictThreatenedObjects(ai, null)).contains(hostCard)) {
            AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_ENEMY_DECLBLK);
            return true;
        }
        if ((game.getPhaseHandler().isPlayerTurn(sa.getActivatingPlayer()) || game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) && AiCardMemory.isMemorySetEmpty(ai, AiCardMemory.MemorySet.CHOSEN_FOG_EFFECT) && ComputerUtil.aiLifeInDanger(ai, false, 0) && (reserved = ((PlayerControllerAi)ai.getController()).getAi().reserveManaSources(sa, PhaseType.COMBAT_DECLARE_BLOCKERS, true))) {
            AiCardMemory.rememberCard(ai, hostCard, AiCardMemory.MemorySet.CHOSEN_FOG_EFFECT);
        }
        return false;
    }

    private int countAvailableFogs(Player ai) {
        int fogs = 0;
        block0: for (Card c : ai.getCardsActivatableInExternalZones(false)) {
            for (SpellAbility ability : c.getSpellAbilities()) {
                if (!ApiType.Fog.equals((Object)ability.getApi())) continue;
                ++fogs;
                continue block0;
            }
        }
        block2: for (Card c : ai.getCardsIn(ZoneType.Hand)) {
            for (SpellAbility ability : c.getSpellAbilities()) {
                if (!ApiType.Fog.equals((Object)ability.getApi())) continue;
                ++fogs;
                continue block2;
            }
        }
        return fogs;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        Game game = ai.getGame();
        boolean chance = ai.isOpponentOf(game.getPhaseHandler().getPlayerTurn()) ? game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE) : game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DAMAGE);
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        Game game = aiPlayer.getGame();
        boolean chance = game.getPhaseHandler().isPlayerTurn(sa.getActivatingPlayer().getWeakestOpponent()) ? game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE) : game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DAMAGE);
        return chance || mandatory;
    }
}

