/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class FlipACoinAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        if (sa.hasParam("AILogic")) {
            String ailogic = sa.getParam("AILogic");
            if (ailogic.equals("Never")) {
                return false;
            }
            if (ailogic.equals("PhaseOut")) {
                if (!ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa).contains(sa.getHostCard())) {
                    return false;
                }
            } else {
                if (ailogic.equals("Bangchuckers")) {
                    if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.END_OF_TURN)) {
                        return false;
                    }
                    sa.resetTargets();
                    for (Player o : ai.getOpponents()) {
                        if (!sa.canTarget(o) || !o.canLoseLife() || o.cantLoseForZeroOrLessLife()) continue;
                        sa.getTargets().add(o);
                        return true;
                    }
                    for (Card c : ai.getOpponents().getCreaturesInPlay()) {
                        if (!sa.canTarget(c)) continue;
                        sa.getTargets().add(c);
                        return true;
                    }
                    return false;
                }
                if (ailogic.equals("KillOrcs")) {
                    if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.END_OF_TURN)) {
                        return false;
                    }
                    sa.resetTargets();
                    for (Card c : ai.getOpponents().getCreaturesInPlay()) {
                        if (!sa.canTarget(c)) continue;
                        sa.getTargets().add(c);
                        return true;
                    }
                    return false;
                }
            }
        }
        return sa.isTargetNumberValid();
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.canPlayAI(ai, sa);
    }
}

