/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiCostDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostPart;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostSacrifice;
import forge.game.cost.PaymentDecision;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.GameLossReason;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class DrawAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Player player;
        if (!this.targetAI(ai, sa, false)) {
            return false;
        }
        if (sa.usesTargeting() && (player = sa.getTargets().getFirstTargetedPlayer()) != null && player.isOpponentOf(ai)) {
            return true;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (ComputerUtil.playImmediately(ai, sa)) {
            return true;
        }
        if (ComputerUtil.waitForBlocking(sa)) {
            return false;
        }
        return this.canLoot(ai, sa);
    }

    @Override
    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        if (!ComputerUtilCost.checkCreatureSacrificeCost(ai, cost, source, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkLifeCost(ai, cost, source, 4, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkDiscardCost(ai, cost, source, sa)) {
            AiCostDecision aiDecisions = new AiCostDecision(ai, sa, false);
            for (CostPart part : cost.getCostParts()) {
                if (!(part instanceof CostDiscard)) continue;
                PaymentDecision decision = part.accept(aiDecisions);
                if (null == decision) {
                    return false;
                }
                for (Card discard : decision.cards) {
                    if (ComputerUtil.isWorseThanDraw(ai, discard)) continue;
                    return false;
                }
            }
        }
        return ComputerUtilCost.checkRemoveCounterCost(cost, source, sa);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        boolean isSacCost = false;
        if (sa.getPayCosts() != null && sa.getPayCosts().hasSpecificCostType(CostSacrifice.class)) {
            isSacCost = true;
        }
        if (ph.getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !ComputerUtil.castSpellInMain1(ai, sa) && !isSacCost) {
            return false;
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph, String logic) {
        if (logic.equals("VeilOfSummer")) {
            return SpecialCardAi.VeilOfSummer.consider(ai, sa);
        }
        if (logic.startsWith("LifeLessThan.")) {
            return true;
        }
        if (logic.equals("AtOppEOT")) {
            return ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai);
        }
        if (logic.equals("RespondToOwnActivation")) {
            return !ai.getGame().getStack().isEmpty() && ai.getGame().getStack().peekAbility().getHostCard().equals(sa.getHostCard());
        }
        if (!(ph.getNextTurn().equals(ai) && !ph.getPhase().isBefore(PhaseType.END_OF_TURN) || sa.hasParam("PlayerTurn") || DrawAi.isSorcerySpeed(sa, ai) || ai.getCardsIn(ZoneType.Hand).size() <= 1 || ComputerUtil.activateForCost(sa, ai) || "YawgmothsBargain".equals(logic))) {
            return false;
        }
        return super.checkPhaseRestrictions(ai, sa, ph, logic);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.targetAI(ai, sa, sa.isTrigger() && sa.getHostCard().isInPlay());
    }

    private boolean canLoot(Player ai, SpellAbility sa) {
        SpellAbility sub = sa.findSubAbilityByType(ApiType.Discard);
        if (sub != null) {
            Card source = sa.getHostCard();
            String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
            int numHand = ai.getCardsIn(ZoneType.Hand).size();
            if ("Jace, Vryn's Prodigy".equals(sourceName) && ai.getCardsIn(ZoneType.Graveyard).size() > 3) {
                return !ai.isCardInPlay("Jace, Telepath Unbound");
            }
            if (source.isSpell() && ai.getCardsIn(ZoneType.Hand).contains(source)) {
                --numHand;
            }
            int numDraw = 1;
            if (sa.hasParam("NumCards")) {
                String numDrawStr = sa.getParam("NumCards");
                numDraw = numDrawStr.equals("X") && sa.getSVar(numDrawStr).equals("Count$Converge") ? ComputerUtilMana.getConvergeCount(sa, ai) : AbilityUtils.calculateAmount(source, numDrawStr, sa);
            }
            int numDiscard = 1;
            if (sub.hasParam("NumCards")) {
                numDiscard = AbilityUtils.calculateAmount(source, sub.getParam("NumCards"), sub);
            }
            if (numHand == 0 && numDraw == numDiscard) {
                return false;
            }
            if (numHand + numDraw < numDiscard) {
                return false;
            }
        }
        return true;
    }

    private boolean targetAI(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        String logic = sa.getParamOrDefault("AILogic", "");
        boolean considerPrimary = logic.equals("ConsiderPrimary");
        boolean drawback = sa.getParent() != null && !considerPrimary;
        boolean assumeSafeX = false;
        int computerHandSize = ai.getCardsIn(ZoneType.Hand).size();
        int computerLibrarySize = ai.getCardsIn(ZoneType.Library).size();
        int computerMaxHandSize = ai.getMaxHandSize();
        SpellAbility root = sa.getRootAbility();
        SpellAbility gainLife = sa.findSubAbilityByType(ApiType.GainLife);
        SpellAbility loseLife = sa.findSubAbilityByType(ApiType.LoseLife);
        SpellAbility getPoison = sa.findSubAbilityByType(ApiType.Poison);
        if (sa.isSpell() && source.isInZone(ZoneType.Hand)) {
            --computerHandSize;
        }
        int numCards = 1;
        if (sa.hasParam("NumCards")) {
            numCards = AbilityUtils.calculateAmount(source, sa.getParam("NumCards"), sa);
        }
        boolean xPaid = false;
        String num = sa.getParam("NumCards");
        if (num != null && num.equals("X")) {
            if (sa.getSVar(num).equals("Count$xPaid")) {
                if (drawback && root.getXManaCostPaid() != null) {
                    numCards = root.getXManaCostPaid();
                } else {
                    numCards = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                    int safeDraw = Math.abs(Math.min(computerMaxHandSize - computerHandSize, computerLibrarySize - 3));
                    if (source.isInstant() || source.isSorcery()) {
                        ++safeDraw;
                    }
                    if (sa.getPayCosts().hasSpecificCostType(CostPayLife.class)) {
                        boolean aggroAI = ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.PLAY_AGGRO);
                        for (numCards = Math.min(numCards, safeDraw); ComputerUtil.aiLifeInDanger(ai, aggroAI, numCards) && numCards > 0; --numCards) {
                        }
                    }
                    root.setXManaCostPaid(numCards);
                    assumeSafeX = true;
                }
                xPaid = true;
            } else if (sa.getSVar(num).equals("Count$Converge")) {
                numCards = ComputerUtilMana.getConvergeCount(sa, ai);
            }
        }
        if ("YawgmothsBargain".equals(logic)) {
            return SpecialCardAi.YawgmothsBargain.consider(ai, sa);
        }
        if (sa.usesTargeting()) {
            boolean aiTarget;
            sa.resetTargets();
            if (numCards == 0 && !mandatory && !drawback) {
                return false;
            }
            PlayerCollection players = game.getPlayers().filter(PlayerPredicates.isTargetableBy(sa));
            if (players.isEmpty()) {
                return false;
            }
            PlayerCollection opps = players.filter(PlayerPredicates.isOpponentOf(ai));
            for (Object oppA : opps) {
                if (sa.isCurse() && ai.canDraw() && ((Player)oppA).canLoseLife()) {
                    if (numCards >= computerLibrarySize - 3) {
                        if (ai.isCardInPlay("Laboratory Maniac")) {
                            sa.getTargets().add((GameObject)oppA);
                            return true;
                        }
                    } else if (computerHandSize + numCards <= computerMaxHandSize) {
                        sa.getTargets().add((GameObject)oppA);
                        return true;
                    }
                }
                if (((Player)oppA).cantLoseCheck(GameLossReason.Milled) || !((Player)oppA).canDraw()) continue;
                if (numCards >= ((Player)oppA).getCardsIn(ZoneType.Library).size()) {
                    if (((Player)oppA).isCardInPlay("Laboratory Maniac")) continue;
                    sa.getTargets().add((GameObject)oppA);
                    return true;
                }
                if (loseLife != null && ((Player)oppA).canLoseLife() && loseLife.hasParam("Defined") && "Targeted".equals(loseLife.getParam("Defined")) && numCards >= ((Player)oppA).getLife()) {
                    if (xPaid) {
                        root.setXManaCostPaid(((Player)oppA).getLife());
                    }
                    sa.getTargets().add((GameObject)oppA);
                    return true;
                }
                if (gainLife != null && ((Player)oppA).canGainLife() && ((Player)oppA).canLoseLife() && ComputerUtil.lifegainNegative((Player)oppA, source) && gainLife.hasParam("Defined") && "Targeted".equals(gainLife.getParam("Defined")) && numCards >= ((Player)oppA).getLife()) {
                    if (xPaid) {
                        root.setXManaCostPaid(((Player)oppA).getLife());
                    }
                    sa.getTargets().add((GameObject)oppA);
                    return true;
                }
                if (getPoison != null && ((Player)oppA).canReceiveCounters(CounterType.get(CounterEnumType.POISON)) && ((Player)oppA).getPoisonCounters() + numCards > 9) {
                    sa.getTargets().add((GameObject)oppA);
                    return true;
                }
                if (!logic.startsWith("LifeLessThan.")) continue;
                int threshold = Integer.parseInt(logic.substring(logic.indexOf(".") + 1));
                sa.getTargets().add((GameObject)oppA);
                return ai.getLife() < threshold;
            }
            boolean bl = aiTarget = sa.canTarget(ai) && (mandatory || ai.canDraw());
            if (aiTarget && !ai.cantLose()) {
                if (numCards >= computerLibrarySize - 3) {
                    if (xPaid) {
                        numCards = computerLibrarySize - 1;
                        if (numCards <= 0 && !mandatory) {
                            return false;
                        }
                    } else if (!ai.isCardInPlay("Laboratory Maniac")) {
                        aiTarget = false;
                    }
                }
                if (loseLife != null && ai.canLoseLife() && numCards >= ai.getLife() + 5) {
                    if (xPaid) {
                        if ((numCards = Math.min(numCards, ai.getLife() - 5)) <= 0) {
                            aiTarget = false;
                        }
                    } else {
                        aiTarget = false;
                    }
                }
                if (getPoison != null && ai.canReceiveCounters(CounterType.get(CounterEnumType.POISON)) && numCards + ai.getPoisonCounters() >= 8) {
                    aiTarget = false;
                }
                if (xPaid) {
                    root.setXManaCostPaid(numCards);
                }
            }
            if (aiTarget) {
                if (!ai.isCardInPlay("Laboratory Maniac") && computerHandSize + numCards > computerMaxHandSize && game.getPhaseHandler().isPlayerTurn(ai)) {
                    if (xPaid) {
                        numCards = computerMaxHandSize - computerHandSize;
                        if (source.isInZone(ZoneType.Hand)) {
                            ++numCards;
                        }
                        root.setXManaCostPaid(numCards);
                    } else if (!drawback && !mandatory) {
                        return false;
                    }
                }
                sa.getTargets().add(ai);
                return true;
            }
            for (Player ally : ai.getAllies()) {
                if (!sa.canTarget(ally) || !ally.canDraw() || xPaid || numCards >= ally.getCardsIn(ZoneType.Library).size() && !ally.isCardInPlay("Laboratory Maniac") || loseLife != null && ally.canLoseLife() && numCards < ai.getLife() - 5 || getPoison != null && ally.canReceiveCounters(CounterType.get(CounterEnumType.POISON)) && ally.getPoisonCounters() + numCards > 9) continue;
                sa.getTargets().add(ally);
                return true;
            }
            if (!mandatory) {
                return false;
            }
            Player oppMin = opps.min(PlayerPredicates.compareByLife());
            if (oppMin != null) {
                sa.getTargets().add(oppMin);
                return true;
            }
            Player result = players.min(PlayerPredicates.compareByLife());
            if (result != null) {
                sa.getTargets().add(result);
                return true;
            }
        } else if (!mandatory) {
            if (!(numCards != 0 && ai.canDraw() || drawback)) {
                return false;
            }
            if (numCards >= computerLibrarySize - 3) {
                return ai.isCardInPlay("Laboratory Maniac") && !ai.cantWin();
            }
            if (computerHandSize + numCards > computerMaxHandSize && game.getPhaseHandler().isPlayerTurn(ai) && !sa.isTrigger() && !assumeSafeX && !drawback) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!mandatory && !this.willPayCosts(ai, sa, sa.getPayCosts(), sa.getHostCard())) {
            return false;
        }
        return this.targetAI(ai, sa, mandatory);
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        int numCards;
        int n = numCards = sa.hasParam("NumCards") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumCards"), sa) : 1;
        if (numCards < player.getZone(ZoneType.Library).size()) {
            return true;
        }
        return player.isCardInPlay("Laboratory Maniac");
    }
}

