/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Map;

public class DigUntilAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        SpellAbility root;
        Card source = sa.getHostCard();
        String logic = sa.getParamOrDefault("AILogic", "");
        double chance = 0.4;
        if (DigUntilAi.isSorcerySpeed(sa, ai)) {
            chance = 0.667;
        }
        if (ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) && !ai.getGame().getPhaseHandler().isPlayerTurn(ai)) {
            chance = 1.0;
        }
        Player libraryOwner = ai;
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        if ("DontMillSelf".equals(logic)) {
            if (ai.getCardsIn(ZoneType.Library).size() < 20) {
                return false;
            }
            if ("Land.Basic".equals(sa.getParam("Valid")) && ai.getZone(ZoneType.Hand).contains(CardPredicates.Presets.LANDS_PRODUCING_MANA) && !ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) && !ai.getGame().getPhaseHandler().isPlayerTurn(ai)) {
                return false;
            }
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!sa.canTarget(opp)) {
                return false;
            }
            sa.getTargets().add(opp);
            libraryOwner = opp;
        } else if (sa.hasParam("Valid")) {
            String valid = sa.getParam("Valid");
            if (CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Library), valid, source.getController(), source, (CardTraitBase)sa).isEmpty()) {
                return false;
            }
        }
        String num = sa.getParam("Amount");
        if (num != null && num.equals("X") && sa.getSVar(num).equals("Count$xPaid") && (root = sa.getRootAbility()).getXManaCostPaid() == null) {
            int numCards = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            if (numCards <= 0) {
                return false;
            }
            root.setXManaCostPaid(numCards);
        }
        if (libraryOwner.getCardsIn(ZoneType.Library).isEmpty()) {
            return false;
        }
        boolean randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(chance, sa.getActivationsThisTurn() + 1);
        return randomReturn;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (sa.isCurse()) {
                for (Player opp : ai.getOpponents()) {
                    if (!sa.canTarget(opp)) continue;
                    sa.getTargets().add(opp);
                    break;
                }
                if (mandatory && sa.getTargets().isEmpty() && sa.canTarget(ai)) {
                    sa.getTargets().add(ai);
                }
            } else if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        String logic;
        if (sa.hasParam("AILogic") && "OathOfDruids".equals(logic = sa.getParam("AILogic"))) {
            CardCollection creaturesInLibrary = CardLists.filter((Iterable<Card>)player.getCardsIn(ZoneType.Library), CardPredicates.Presets.CREATURES);
            CardCollection creaturesInBattlefield = player.getCreaturesInPlay();
            return creaturesInLibrary.size() > 2 || creaturesInBattlefield.size() == 0 && creaturesInLibrary.size() > 0;
        }
        return true;
    }
}

